/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem;

import org.wikimodel.wem.WikiParameters;

public class WikiMacro {
    public static final String MACRO_TOC = "toc";
    public static final String MACRO_NOTOC = "notoc";
    public static final String MACRO_FORCETOC = "forcetoc";
    public static final String MACRO_FOOTNOTES = "footnotes";
    public static final String UNHANDLED_MACRO = "unhandled";
    private final String name;
    private final WikiParameters wikiParameters;
    private final String content;

    public WikiMacro(String name) {
        this(name, WikiParameters.EMPTY, null);
    }

    public WikiMacro(String name, WikiParameters wikiParameters) {
        this(name, wikiParameters, null);
    }

    public WikiMacro(String name, WikiParameters wikiParameters, String content) {
        this.name = name;
        this.content = content;
        this.wikiParameters = wikiParameters;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public WikiParameters getWikiParameters() {
        return this.wikiParameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WikiMacro other = (WikiMacro)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "{{" + this.name + " | " + this.content + " | " + this.wikiParameters + "}}";
    }
}

