/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.protocols.DUPL;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class DuplicateTest
extends ChannelTestBase {
    private JChannel c1;
    private JChannel c2;
    private JChannel c3;
    protected Address a1;
    protected Address a2;
    protected Address a3;
    private MyReceiver r1;
    private MyReceiver r2;
    private MyReceiver r3;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.createChannels(true, true, 2, 2);
        this.a1 = this.c1.getLocalAddress();
        this.a2 = this.c2.getLocalAddress();
        this.a3 = this.c3.getLocalAddress();
        this.r1 = new MyReceiver("C1");
        this.r2 = new MyReceiver("C2");
        this.r3 = new MyReceiver("C3");
        this.c1.setReceiver(this.r1);
        this.c2.setReceiver(this.r2);
        this.c3.setReceiver(this.r3);
    }

    @Override
    protected void tearDown() throws Exception {
        Util.close(this.c3, this.c2, this.c1);
        super.tearDown();
    }

    public void testRegularUnicastsToSelf() throws Exception {
        DuplicateTest.send(this.c1, this.c1.getLocalAddress(), false, 10);
        DuplicateTest.check(this.r1, 1, false, new Tuple<Address, Integer>(this.a1, 10));
    }

    public void testOOBUnicastsToSelf() throws Exception {
        DuplicateTest.send(this.c1, this.c1.getLocalAddress(), true, 10);
        DuplicateTest.check(this.r1, 1, true, new Tuple<Address, Integer>(this.a1, 10));
    }

    public void testRegularUnicastsToOthers() throws Exception {
        DuplicateTest.send(this.c1, this.c2.getLocalAddress(), false, 10);
        DuplicateTest.send(this.c1, this.c3.getLocalAddress(), false, 10);
        DuplicateTest.check(this.r2, 1, false, new Tuple<Address, Integer>(this.a1, 10));
        DuplicateTest.check(this.r3, 1, false, new Tuple<Address, Integer>(this.a1, 10));
    }

    public void testOOBUnicastsToOthers() throws Exception {
        DuplicateTest.send(this.c1, this.c2.getLocalAddress(), true, 10);
        DuplicateTest.send(this.c1, this.c3.getLocalAddress(), true, 10);
        DuplicateTest.check(this.r2, 1, true, new Tuple<Address, Integer>(this.a1, 10));
        DuplicateTest.check(this.r3, 1, true, new Tuple<Address, Integer>(this.a1, 10));
    }

    public void testRegularMulticastToAll() throws Exception {
        DuplicateTest.send(this.c1, null, false, 10);
        DuplicateTest.check(this.r1, 1, false, new Tuple<Address, Integer>(this.a1, 10));
        DuplicateTest.check(this.r2, 1, false, new Tuple<Address, Integer>(this.a1, 10));
        DuplicateTest.check(this.r3, 1, false, new Tuple<Address, Integer>(this.a1, 10));
    }

    public void testOOBMulticastToAll() throws Exception {
        DuplicateTest.send(this.c1, null, true, 10);
        DuplicateTest.check(this.r1, 1, true, new Tuple<Address, Integer>(this.a1, 10));
        DuplicateTest.check(this.r2, 1, true, new Tuple<Address, Integer>(this.a1, 10));
        DuplicateTest.check(this.r3, 1, true, new Tuple<Address, Integer>(this.a1, 10));
    }

    public void testRegularMulticastToAll3Senders() throws Exception {
        DuplicateTest.send(this.c1, null, false, 10);
        DuplicateTest.send(this.c2, null, false, 10);
        DuplicateTest.send(this.c3, null, false, 10);
        DuplicateTest.check(this.r1, 3, false, new Tuple<Address, Integer>(this.a1, 10), new Tuple<Address, Integer>(this.a2, 10), new Tuple<Address, Integer>(this.a3, 10));
        DuplicateTest.check(this.r2, 3, false, new Tuple<Address, Integer>(this.a1, 10), new Tuple<Address, Integer>(this.a2, 10), new Tuple<Address, Integer>(this.a3, 10));
        DuplicateTest.check(this.r3, 3, false, new Tuple<Address, Integer>(this.a1, 10), new Tuple<Address, Integer>(this.a2, 10), new Tuple<Address, Integer>(this.a3, 10));
    }

    public void testOOBMulticastToAll3Senders() throws Exception {
        DuplicateTest.send(this.c1, null, true, 10);
        DuplicateTest.send(this.c2, null, true, 10);
        DuplicateTest.send(this.c3, null, true, 10);
        DuplicateTest.check(this.r1, 3, true, new Tuple<Address, Integer>(this.a1, 10), new Tuple<Address, Integer>(this.a2, 10), new Tuple<Address, Integer>(this.a3, 10));
        DuplicateTest.check(this.r2, 3, true, new Tuple<Address, Integer>(this.a1, 10), new Tuple<Address, Integer>(this.a2, 10), new Tuple<Address, Integer>(this.a3, 10));
        DuplicateTest.check(this.r3, 3, true, new Tuple<Address, Integer>(this.a1, 10), new Tuple<Address, Integer>(this.a2, 10), new Tuple<Address, Integer>(this.a3, 10));
    }

    public void testMixedMulticastsToAll3Members() throws Exception {
        DuplicateTest.send(this.c1, null, false, true, 10);
        DuplicateTest.send(this.c2, null, false, true, 10);
        DuplicateTest.send(this.c3, null, false, true, 10);
        DuplicateTest.check(this.r1, 3, true, new Tuple<Address, Integer>(this.a1, 10), new Tuple<Address, Integer>(this.a2, 10), new Tuple<Address, Integer>(this.a3, 10));
        DuplicateTest.check(this.r2, 3, true, new Tuple<Address, Integer>(this.a1, 10), new Tuple<Address, Integer>(this.a2, 10), new Tuple<Address, Integer>(this.a3, 10));
        DuplicateTest.check(this.r3, 3, true, new Tuple<Address, Integer>(this.a1, 10), new Tuple<Address, Integer>(this.a2, 10), new Tuple<Address, Integer>(this.a3, 10));
    }

    private static void send(Channel sender_channel, Address dest, boolean oob, int num_msgs) throws Exception {
        DuplicateTest.send(sender_channel, dest, oob, false, num_msgs);
    }

    private static void send(Channel sender_channel, Address dest, boolean oob, boolean mixed, int num_msgs) throws Exception {
        long seqno = 1L;
        for (int i = 0; i < num_msgs; ++i) {
            Message msg = new Message(dest, null, Long.valueOf(seqno++));
            if (mixed) {
                if (i % 2 == 0) {
                    msg.setFlag((byte)1);
                }
            } else if (oob) {
                msg.setFlag((byte)1);
            }
            sender_channel.send(msg);
        }
        Util.sleep(500L);
    }

    private void createChannels(boolean copy_multicasts, boolean copy_unicasts, int num_outgoing_copies, int num_incoming_copies) throws Exception {
        this.c1 = this.createChannel();
        DUPL dupl = new DUPL(copy_multicasts, copy_unicasts, num_incoming_copies, num_outgoing_copies);
        ProtocolStack stack = this.c1.getProtocolStack();
        stack.insertProtocol((Protocol)dupl, 2, NAKACK.class);
        this.c2 = this.createChannel();
        this.c3 = this.createChannel();
        this.c1.connect("DuplicateTest");
        this.c2.connect("DuplicateTest");
        this.c3.connect("DuplicateTest");
        assert (this.c3.getView().size() == 3) : "view was " + this.c1.getView() + " but should have been 3";
    }

    private static void check(MyReceiver receiver, int expected_size, boolean oob, Tuple<Address, Integer> ... vals) {
        ConcurrentMap<Address, List<Long>> msgs = receiver.getMsgs();
        assert (msgs.size() == expected_size) : "expected size=" + expected_size + ", msgs: " + msgs.keySet();
        for (Tuple<Address, Integer> tuple : vals) {
            Address addr = tuple.getVal1();
            List list = (List)msgs.get(addr);
            System.out.println("[" + receiver.getName() + "]: " + addr + ": " + list);
            assert (list != null) : "no list available for " + addr;
            assert (list.size() == tuple.getVal2().intValue()) : "list's size is not " + tuple.getVal2() + ", list: " + list;
            if (!oob) {
                DuplicateTest.check(addr, list);
                continue;
            }
            DuplicateTest.checkPresence(addr, list);
        }
    }

    private static void check(Address addr, List<Long> list) {
        long id = list.get(0);
        for (long val : list) {
            assert (val == id) : "[" + addr + "]: val=" + val + " (expected " + id + "): list is " + list;
            ++id;
        }
    }

    private static void checkPresence(Address addr, List<Long> list) {
        for (long l = 1L; l <= 10L; ++l) {
            assert (list.contains(l)) : l + " is not in the list " + list;
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        final String name;
        private final ConcurrentMap<Address, List<Long>> msgs = new ConcurrentHashMap<Address, List<Long>>();

        public MyReceiver(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ConcurrentMap<Address, List<Long>> getMsgs() {
            return this.msgs;
        }

        @Override
        public void receive(Message msg) {
            List tmp;
            Address addr = msg.getSrc();
            Long val = (Long)msg.getObject();
            List<Long> list = (LinkedList<Long>)this.msgs.get(addr);
            if (list == null && (tmp = (List)this.msgs.putIfAbsent(addr, list = new LinkedList<Long>())) != null) {
                list = tmp;
            }
            list.add(val);
        }

        public void clear() {
            this.msgs.clear();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("receiver " + this.name).append(":\n");
            for (Map.Entry entry : this.msgs.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
            return sb.toString();
        }
    }
}

