/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiScorer;

abstract class AbstractWeight
extends Weight {
    protected final Searcher searcher;

    public AbstractWeight(Searcher searcher) {
        this.searcher = searcher;
    }

    protected abstract Scorer createScorer(IndexReader var1, boolean var2, boolean var3) throws IOException;

    public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
        if (reader instanceof MultiIndexReader) {
            MultiIndexReader mir = (MultiIndexReader)reader;
            IndexReader[] readers = mir.getIndexReaders();
            int[] starts = new int[readers.length + 1];
            int maxDoc = 0;
            for (int i = 0; i < readers.length; ++i) {
                starts[i] = maxDoc;
                maxDoc += readers[i].maxDoc();
            }
            starts[readers.length] = maxDoc;
            Scorer[] scorers = new Scorer[readers.length];
            for (int i = 0; i < readers.length; ++i) {
                scorers[i] = this.scorer(readers[i], scoreDocsInOrder, topScorer);
            }
            return new MultiScorer(this.searcher.getSimilarity(), scorers, starts);
        }
        return this.createScorer(reader, scoreDocsInOrder, topScorer);
    }
}

