/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.jpeg.JpegConstants;
import org.apache.sanselan.formats.jpeg.segments.Segment;

public class JFIFSegment
extends Segment
implements JpegConstants {
    public final int jfifMajorVersion;
    public final int jfifMinorVersion;
    public final int densityUnits;
    public final int xDensity;
    public final int yDensity;
    public final int xThumbnail;
    public final int yThumbnail;
    public final int thumbnailSize;

    public String getDescription() {
        return "JFIF (" + this.getSegmentType() + ")";
    }

    public JFIFSegment(int marker, byte[] segmentData) throws ImageReadException, IOException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public JFIFSegment(int marker, int marker_length, InputStream is) throws ImageReadException, IOException {
        super(marker, marker_length);
        byte[] signature = this.readBytes(is, JFIF0_SIGNATURE.length);
        if (!this.compareByteArrays(signature, JFIF0_SIGNATURE) && !this.compareByteArrays(signature, JFIF0_SIGNATURE_ALTERNATIVE)) {
            throw new ImageReadException("Not a Valid JPEG File: missing JFIF string");
        }
        this.jfifMajorVersion = this.readByte("JFIF_major_version", is, "Not a Valid JPEG File");
        this.jfifMinorVersion = this.readByte("JFIF_minor_version", is, "Not a Valid JPEG File");
        this.densityUnits = this.readByte("density_units", is, "Not a Valid JPEG File");
        this.xDensity = this.read2Bytes("x_density", is, "Not a Valid JPEG File");
        this.yDensity = this.read2Bytes("y_density", is, "Not a Valid JPEG File");
        this.xThumbnail = this.readByte("x_thumbnail", is, "Not a Valid JPEG File");
        this.yThumbnail = this.readByte("y_thumbnail", is, "Not a Valid JPEG File");
        this.thumbnailSize = this.xThumbnail * this.yThumbnail;
        if (this.thumbnailSize > 0) {
            this.skipBytes(is, this.thumbnailSize, "Not a Valid JPEG File: missing thumbnail");
        }
        if (this.getDebug()) {
            System.out.println("");
        }
    }
}

