/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.impl;

import java.util.List;
import org.wikimodel.wem.WikiParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiScannerUtil {
    private static final char DEFAULT_ESCAPECHAR = '\\';

    public static String extractSubstring(String str, String open, String close) {
        return WikiScannerUtil.extractSubstring(str, open, close, '\\', true);
    }

    public static String extractSubstring(String str, String open, String close, char escape) {
        return WikiScannerUtil.extractSubstring(str, open, close, escape, true);
    }

    public static String extractSubstring(String str, String open, String close, char escape, boolean cleanEscape) {
        int i;
        StringBuffer buf = new StringBuffer();
        int len = str.length();
        for (i = 0; i < len; ++i) {
            if (!str.startsWith(open, i)) continue;
            i += open.length();
            break;
        }
        boolean escaped = false;
        while (i < len) {
            char ch;
            if (escaped) {
                ch = str.charAt(i);
                buf.append(ch);
                escaped = false;
            } else {
                if (str.startsWith(close, i)) break;
                ch = str.charAt(i);
                boolean bl = escaped = ch == escape;
                if (!escaped || !cleanEscape) {
                    buf.append(ch);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static int getNextSequence(char[] array, int pos, char[] delimiter, StringBuffer buf) {
        buf.delete(0, buf.length());
        char quot = '\u0000';
        while (pos < array.length) {
            char ch = array[pos];
            if (quot != '\u0000') {
                if (ch == quot) {
                    quot = '\u0000';
                }
            } else if (ch == '\"') {
                quot = ch;
            } else {
                int i = WikiScannerUtil.skipSequence(array, pos, delimiter);
                if (i > pos) {
                    pos = i;
                    break;
                }
            }
            buf.append(ch);
            ++pos;
        }
        return pos;
    }

    private static int getNextToken(char[] array, int pos, char[] delimiter, StringBuffer buf, boolean[] trim, char escapeChar) {
        buf.delete(0, buf.length());
        boolean escaped = false;
        if (pos < array.length && (array[pos] == '\'' || array[pos] == '\"')) {
            trim[0] = false;
            char endChar = array[pos];
            ++pos;
            while (pos < array.length && (escaped || array[pos] != endChar)) {
                if (escaped) {
                    buf.append(array[pos]);
                    escaped = false;
                } else {
                    boolean bl = escaped = array[pos] == escapeChar;
                    if (!escaped) {
                        buf.append(array[pos]);
                    }
                }
                ++pos;
            }
            if (pos < array.length) {
                ++pos;
            }
        } else {
            trim[0] = true;
            while (pos < array.length) {
                if (escaped) {
                    buf.append(array[pos]);
                    escaped = false;
                } else {
                    if (array[pos] == '=' || WikiScannerUtil.skipSequence(array, pos, delimiter) > pos || array[pos] == '\'' || array[pos] == '\"') break;
                    boolean bl = escaped = array[pos] == escapeChar;
                    if (!escaped) {
                        buf.append(array[pos]);
                    }
                }
                ++pos;
            }
        }
        return pos;
    }

    public static boolean matchesSequence(char[] array, int arrayPos, char[] sequence) {
        int j;
        int i = arrayPos;
        for (j = 0; i < array.length && j < sequence.length && array[i] == sequence[j]; ++i, ++j) {
        }
        return j == sequence.length;
    }

    private static int removeSpaces(char[] array, int pos, StringBuffer buf) {
        buf.delete(0, buf.length());
        while (pos < array.length && (array[pos] == '=' || Character.isSpaceChar(array[pos]))) {
            if (array[pos] == '=') {
                buf.append(array[pos]);
            }
            ++pos;
        }
        return pos;
    }

    public static int skipSequence(char[] array, int arrayPos, char[] sequence) {
        int j;
        int i = arrayPos;
        for (j = 0; i < array.length && j < sequence.length && array[i] == sequence[j]; ++i, ++j) {
        }
        return j == sequence.length ? i : arrayPos;
    }

    public static int splitToPairs(String str, List<WikiParameter> list) {
        return WikiScannerUtil.splitToPairs(str, list, null);
    }

    public static int splitToPairs(String str, List<WikiParameter> list, char escapeChar) {
        return WikiScannerUtil.splitToPairs(str, list, null, null, escapeChar);
    }

    public static int splitToPairs(String str, List<WikiParameter> list, String delimiter) {
        return WikiScannerUtil.splitToPairs(str, list, delimiter, null);
    }

    public static int splitToPairs(String str, List<WikiParameter> list, String delimiter, String end) {
        return WikiScannerUtil.splitToPairs(str, list, delimiter, end, '\\');
    }

    public static int splitToPairs(String str, List<WikiParameter> list, String delimiter, String end, char escapeChar) {
        if (str == null) {
            return 0;
        }
        char[] array = str.toCharArray();
        if (delimiter == null) {
            delimiter = " ";
        }
        char[] delimiterArray = delimiter.toCharArray();
        char[] endArray = end != null ? end.toCharArray() : new char[]{};
        StringBuffer buf = new StringBuffer();
        int i = 0;
        boolean[] trim = new boolean[]{false};
        while (i < array.length) {
            String key = null;
            String value = null;
            if ((i = WikiScannerUtil.removeSpaces(array, i, buf)) >= array.length) break;
            int prev = i;
            if ((i = WikiScannerUtil.skipSequence(array, i, delimiterArray)) >= array.length || i > prev && (i = WikiScannerUtil.removeSpaces(array, i, buf)) >= array.length || end != null && WikiScannerUtil.matchesSequence(array, i, endArray)) break;
            i = WikiScannerUtil.getNextToken(array, i, delimiterArray, buf, trim, escapeChar);
            key = buf.toString().trim();
            i = WikiScannerUtil.removeSpaces(array, i, buf);
            if (buf.indexOf("=") >= 0) {
                i = WikiScannerUtil.getNextToken(array, i, delimiterArray, buf, trim, escapeChar);
                value = buf.toString();
                if (trim[0]) {
                    value = value.trim();
                }
            }
            WikiParameter entry = new WikiParameter(key, value);
            list.add(entry);
        }
        return i;
    }

    public static String unescape(String str) {
        return WikiScannerUtil.unescape(str, '\\');
    }

    public static String unescape(String str, char escape) {
        if (str == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char[] array = str.toCharArray();
        boolean escaped = false;
        for (int i = 0; i < array.length; ++i) {
            char ch = array[i];
            if (escaped) {
                buf.append(ch);
                escaped = false;
                continue;
            }
            boolean bl = escaped = ch == escape;
            if (escaped) continue;
            buf.append(ch);
        }
        return buf.toString();
    }
}

