/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.servlet.GadgetsHandlerApi;
import org.apache.shindig.gadgets.servlet.GadgetsHandlerService;
import org.apache.shindig.gadgets.servlet.RpcException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.protocol.BaseRequestItem;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.protocol.conversion.BeanDelegator;
import org.apache.shindig.protocol.conversion.BeanFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="gadgets")
public class GadgetsHandler {
    @VisibleForTesting
    static final String FAILURE_METADATA = "Failed to get gadget metadata.";
    @VisibleForTesting
    static final String FAILURE_TOKEN = "Failed to get gadget token.";
    private static final List<String> DEFAULT_METADATA_FIELDS = ImmutableList.of((Object)"iframeUrl", (Object)"userPrefs.*", (Object)"modulePrefs.*", (Object)"views.*", (Object)"token");
    private static final List<String> DEFAULT_TOKEN_FIELDS = ImmutableList.of((Object)"token");
    protected final ExecutorService executor;
    protected final GadgetsHandlerService handlerService;
    protected final BeanFilter beanFilter;
    protected final BeanDelegator beanDelegator;

    @Inject
    public GadgetsHandler(ExecutorService executor, GadgetsHandlerService handlerService, BeanFilter beanFilter) {
        this.executor = executor;
        this.handlerService = handlerService;
        this.beanFilter = beanFilter;
        this.beanDelegator = new BeanDelegator();
    }

    @Operation(httpMethods={"POST", "GET"}, path="metadata.get")
    public Map<String, GadgetsHandlerApi.BaseResponse> metadata(BaseRequestItem request) throws ProtocolException {
        return new AbstractExecutor<GadgetsHandlerApi.MetadataResponse>(){

            @Override
            protected Callable<GadgetsHandlerApi.MetadataResponse> createJob(String url, BaseRequestItem request) {
                return GadgetsHandler.this.createMetadataJob(url, request);
            }
        }.execute(request);
    }

    @Operation(httpMethods={"POST", "GET"}, path="token.get")
    public Map<String, GadgetsHandlerApi.BaseResponse> token(BaseRequestItem request) throws ProtocolException {
        return new AbstractExecutor<GadgetsHandlerApi.TokenResponse>(){

            @Override
            protected Callable<GadgetsHandlerApi.TokenResponse> createJob(String url, BaseRequestItem request) {
                return GadgetsHandler.this.createTokenJob(url, request);
            }
        }.execute(request);
    }

    @Operation(httpMethods={"GET"}, path="/@metadata.supportedFields")
    public Set<String> supportedFields(RequestItem request) {
        return ImmutableSet.copyOf((Collection)this.beanFilter.getBeanFields(GadgetsHandlerApi.MetadataResponse.class, 5));
    }

    @Operation(httpMethods={"GET"}, path="/@token.supportedFields")
    public Set<String> tokenSupportedFields(RequestItem request) {
        return ImmutableSet.copyOf((Collection)this.beanFilter.getBeanFields(GadgetsHandlerApi.TokenResponse.class, 5));
    }

    protected Callable<GadgetsHandlerApi.MetadataResponse> createMetadataJob(String url, BaseRequestItem request) {
        final MetadataRequestData metadataRequest = new MetadataRequestData(url, request);
        return new Callable<GadgetsHandlerApi.MetadataResponse>(){

            @Override
            public GadgetsHandlerApi.MetadataResponse call() throws Exception {
                try {
                    return GadgetsHandler.this.handlerService.getMetadata(metadataRequest);
                }
                catch (Exception e) {
                    GadgetsHandler.this.sendError(metadataRequest.getUrl(), e, GadgetsHandler.FAILURE_METADATA);
                    return null;
                }
            }
        };
    }

    protected Callable<GadgetsHandlerApi.TokenResponse> createTokenJob(String url, BaseRequestItem request) {
        final TokenRequestData tokenRequest = new TokenRequestData(url, request);
        return new Callable<GadgetsHandlerApi.TokenResponse>(){

            @Override
            public GadgetsHandlerApi.TokenResponse call() throws Exception {
                try {
                    return GadgetsHandler.this.handlerService.getToken(tokenRequest);
                }
                catch (Exception e) {
                    GadgetsHandler.this.sendError(tokenRequest.getUrl(), e, GadgetsHandler.FAILURE_TOKEN);
                    return null;
                }
            }
        };
    }

    private void sendError(final Uri url, Exception e, String msg) throws RpcException {
        GadgetContext context = new GadgetContext(){

            public Uri getUrl() {
                return url;
            }
        };
        throw new RpcException(context, msg, e);
    }

    protected class MetadataRequestData
    extends AbstractRequest
    implements GadgetsHandlerApi.MetadataRequest {
        protected final Locale locale;
        protected final boolean ignoreCache;
        protected final boolean debug;

        public MetadataRequestData(String url, BaseRequestItem request) {
            super(url, request, DEFAULT_METADATA_FIELDS);
            String lang = request.getParameter("language");
            String country = request.getParameter("country");
            this.locale = lang != null && country != null ? new Locale(lang, country) : (lang != null ? new Locale(lang) : GadgetSpec.DEFAULT_LOCALE);
            this.ignoreCache = Boolean.valueOf(request.getParameter("ignoreCache"));
            this.debug = Boolean.valueOf(request.getParameter("debug"));
        }

        public int getModuleId() {
            return 1;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean getIgnoreCache() {
            return this.ignoreCache;
        }

        public boolean getDebug() {
            return this.debug;
        }

        public String getView() {
            return this.request.getParameter("view", "default");
        }

        public GadgetsHandlerApi.TokenData getToken() {
            return (GadgetsHandlerApi.TokenData)GadgetsHandler.this.beanDelegator.createDelegator((Object)this.request.getToken(), GadgetsHandlerApi.TokenData.class);
        }
    }

    protected class TokenRequestData
    extends AbstractRequest
    implements GadgetsHandlerApi.TokenRequest {
        public TokenRequestData(String url, BaseRequestItem request) {
            super(url, request, DEFAULT_TOKEN_FIELDS);
        }

        public GadgetsHandlerApi.TokenData getToken() {
            return (GadgetsHandlerApi.TokenData)GadgetsHandler.this.beanDelegator.createDelegator((Object)this.request.getToken(), GadgetsHandlerApi.TokenData.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractRequest
    implements GadgetsHandlerApi.BaseRequest {
        protected final Uri uri;
        protected final String container;
        protected final List<String> fields;
        protected final BaseRequestItem request;

        public AbstractRequest(String url, BaseRequestItem request, List<String> defaultFields) {
            this.uri = Uri.parse((String)((String)Preconditions.checkNotNull((Object)url)));
            this.request = (BaseRequestItem)Preconditions.checkNotNull((Object)request);
            this.container = (String)Preconditions.checkNotNull((Object)request.getParameter("container"));
            this.fields = this.processFields(request, defaultFields);
        }

        @Override
        public Uri getUrl() {
            return this.uri;
        }

        @Override
        public String getContainer() {
            return this.container;
        }

        @Override
        public List<String> getFields() {
            return this.fields;
        }

        private List<String> processFields(BaseRequestItem request, List<String> defaultList) {
            List value = request.getListParameter("fields");
            return value == null || value.size() == 0 ? defaultList : value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractExecutor<R extends GadgetsHandlerApi.BaseResponse> {
        private AbstractExecutor() {
        }

        public Map<String, GadgetsHandlerApi.BaseResponse> execute(BaseRequestItem request) {
            ImmutableSet gadgetUrls = ImmutableSet.copyOf((Collection)request.getListParameter("ids"));
            if (gadgetUrls.isEmpty()) {
                return ImmutableMap.of();
            }
            ExecutorCompletionService<R> completionService = new ExecutorCompletionService<R>(GadgetsHandler.this.executor);
            for (String gadgetUrl : gadgetUrls) {
                Callable<R> job = this.createJob(gadgetUrl, request);
                completionService.submit(job);
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int numJobs = gadgetUrls.size(); numJobs > 0; --numJobs) {
                try {
                    GadgetsHandlerApi.BaseResponse response = (GadgetsHandlerApi.BaseResponse)completionService.take().get();
                    builder.put((Object)response.getUrl().toString(), (Object)response);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new ProtocolException(500, "Processing interrupted.", (Throwable)e);
                }
                catch (ExecutionException e) {
                    if (!(e.getCause() instanceof RpcException)) {
                        throw new ProtocolException(500, "Processing error.", (Throwable)e);
                    }
                    RpcException cause = (RpcException)e.getCause();
                    GadgetContext context = cause.getContext();
                    if (context == null) continue;
                    Uri url = context.getUrl();
                    GadgetsHandlerApi.BaseResponse errorResponse = GadgetsHandler.this.handlerService.createBaseResponse(url, cause.getMessage());
                    builder.put((Object)url.toString(), (Object)errorResponse);
                }
            }
            return builder.build();
        }

        protected abstract Callable<R> createJob(String var1, BaseRequestItem var2);
    }
}

