/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.upgrade;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ks.upgrade.UpgradeUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeWikiPlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger(UpgradeWikiPlugin.class);

    public UpgradeWikiPlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        log.info((Object)String.format("\n\n\n\n -----------> Migrating data from %s to %s for Wiki......\n\n\n", oldVersion, newVersion));
        try {
            log.info((Object)"\n\nRegister new nodeTypes...\n");
            UpgradeUtils.registerNodeTypes("jar:/conf/portal/wiki-migrate-nodetypes.xml", 4);
        }
        catch (Exception e) {
            log.warn((Object)String.format("[UpgradeWikiPlugin] Exception when migrate data from %s to %s for Wiki.", oldVersion, newVersion), (Throwable)e);
        }
        log.info((Object)"\n\n\n\n -----------> End Wiki Migration......\n\n\n");
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isBefore((String)previousVersion, (String)newVersion);
    }
}

