/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.table;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.TableCellBlock;
import org.xwiki.rendering.block.TableHeadCellBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="table-row")
public class TableRowMacro
extends AbstractMacro<Object> {
    private static final String DESCRIPTION = "Inserts a table row.";
    @Inject
    private ComponentManager componentManager;

    public TableRowMacro() {
        super("TableRow", DESCRIPTION);
        this.setDefaultCategory("Formatting");
    }

    public List<Block> execute(Object parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM parsedDom;
        Parser parser = this.getSyntaxParser(context.getSyntax().toIdString());
        try {
            parsedDom = parser.parse((Reader)new StringReader(content));
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "] with Syntax parser [" + parser.getSyntax() + "]", (Throwable)e);
        }
        List potentialCells = parsedDom.getChildrenByType(MacroBlock.class, false);
        int count = this.countCells(potentialCells);
        if (count == 0) {
            throw new MacroExecutionException("TableRow macro expect at least one cell macro as first-level children");
        }
        this.makeCells(potentialCells);
        return Collections.singletonList(parsedDom);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected Parser getSyntaxParser(String syntaxId) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.lookup(Parser.class, syntaxId);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser", (Throwable)e);
        }
    }

    private int countCells(List<MacroBlock> blocks) {
        int result = 0;
        for (MacroBlock maybeCell : blocks) {
            if (!maybeCell.getId().equals("table-cell") && !maybeCell.getId().equals("td") && !maybeCell.getId().equals("th")) continue;
            ++result;
        }
        return result;
    }

    private void makeCells(List<MacroBlock> blocks) {
        for (MacroBlock probablyCell : blocks) {
            if (!probablyCell.getId().equals("table-cell") && !probablyCell.getId().equals("td") && !probablyCell.getId().equals("th")) continue;
            LinkedHashMap params = new LinkedHashMap();
            Object cellBlock = probablyCell.getId().equals("th") ? new TableHeadCellBlock(Collections.singletonList(probablyCell.clone()), params) : new TableCellBlock(Collections.singletonList(probablyCell.clone()), params);
            probablyCell.getParent().replaceChild((Block)cellBlock, (Block)probablyCell);
        }
    }
}

