/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.wikimodel.wem.WikiParameter;
import org.wikimodel.wem.WikiParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;

@Component
@Named(value="xhtmlmarker")
@Singleton
public class XHTMLMarkerResourceReferenceParser
implements ResourceReferenceParser {
    private static final String COMMENT_SEPARATOR = "|-|";

    public ResourceReference parse(String rawReference) {
        String[] tokens = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)rawReference, (String)COMMENT_SEPARATOR);
        boolean isTyped = tokens[0].equalsIgnoreCase("true");
        ResourceType type = new ResourceType(tokens[1]);
        String reference = tokens[2];
        ResourceReference resourceReference = new ResourceReference(reference, type);
        resourceReference.setTyped(isTyped);
        if (tokens.length == 4) {
            for (WikiParameter parameter : WikiParameters.newWikiParameters((String)tokens[3])) {
                resourceReference.setParameter(parameter.getKey(), parameter.getValue());
            }
        }
        return resourceReference;
    }
}

