/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.test.jcr;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestClassLoader
extends ClassLoader {
    private final Set<String> rootConfigPaths;
    private final Set<String> portalConfigPaths;
    private Logger log = LoggerFactory.getLogger(TestClassLoader.class);

    public TestClassLoader(ClassLoader parent, Set<String> rootConfigPaths, Set<String> portalConfigPaths) {
        super(parent);
        this.rootConfigPaths = rootConfigPaths;
        this.portalConfigPaths = portalConfigPaths;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if ("conf/configuration.xml".equals(name)) {
            this.log.info((Object)"About to load root configuration");
            return this.getResourceURLs(this.rootConfigPaths);
        }
        if ("conf/portal/configuration.xml".equals(name)) {
            this.log.info((Object)"About to load portal configuration");
            return this.getResourceURLs(this.portalConfigPaths);
        }
        if ("conf/portal/test-configuration.xml".equals(name)) {
            return new Vector().elements();
        }
        return super.getResources(name);
    }

    private Enumeration<URL> getResourceURLs(Set<String> paths) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            ArrayList<URL> resourceURLs = Collections.list(super.getResources(path));
            this.log.info((Object)("Want to load for resource named " + path + " the urls " + resourceURLs));
            urls.addAll(resourceURLs);
        }
        return Collections.enumeration(urls);
    }
}

