/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.test.mock;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Value;
import org.mockito.Mockito;

public class JCRMockUtils {
    public static Node mockNode() {
        return (Node)Mockito.mock(Node.class);
    }

    public static void stubNullProperty(Node node, String propName) throws Exception {
        Property prop = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node.getProperty(propName)).thenReturn((Object)prop);
        Mockito.when((Object)prop.getValues()).thenThrow(new Throwable[]{new PathNotFoundException()});
    }

    public static void stubProperty(Node node, String propName, String ... svalues) throws Exception {
        Property prop = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node.getProperty(propName)).thenReturn((Object)prop);
        Value[] values = new Value[svalues.length];
        for (int i = 0; i < svalues.length; ++i) {
            values[i] = JCRMockUtils.stubValue(svalues[i]);
        }
        Mockito.when((Object)prop.getValues()).thenReturn((Object)values);
    }

    public static Value stubValue(String sValue) throws Exception {
        Value v = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)v.getString()).thenReturn((Object)sValue);
        return v;
    }
}

