/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.exoplatform.ks.test.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertUtils {
    private AssertUtils() {
    }

    public static <T> void assertContains(Collection<T> actual, T ... expected) {
        for (T item : expected) {
            boolean found = false;
            for (T obj : actual) {
                if (!obj.equals(item)) continue;
                found = true;
            }
            Assert.assertTrue((String)("expected item was not found " + item + "@" + item.hashCode()), (boolean)found);
        }
    }

    public static <T> void assertNotContains(Collection<T> actual, T ... expected) {
        Assert.assertFalse((boolean)actual.containsAll(Arrays.asList(expected)));
    }

    public static void assertContains(List<String> actual, String ... expected) {
        for (String item : expected) {
            boolean found = false;
            for (String obj : actual) {
                if (!obj.equals(item)) continue;
                found = true;
            }
            Assert.assertTrue((String)("expected item was not found " + item + "@" + item.hashCode()), (boolean)found);
        }
    }

    public static void assertContains(String[] actual, String ... expected) {
        Assert.assertTrue((boolean)Arrays.asList(actual).containsAll(Arrays.asList(expected)));
    }

    public static void assertNotContains(List<String> actual, String ... expected) {
        Assert.assertFalse((boolean)actual.containsAll(Arrays.asList(expected)));
    }

    public static void assertEmpty(Collection value) {
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)0, (int)value.size());
    }

    public static <T> void assertNotEmpty(Collection<T> value) {
        Assert.assertNotNull(value);
        Assert.assertTrue((value.size() > 0 ? 1 : 0) != 0);
    }

    public static <T> void assertEmpty(T[] value) {
        Assert.assertNotNull(value);
        Assert.assertEquals((int)0, (int)value.length);
    }

    public static void assertContainsAll(String message, List<String> expected, List<String> actual) {
        Assert.assertEquals((String)message, (int)expected.size(), (int)actual.size());
        Assert.assertTrue((String)message, (boolean)expected.containsAll(actual));
    }

    public static void assertEquals(String message, String[] expected, String[] actual) {
        Assert.assertEquals((String)message, (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)message, (String)expected[i], (String)actual[i]);
        }
    }

    public static void assertException(Closure code) {
        try {
            code.dothis();
        }
        catch (Exception e) {
            return;
        }
        throw new AssertionFailedError("An exception should have been thrown.");
    }

    public static void assertException(Class<? extends Exception> exceptionType, Closure code) {
        try {
            code.dothis();
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Wrong exception type", exceptionType, e.getClass());
            return;
        }
        throw new AssertionFailedError("An exception should have been thrown.");
    }
}

