/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.test.mock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfileHandler;

public class SimpleMockOrganizationService
implements OrganizationService {
    private Set<SimpleMembership> storage = new HashSet<SimpleMembership>();

    public void addMemberships(String user, String ... membershipExprs) {
        for (String membershipExpr : membershipExprs) {
            String membershipType = "*";
            String group = membershipExpr;
            if (membershipExpr.indexOf(58) > 0) {
                String[] parts = membershipExpr.split(":");
                membershipType = parts[0];
                group = parts[1];
            }
            this.storage.add(new SimpleMembership(user, group, membershipType));
        }
    }

    public GroupHandler getGroupHandler() {
        return new MockGroupHandler();
    }

    public MembershipHandler getMembershipHandler() {
        return new MockMembershipHandler();
    }

    public MembershipTypeHandler getMembershipTypeHandler() {
        return null;
    }

    public UserHandler getUserHandler() {
        return new MockUserHandler();
    }

    public UserProfileHandler getUserProfileHandler() {
        return null;
    }

    public void addListenerPlugin(ComponentPlugin listener) throws Exception {
    }

    static class SimpleMembership
    implements Membership {
        String user;
        String group;
        String membershipType;

        public SimpleMembership(String user, String group, String membershipType) {
            this.user = user;
            this.group = group;
            this.membershipType = membershipType;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Membership)) {
                return false;
            }
            Membership other = (Membership)obj;
            return this.user.equals(other.getUserName()) && this.group.equals(other.getGroupId()) && this.membershipType.equals(other.getMembershipType());
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.getId();
        }

        public String getGroupId() {
            return this.group;
        }

        public String getId() {
            return this.user + "@" + this.membershipType + ":" + this.group;
        }

        public String getMembershipType() {
            return this.membershipType;
        }

        public String getUserName() {
            return this.user;
        }

        public void setMembershipType(String type) {
        }
    }

    static class SimpleGroup
    implements Group {
        String id = null;

        public SimpleGroup(String id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Group)) {
                return false;
            }
            Group other = (Group)obj;
            return this.id.equals(other.getId());
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.getId();
        }

        public String getDescription() {
            return this.id;
        }

        public String getGroupName() {
            return this.id.substring(this.id.lastIndexOf(47) + 1);
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.id;
        }

        public String getParentId() {
            return this.id.substring(0, this.id.lastIndexOf(47));
        }

        public void setDescription(String desc) {
        }

        public void setGroupName(String name) {
        }

        public void setLabel(String name) {
        }
    }

    static class SimpleUser
    implements User {
        String name = null;

        public SimpleUser(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof User)) {
                return false;
            }
            User other = (User)obj;
            return this.name.equals(other.getUserName());
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.name;
        }

        public Date getCreatedDate() {
            return new Date();
        }

        public String getEmail() {
            return this.name;
        }

        public String getFirstName() {
            return this.name;
        }

        public String getFullName() {
            return this.name;
        }

        public Date getLastLoginTime() {
            return new Date();
        }

        public String getLastName() {
            return this.name;
        }

        public String getOrganizationId() {
            return this.name;
        }

        public String getPassword() {
            return this.name;
        }

        public String getUserName() {
            return this.name;
        }

        public void setCreatedDate(Date t) {
        }

        public void setEmail(String s) {
        }

        public void setFirstName(String s) {
        }

        public void setFullName(String s) {
        }

        public void setLastLoginTime(Date t) {
        }

        public void setLastName(String s) {
        }

        public void setOrganizationId(String organizationId) {
        }

        public void setPassword(String s) {
        }

        public void setUserName(String s) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MockUserHandler
    implements UserHandler {
        MockUserHandler() {
        }

        public void saveUser(User user, boolean broadcast) throws Exception {
        }

        public User removeUser(String userName, boolean broadcast) throws Exception {
            return null;
        }

        public PageList<User> getUserPageList(int pageSize) throws Exception {
            Iterator mbIt = SimpleMockOrganizationService.this.storage.iterator();
            HashSet<SimpleUser> userSet = new HashSet<SimpleUser>();
            while (mbIt.hasNext()) {
                SimpleMembership membership = (SimpleMembership)mbIt.next();
                userSet.add(new SimpleUser(membership.getUserName()));
            }
            return new ObjectPageList(Arrays.asList(userSet.toArray()), pageSize);
        }

        public PageList<User> findUsersByGroup(String groupId) throws Exception {
            Iterator mbIt = SimpleMockOrganizationService.this.storage.iterator();
            HashSet<SimpleUser> userSet = new HashSet<SimpleUser>();
            while (mbIt.hasNext()) {
                SimpleMembership membership = (SimpleMembership)mbIt.next();
                if (!membership.getGroupId().equals(groupId)) continue;
                userSet.add(new SimpleUser(membership.getUserName()));
            }
            return new ObjectPageList(Arrays.asList(userSet.toArray()), 10);
        }

        public PageList<User> findUsers(Query query) throws Exception {
            Iterator mbIt = SimpleMockOrganizationService.this.storage.iterator();
            HashSet<SimpleUser> userSet = new HashSet<SimpleUser>();
            while (mbIt.hasNext()) {
                SimpleMembership membership = (SimpleMembership)mbIt.next();
                String userName = membership.getUserName();
                if (!query.getUserName().equals(userName)) continue;
                userSet.add(new SimpleUser(membership.getUserName()));
            }
            return new ObjectPageList(Arrays.asList(userSet.toArray()), 10);
        }

        public User findUserByName(String userName) throws Exception {
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                if (!membership.getUserName().equals(userName)) continue;
                return new SimpleUser(userName);
            }
            return null;
        }

        public User createUserInstance(String username) {
            return null;
        }

        public User createUserInstance() {
            return null;
        }

        public void createUser(User user, boolean broadcast) throws Exception {
        }

        public boolean authenticate(String username, String password) throws Exception {
            return false;
        }

        public void addUserEventListener(UserEventListener listener) {
        }

        public ListAccess<User> findAllUsers() throws Exception {
            return null;
        }

        public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
            return null;
        }

        public ListAccess<User> findUsersByQuery(Query query) throws Exception {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MockMembershipHandler
    implements MembershipHandler {
        public Collection<Membership> removeMembershipByUser(String username, boolean broadcast) throws Exception {
            return null;
        }

        public Membership removeMembership(String id, boolean broadcast) throws Exception {
            return null;
        }

        public void linkMembership(User user, Group group, MembershipType m, boolean broadcast) throws Exception {
            SimpleMockOrganizationService.this.addMemberships(user.getUserName(), m.getName() + ":" + group.getId());
        }

        public Collection<Membership> findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
            HashSet<Membership> memberships = new HashSet<Membership>();
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                if (!membership.getUserName().equals(userName) || !membership.getGroupId().equals(groupId)) continue;
                memberships.add(membership);
            }
            return memberships;
        }

        public Collection<Membership> findMembershipsByUser(String userName) throws Exception {
            HashSet<Membership> memberships = new HashSet<Membership>();
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                if (!membership.getUserName().equals(userName)) continue;
                memberships.add(membership);
            }
            return memberships;
        }

        public Collection<Membership> findMembershipsByGroup(Group group) throws Exception {
            HashSet<Membership> memberships = new HashSet<Membership>();
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                if (!membership.getGroupId().equals(group.getId())) continue;
                memberships.add(membership);
            }
            return memberships;
        }

        public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                if (!membership.getUserName().equals(userName) || !membership.getGroupId().equals(groupId) || !membership.getMembershipType().equals(type)) continue;
                return membership;
            }
            return null;
        }

        public Membership findMembership(String id) throws Exception {
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                if (!membership.getId().equals(id)) continue;
                return membership;
            }
            return null;
        }

        public Membership createMembershipInstance() {
            return null;
        }

        public void createMembership(Membership m, boolean broadcast) throws Exception {
        }

        public void addMembershipEventListener(MembershipEventListener listener) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MockGroupHandler
    implements GroupHandler {
        MockGroupHandler() {
        }

        public void saveGroup(Group group, boolean broadcast) throws Exception {
        }

        public Group removeGroup(Group group, boolean broadcast) throws Exception {
            return null;
        }

        public Collection<Group> getAllGroups() throws Exception {
            HashSet<Group> groups = new HashSet<Group>();
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                groups.add(new SimpleGroup(membership.getGroupId()));
            }
            return groups;
        }

        public Collection<Group> findGroupsOfUser(String user) throws Exception {
            HashSet<Group> groups = new HashSet<Group>();
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                if (!membership.getUserName().equals(user)) continue;
                groups.add(new SimpleGroup(membership.getGroupId()));
            }
            return groups;
        }

        public Collection<Group> findGroups(Group parent) throws Exception {
            HashSet<Group> groups = new HashSet<Group>();
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                SimpleGroup group = new SimpleGroup(membership.getGroupId());
                if (!group.getParentId().equals(parent.getId())) continue;
                groups.add(group);
            }
            return groups;
        }

        public Collection<Group> findGroupByMembership(String userName, String membershipType) throws Exception {
            HashSet<Group> groups = new HashSet<Group>();
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                if (!membership.getUserName().equals(userName) || !membership.getMembershipType().equals(membershipType)) continue;
                groups.add(new SimpleGroup(membership.getGroupId()));
            }
            return groups;
        }

        public Group findGroupById(String groupId) throws Exception {
            for (SimpleMembership membership : SimpleMockOrganizationService.this.storage) {
                SimpleGroup group = new SimpleGroup(membership.getGroupId());
                if (!group.getId().equals(groupId)) continue;
                return group;
            }
            return null;
        }

        public Group createGroupInstance() {
            return null;
        }

        public void createGroup(Group group, boolean broadcast) throws Exception {
        }

        public void addGroupEventListener(GroupEventListener listener) {
        }

        public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        }
    }
}

