/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.connection.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.xmpp.bean.ConfigRoomBean;
import org.exoplatform.services.xmpp.bean.EventsBean;
import org.exoplatform.services.xmpp.bean.FullRoomInfoBean;
import org.exoplatform.services.xmpp.bean.MUCPacketBean;
import org.exoplatform.services.xmpp.bean.MessageBean;
import org.exoplatform.services.xmpp.bean.PresenceBean;
import org.exoplatform.services.xmpp.connection.XMPPSession;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.services.xmpp.ext.transport.Transport;
import org.exoplatform.services.xmpp.filter.MessageFilter;
import org.exoplatform.services.xmpp.filter.PresenceFilter;
import org.exoplatform.services.xmpp.filter.SubscriptionFilter;
import org.exoplatform.services.xmpp.groupchat.MultiUserChatManager;
import org.exoplatform.services.xmpp.history.HistoricalMessage;
import org.exoplatform.services.xmpp.history.Interlocutor;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;
import org.exoplatform.services.xmpp.userinfo.OrganizationUserInfoServiceImpl;
import org.exoplatform.services.xmpp.userinfo.UserInfo;
import org.exoplatform.services.xmpp.util.HistoryUtils;
import org.exoplatform.services.xmpp.util.StringUtils;
import org.exoplatform.services.xmpp.util.TransformUtils;
import org.exoplatform.services.xmpp.util.XMPPConnectionUtils;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.search.UserSearchManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPPSessionImpl
implements XMPPSession {
    private static final String GRANT = "grant";
    private static final String REVOKE = "revoke";
    private static final String MODERATOR = "moderator";
    private static final String ADMIN = "admin";
    private static final String NONE = "none";
    private static final String PARTICIPANT = "participant";
    private static final String OWNER = "owner";
    private static final String MEMBER = "member";
    private static final String OUTCAST = "outcast";
    private final XMPPConnection connection_;
    private final String username_;
    private boolean alive_ = true;
    private Presence presence;
    private MultiUserChatManager multiUserChatManager;
    private Queue<EventsBean> eventBeanQueue;
    private long awayTime;
    private SessionProvider sessionProvider;
    private long closeTime;
    private int disconnectTime;
    private HistoryImpl historyImpl;
    private final Log log = ExoLogger.getLogger((String)"XMPPSessionImpl");
    private OrganizationUserInfoServiceImpl userInfoServiceImpl;

    protected XMPPSessionImpl(String username, String password) throws XMPPException {
        XMPPConnection.DEBUG_ENABLED = true;
        this.connection_ = new XMPPConnection(XMPPMessenger.getConnectionConfiguration());
        this.closeTime = XMPPMessenger.getCloseSessionTime();
        this.disconnectTime = XMPPMessenger.getDisconnectTime();
        this.username_ = username;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.historyImpl = (HistoryImpl)container.getComponentInstanceOfType(HistoryImpl.class);
        this.sessionProvider = new SessionProvider(ConversationState.getCurrent());
        try {
            this.presence = new Presence(Presence.Type.unavailable);
            this.connection_.connect();
            this.connection_.login(username, password, null, false);
            XMPPMessenger.LOGGER.info((Object)("Client '" + username + "' logged in."));
            this.multiUserChatManager = new MultiUserChatManager();
            this.eventBeanQueue = new LinkedList<EventsBean>();
            MessageFilter msgFilter = new MessageFilter();
            XMPPMessenger.LOGGER.info((Object)("we initialize for the user:'" + username + "'."));
            this.connection_.addPacketListener(new PacketListener(){

                public void processPacket(Packet packet) {
                    try {
                        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                        ContinuationService continuation = XMPPSessionImpl.this.getContinuationService();
                        packet.setPacketID(StringUtils.encodeToHex(UUID.randomUUID().toString()));
                        MessageBean message = TransformUtils.messageToBean((Message)packet);
                        XMPPSessionImpl.this.historyImpl.addHistoricalMessage(HistoryUtils.messageToHistoricalMessage((Message)packet), XMPPSessionImpl.this.sessionProvider);
                        EventsBean eventsBean = new EventsBean();
                        eventsBean.addMessage(message);
                        eventsBean.setEventId(Packet.nextID());
                        JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                        XMPPMessenger.LOGGER.info((Object)("Send message to " + XMPPSessionImpl.this.username_ + ". Channel : '/eXo/Application/Chat/message'. JSON : " + json));
                        continuation.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/message", (Object)json);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, (PacketFilter)msgFilter);
            SubscriptionFilter subFilter = new SubscriptionFilter();
            this.connection_.addPacketListener(new PacketListener(){

                public void processPacket(Packet packet) {
                    try {
                        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                        ContinuationService continuation = XMPPSessionImpl.this.getContinuationService();
                        PresenceBean subscription = TransformUtils.presenceToBean((Presence)packet);
                        EventsBean eventsBean = new EventsBean();
                        eventsBean.addSubscription(subscription);
                        eventsBean.setEventId(Packet.nextID());
                        JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                        XMPPMessenger.LOGGER.info((Object)("send SubscriptionRequest to " + XMPPSessionImpl.this.username_ + ". Cahnnel : '/eXo/Application/Chat/subscription'. JSON : " + json));
                        continuation.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/subscription", (Object)json);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, (PacketFilter)subFilter);
            this.connection_.addPacketListener(new PacketListener(){

                public void processPacket(Packet packet) {
                    try {
                        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                        ContinuationService continuation = XMPPSessionImpl.this.getContinuationService();
                        MUCPacketBean muc = TransformUtils.packetToMUCPacketBean(packet);
                        EventsBean eventsBean = new EventsBean();
                        eventsBean.addMUCEvent(muc);
                        eventsBean.setEventId(Packet.nextID());
                        JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                        XMPPMessenger.LOGGER.info((Object)("send group chat event to " + XMPPSessionImpl.this.username_ + ". Channel : '/eXo/Application/Chat/groupchat'. JSON : " + json));
                        continuation.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/groupchat", (Object)json);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, (PacketFilter)new PacketExtensionFilter("x", "http://jabber.org/protocol/muc#user"));
            this.connection_.getRoster().addRosterListener(new RosterListener(){

                public void entriesAdded(Collection<String> arg0) {
                    try {
                        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                        ContinuationService continuation = XMPPSessionImpl.this.getContinuationService();
                        EventsBean eventsBean = new EventsBean();
                        eventsBean.setRoster(TransformUtils.rosterToRosterBean(XMPPSessionImpl.this.connection_.getRoster()));
                        eventsBean.setEventId(Packet.nextID());
                        JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                        XMPPMessenger.LOGGER.info((Object)("Add new entry to roster " + XMPPSessionImpl.this.username_ + ". Channel : '/eXo/Application/Chat/roster'. JSON : " + json));
                        continuation.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/roster", (Object)json);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void entriesDeleted(Collection<String> arg0) {
                    try {
                        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                        ContinuationService continuation = XMPPSessionImpl.this.getContinuationService();
                        EventsBean eventsBean = new EventsBean();
                        eventsBean.setRoster(TransformUtils.rosterToRosterBean(XMPPSessionImpl.this.connection_.getRoster()));
                        eventsBean.setEventId(Packet.nextID());
                        JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                        XMPPMessenger.LOGGER.info((Object)("Delete entry from roster  " + XMPPSessionImpl.this.username_ + ". Channel : '/eXo/Application/Chat/roster'. JSON : " + json));
                        continuation.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/roster", (Object)json);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void entriesUpdated(Collection<String> arg0) {
                    try {
                        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                        ContinuationService continuation = XMPPSessionImpl.this.getContinuationService();
                        EventsBean eventsBean = new EventsBean();
                        eventsBean.setRoster(TransformUtils.rosterToRosterBean(XMPPSessionImpl.this.connection_.getRoster()));
                        eventsBean.setEventId(Packet.nextID());
                        JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                        XMPPMessenger.LOGGER.info((Object)("Update entry in roster  " + XMPPSessionImpl.this.username_ + ". Channel : '/eXo/Application/Chat/roster'. JSON : " + json));
                        continuation.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/roster", (Object)json);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void presenceChanged(Presence presence) {
                }
            });
            PresenceFilter presenceFilter = new PresenceFilter();
            this.connection_.addPacketListener(new PacketListener(){

                public void processPacket(Packet packet) {
                    try {
                        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                        ContinuationService continuation = XMPPSessionImpl.this.getContinuationService();
                        PresenceBean presence = TransformUtils.presenceToBean((Presence)packet);
                        EventsBean eventsBean = new EventsBean();
                        eventsBean.addPresence(presence);
                        eventsBean.setEventId(Packet.nextID());
                        JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                        XMPPMessenger.LOGGER.info((Object)("Send Presence to  " + XMPPSessionImpl.this.username_ + ". Channel : '/eXo/Application/Chat/presence'. JSON : " + json));
                        continuation.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/presence", (Object)json);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, (PacketFilter)presenceFilter);
        }
        catch (Exception e) {
            throw new XMPPException("Create XMPP connection for user '" + username + "' failed. ", (Throwable)e);
        }
        XMPPMessenger.LOGGER.info((Object)("finish initialize for the user:'" + username + "'."));
    }

    @Override
    public boolean addTransport(Transport transport, String remoteUser, String remotePassword, boolean autoLogin) {
        if (!this.isTransportAvailable(transport) && this.isTransportSupported(transport)) {
            try {
                XMPPConnectionUtils.registerUser(this.connection_, transport.getServiceName(), remoteUser, remotePassword);
            }
            catch (XMPPException e) {
                e.printStackTrace();
                return false;
            }
            if (autoLogin) {
                Presence presence = new Presence(Presence.Type.available);
                presence.setTo(transport.getServiceName());
                this.sendPresence(presence);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addBuddy(String username, String nickname, String group) throws XMPPException {
        String jid = username + "@" + this.connection_.getServiceName();
        XMPPMessenger.LOGGER.info((Object)("add " + jid + " to roster of '" + this.username_ + "'."));
        Roster roster = this.connection_.getRoster();
        roster.createEntry(jid, nickname, new String[]{group});
    }

    @Override
    public void askForSubscription(String username, String nickname) throws XMPPException {
        String jid = username + "@" + this.connection_.getServiceName();
        XMPPMessenger.LOGGER.info((Object)("askForSubscription of '" + this.username_ + "' to '" + jid + "'."));
        Presence precense = new Presence(Presence.Type.subscribe);
        precense.setTo(jid);
        this.sendPresence(precense);
        XMPPMessenger.LOGGER.info((Object)("end askForSubscription of '" + this.username_ + "' to '" + jid + "'."));
    }

    @Override
    public RosterEntry getBuddy(String name) {
        String jid = name + "@" + this.connection_.getServiceName();
        return this.connection_.getRoster().getEntry(jid);
    }

    @Override
    public void updateBuddy(String username, String nickname, String group) throws XMPPException {
        String jid = username + "@" + this.connection_.getServiceName();
        ArrayList gr = new ArrayList();
        Roster roster = this.connection_.getRoster();
        System.out.println(roster.contains(jid));
        RosterEntry entry = roster.getEntry(jid);
        if (roster.getGroup(group) == null) {
            RosterGroup rosterGroup = roster.createGroup(group);
            rosterGroup.addEntry(entry);
        } else {
            RosterGroup rosterGroup = roster.getGroup(group);
            rosterGroup.addEntry(roster.getEntry(jid));
        }
    }

    public void createGroup(String grop) {
        try {
            Roster roster = this.connection_.getRoster();
            RosterGroup rosterGroup = roster.createGroup(grop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean cleanBuddiesList() {
        XMPPMessenger.LOGGER.info((Object)("clean buddy list of '" + this.username_ + "'."));
        Roster buddies = this.connection_.getRoster();
        for (RosterEntry re : buddies.getEntries()) {
            try {
                buddies.removeEntry(re);
            }
            catch (XMPPException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void close() {
        this.connection_.disconnect(new Presence(Presence.Type.unavailable));
        XMPPMessenger.LOGGER.info((Object)("Client '" + this.username_ + "' logged out."));
    }

    @Override
    public List<HistoricalMessage> getAllHistory(String usernameto, String usernamefrom, boolean isGroupChat) {
        return this.historyImpl.getHistoricalMessages(usernameto, usernamefrom, isGroupChat, this.sessionProvider);
    }

    @Override
    public List<Presence> getBuddiesPresense() {
        ArrayList<Presence> list = new ArrayList<Presence>();
        Roster buddies = this.connection_.getRoster();
        for (RosterEntry re : buddies.getEntries()) {
            list.add(buddies.getPresence(re.getUser()));
        }
        return list;
    }

    @Override
    public XMPPConnection getConnection() {
        return this.connection_;
    }

    protected ContinuationService getContinuationService() {
        RootContainer container = RootContainer.getInstance();
        container = container.getPortalContainer("portal");
        ContinuationService continuation = (ContinuationService)container.getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    @Override
    public List<HistoricalMessage> getHistoryBetweenDate(String usernameto, String usernamefrom, boolean isGroupChat, Date dateFrom, Date dateTo) {
        return this.historyImpl.getHistoricalMessages(usernameto, usernamefrom, isGroupChat, dateFrom, dateTo, this.sessionProvider);
    }

    @Override
    public List<HistoricalMessage> getHistoryFromDateToNow(String usernameto, String usernamefrom, boolean isGroupChat, Date dateFrom) {
        return this.historyImpl.getHistoricalMessages(usernameto, usernamefrom, isGroupChat, dateFrom, this.sessionProvider);
    }

    @Override
    public List<HistoricalMessage> getNotRecieveMessages() {
        String usernameTo = this.username_ + "@";
        return this.historyImpl.getNotReciveMessage(usernameTo, this.sessionProvider);
    }

    @Override
    public List<Interlocutor> getInterlocutors(String username) {
        return this.historyImpl.getInterlocutors(username, this.sessionProvider);
    }

    public MultiUserChatManager getMultiUserChatManager() {
        return this.multiUserChatManager;
    }

    @Override
    public Boolean isJoin(String room) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null) {
            return chat.isJoined();
        }
        return null;
    }

    @Override
    public Form getSearchForm(String searchService) {
        try {
            return new UserSearchManager(this.connection_).getSearchForm(searchService);
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> getSearchServices() {
        DiscoverItems discoverItems = XMPPConnectionUtils.getDiscoverItems(this.connection_, this.connection_.getServiceName());
        Iterator iterator = discoverItems.getItems();
        ArrayList<String> services = new ArrayList<String>();
        ServiceDiscoveryManager discoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection_);
        while (iterator.hasNext()) {
            DiscoverInfo info;
            DiscoverItems.Item item = (DiscoverItems.Item)iterator.next();
            try {
                info = discoveryManager.discoverInfo(item.getEntityID());
            }
            catch (XMPPException e) {
                continue;
            }
            if (!info.containsFeature("jabber:iq:search")) continue;
            services.add(item.getEntityID());
        }
        return services;
    }

    @Override
    public UserInfo getUserInfo(String userID) {
        return this.userInfoServiceImpl.getUserInfo(userID);
    }

    @Override
    public String getUsername() {
        return this.username_;
    }

    private boolean isTransportAvailable(Transport transport) {
        return XMPPConnectionUtils.isRegistered(this.connection_, transport.getServiceName());
    }

    private boolean isTransportSupported(Transport transport) {
        List<Transport> supportedTransports = XMPPConnectionUtils.getSupportedTransports(this.connection_);
        for (Transport t : supportedTransports) {
            if (!t.getServiceName().equals(transport.getServiceName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAllTransport() {
        List<Transport> list = XMPPConnectionUtils.getSupportedTransports(this.connection_);
        for (Transport transport : list) {
            this.removeTransport(transport);
        }
    }

    @Override
    public boolean removeBuddy(String name) {
        String jid = name + "@" + this.connection_.getServiceName();
        Roster buddies = this.connection_.getRoster();
        for (RosterEntry re : buddies.getEntries()) {
            if (!jid.equals(re.getUser())) continue;
            try {
                buddies.removeEntry(re);
            }
            catch (XMPPException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTransport(Transport transport) {
        if (this.isTransportAvailable(transport)) {
            try {
                XMPPConnectionUtils.unregisterUser(this.connection_, transport.getServiceName());
            }
            catch (XMPPException e) {
                return false;
            }
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setTo(transport.getServiceName());
            this.sendPresence(presence);
        }
        return true;
    }

    @Override
    public ReportedData searchUser(String search, boolean byUsername, boolean byName, boolean byEmail, String searchService) {
        try {
            UserSearchManager searchManager = new UserSearchManager(this.connection_);
            Form searchForm = searchManager.getSearchForm(searchService);
            Form answerForm = searchForm.createAnswerForm();
            Iterator searchableFieldsIterator = searchForm.getDataFormToSend().getFields();
            while (searchableFieldsIterator.hasNext()) {
                String searchVariable = ((FormField)searchableFieldsIterator.next()).getVariable();
                if (searchVariable.equalsIgnoreCase("username")) {
                    answerForm.setAnswer(searchVariable, byUsername);
                }
                if (searchVariable.equalsIgnoreCase("name")) {
                    answerForm.setAnswer(searchVariable, byName);
                }
                if (searchVariable.equalsIgnoreCase("email")) {
                    answerForm.setAnswer(searchVariable, byEmail);
                }
                if (!searchVariable.equalsIgnoreCase("search") || search == null) continue;
                answerForm.setAnswer(searchVariable, search);
            }
            return searchManager.getSearchResults(answerForm, searchService);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void sendMessage(Message message) {
        if (this.connection_.isConnected()) {
            this.connection_.sendPacket((Packet)message);
        }
    }

    @Override
    public void sendMessageToMUC(String room, String body) throws XMPPException {
        MultiUserChat chat = this.multiUserChatManager.getMultiUserChat(room);
        Message message = chat.createMessage();
        message.setBody(body);
        message.setFrom(this.getUsername());
        chat.sendMessage(message);
    }

    @Override
    public void sendPresence(Presence presence) {
        if (this.connection_.isConnected()) {
            this.connection_.sendPacket((Packet)presence);
        }
    }

    @Override
    public void subscribeUser(String user) {
        String jid = user + "@" + this.connection_.getServiceName();
        Presence precense = new Presence(Presence.Type.subscribed);
        precense.setTo(jid);
        this.sendPresence(precense);
    }

    @Override
    public void subscribeUser(String toUser, String serviceName) {
        Presence precense = new Presence(Presence.Type.subscribed);
        precense.setTo(toUser + "@" + serviceName);
        this.sendPresence(precense);
    }

    @Override
    public void unsubscribeUser(String user) {
        String jid = user + "@" + this.connection_.getServiceName();
        Presence precense = new Presence(Presence.Type.unsubscribed);
        precense.setTo(jid);
        this.sendPresence(precense);
    }

    @Override
    public void unsubscribeUser(String toUser, String serviceName) {
        Presence precense = new Presence(Presence.Type.unsubscribed);
        precense.setTo(toUser + "@" + serviceName);
        this.sendPresence(precense);
    }

    public Queue<EventsBean> getEventBeanQueue() {
        return this.eventBeanQueue;
    }

    public void setAwayTime(long awayTime) {
        this.awayTime = awayTime;
    }

    @Override
    public void messageReceive(String messageId) {
        this.historyImpl.messageReceive(messageId, this.sessionProvider);
    }

    public void setAlive_(boolean alive_) {
        this.alive_ = alive_;
    }

    public boolean isAlive_() {
        return this.alive_;
    }

    public void startAliveChecker() {
        new ClientAliveChecker();
    }

    public void setPresence(Presence presence) {
        this.presence = presence;
    }

    public Presence getPresence() {
        return this.presence;
    }

    public SessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    @Override
    public MultiUserChat getMultiUserChat(String room) throws XMPPException {
        String mucService = MultiUserChat.getServiceNames((XMPPConnection)this.connection_).toArray()[0].toString();
        String roomJID = room + "@" + mucService;
        return this.multiUserChatManager.getMultiUserChat(roomJID);
    }

    @Override
    public MultiUserChat createRoom(String room, String nickname) throws XMPPException {
        String mucService = MultiUserChat.getServiceNames((XMPPConnection)this.connection_).toArray()[0].toString();
        String roomJID = room + "@" + mucService;
        MultiUserChat chat = new MultiUserChat(this.connection_, roomJID);
        if (nickname == null) {
            nickname = this.username_;
        }
        chat.join(nickname);
        this.multiUserChatManager.addMultiUserChat(chat);
        return chat;
    }

    @Override
    public Form getConfigFormRoom(String room) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        return chat.getConfigurationForm();
    }

    @Override
    public MultiUserChat configRoom(String room, ConfigRoomBean cr) throws XMPPException {
        String service = this.connection_.getServiceName();
        ConfigRoomBean configRoom = new ConfigRoomBean();
        configRoom.setAllowinvites(cr.getAllowinvites());
        configRoom.setCanchangenick(cr.getCanchangenick());
        configRoom.setChangesubject(cr.getChangesubject());
        configRoom.setMaxusers(cr.getMaxusers());
        configRoom.setMembersonly(cr.getMembersonly());
        configRoom.setModeratedroom(cr.getModeratedroom());
        configRoom.setPasswordprotectedroom(cr.getPasswordprotectedroom());
        configRoom.setPersistentroom(cr.getPersistentroom());
        configRoom.setPresencebroadcast(cr.getPresencebroadcast());
        configRoom.setPublicroom(cr.getPublicroom());
        configRoom.setReservednick(cr.getReservednick());
        configRoom.setRoomdesc(cr.getRoomdesc());
        configRoom.setRoomname(cr.getRoomname());
        configRoom.setRoomsecret(cr.getRoomsecret());
        configRoom.setWhois(cr.getWhois());
        ArrayList<String> roomadmins = new ArrayList<String>();
        if (cr.getRoomadmins() != null) {
            for (String name : cr.getRoomadmins()) {
                roomadmins.add(name + "@" + service);
            }
        }
        configRoom.setRoomadmins(roomadmins);
        ArrayList<String> roomowners = new ArrayList<String>();
        if (cr.getRoomowners() != null) {
            for (String name : cr.getRoomowners()) {
                roomowners.add(name + "@" + service);
            }
        }
        configRoom.setRoomowners(roomowners);
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null) {
            Form answerform = chat.getConfigurationForm().createAnswerForm();
            answerform.setAnswer("muc#roomconfig_roomdesc", configRoom.getRoomdesc());
            answerform.setAnswer("muc#roomconfig_changesubject", configRoom.getChangesubject().booleanValue());
            answerform.setAnswer("muc#roomconfig_maxusers", configRoom.getMaxusers());
            answerform.setAnswer("muc#roomconfig_presencebroadcast", configRoom.getPresencebroadcast());
            answerform.setAnswer("muc#roomconfig_publicroom", configRoom.getPublicroom().booleanValue());
            answerform.setAnswer("muc#roomconfig_persistentroom", configRoom.getPersistentroom().booleanValue());
            answerform.setAnswer("muc#roomconfig_moderatedroom", configRoom.getModeratedroom().booleanValue());
            answerform.setAnswer("muc#roomconfig_membersonly", configRoom.getMembersonly().booleanValue());
            answerform.setAnswer("muc#roomconfig_allowinvites", configRoom.getAllowinvites().booleanValue());
            answerform.setAnswer("muc#roomconfig_passwordprotectedroom", configRoom.getPasswordprotectedroom().booleanValue());
            answerform.setAnswer("muc#roomconfig_roomsecret", configRoom.getRoomsecret());
            answerform.setAnswer("muc#roomconfig_whois", configRoom.getWhois());
            answerform.setAnswer("x-muc#roomconfig_reservednick", configRoom.getReservednick().booleanValue());
            answerform.setAnswer("x-muc#roomconfig_canchangenick", configRoom.getCanchangenick().booleanValue());
            answerform.setAnswer("muc#roomconfig_roomadmins", configRoom.getRoomadmins());
            answerform.setAnswer("muc#roomconfig_roomowners", configRoom.getRoomowners());
            chat.sendConfigurationForm(answerform);
            this.multiUserChatManager.updateMultiUserChat(chat);
            return chat;
        }
        return null;
    }

    public boolean isPasswordRequired(String roomJID) {
        ServiceDiscoveryManager discover = new ServiceDiscoveryManager(this.connection_);
        try {
            DiscoverInfo info = discover.discoverInfo(roomJID);
            return info.containsFeature("muc_passwordprotected");
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void joinRoom(String room, String nickname, String password) throws XMPPException {
        MultiUserChat chat;
        String mucService = MultiUserChat.getServiceNames((XMPPConnection)this.connection_).toArray()[0].toString();
        String roomJID = room + "@" + mucService;
        if (nickname == null) {
            nickname = this.username_;
        }
        if ((chat = this.multiUserChatManager.getMultiUserChat(roomJID)) == null) {
            chat = new MultiUserChat(this.connection_, roomJID);
            this.multiUserChatManager.addMultiUserChat(chat);
        }
        if (!chat.isJoined()) {
            if (this.isPasswordRequired(roomJID)) {
                chat.join(nickname, password);
            } else {
                chat.join(nickname);
            }
        }
    }

    @Override
    public FullRoomInfoBean getRoomInfo(String room) throws XMPPException {
        String mucService = MultiUserChat.getServiceNames((XMPPConnection)this.connection_).toArray()[0].toString();
        String roomJID = room + "@" + mucService;
        MultiUserChat chat = this.multiUserChatManager.getMultiUserChat(roomJID);
        if (chat != null) {
            RoomInfo roomInfo = MultiUserChat.getRoomInfo((XMPPConnection)this.connection_, (String)roomJID);
            ArrayList<Occupant> occupants = new ArrayList<Occupant>();
            Iterator occ = chat.getOccupants();
            while (occ.hasNext()) {
                String user = (String)occ.next();
                occupants.add(chat.getOccupant(user));
            }
            FullRoomInfoBean infoBean = new FullRoomInfoBean(roomInfo, occupants);
            return infoBean;
        }
        return null;
    }

    public boolean isModerator(MultiUserChat chat, String nickname) {
        String role;
        String jid = nickname + "@" + this.connection_.getServiceName();
        Occupant occupant = chat.getOccupant(jid);
        return occupant != null && MODERATOR.equals(role = occupant.getRole());
    }

    public boolean isAdmin(MultiUserChat chat, String nickname) {
        return false;
    }

    @Override
    public void declineRoom(String room, String inviter, String reason) throws XMPPException {
        String mucService = MultiUserChat.getServiceNames((XMPPConnection)this.connection_).toArray()[0].toString();
        String roomJID = room + "@" + mucService;
        String inviterJID = inviter + "@" + this.connection_.getServiceName();
        MultiUserChat chat = this.multiUserChatManager.getMultiUserChat(roomJID);
        MultiUserChat.decline((XMPPConnection)this.connection_, (String)roomJID, (String)inviterJID, (String)reason);
    }

    @Override
    public Boolean inviteToRoom(String room, String invitee, String reason) throws XMPPException {
        String mucService = MultiUserChat.getServiceNames((XMPPConnection)this.connection_).toArray()[0].toString();
        String roomJID = room + "@" + mucService;
        String inviteeJID = invitee + "@" + this.connection_.getServiceName();
        MultiUserChat chat = this.multiUserChatManager.getMultiUserChat(roomJID);
        if (chat != null && chat.isJoined()) {
            chat.invite(inviteeJID, reason);
            return true;
        }
        return false;
    }

    @Override
    public Boolean leaveRoom(String room) throws XMPPException {
        String mucService = MultiUserChat.getServiceNames((XMPPConnection)this.connection_).toArray()[0].toString();
        String roomJID = room + "@" + mucService;
        MultiUserChat chat = this.multiUserChatManager.getMultiUserChat(roomJID);
        if (chat != null) {
            if (chat.isJoined()) {
                chat.leave();
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void manageRole(MultiUserChat chat, String nickname, String role, String command) throws XMPPException {
        if (role.equals(MODERATOR)) {
            if (command.equals(GRANT)) {
                chat.grantModerator(nickname);
            } else {
                if (!command.equals(REVOKE)) throw new XMPPException("Wrong command must be: 'grant' or 'revoke'");
                chat.revokeModerator(nickname);
            }
        }
        if (!role.equals(PARTICIPANT)) throw new XMPPException("Wrong role must be: 'moderator' or 'participant'");
        if (command.equals(GRANT)) {
            chat.grantVoice(nickname);
            return;
        } else {
            if (!command.equals(REVOKE)) throw new XMPPException("Wrong command must be: 'grant' or 'revoke'");
            chat.revokeVoice(nickname);
        }
    }

    @Override
    public void kickUser(MultiUserChat chat, String nickname, String reason) throws XMPPException {
        chat.kickParticipant(nickname, reason);
    }

    @Override
    public void banUser(MultiUserChat chat, String nickname, String reason) throws XMPPException {
        Occupant occupant = chat.getOccupant(chat.getRoom() + "/" + nickname);
        if (occupant != null) {
            String jid = occupant.getJid();
            chat.banUser(jid, reason);
        } else {
            this.log.error((Object)("Occupants witn nickname " + nickname + " not found!"));
        }
    }

    @Override
    public Boolean destroyRoom(String room, String reason, String altRoom) throws XMPPException {
        String mucService = MultiUserChat.getServiceNames((XMPPConnection)this.connection_).toArray()[0].toString();
        String roomJID = room + "@" + mucService;
        String alternateJID = altRoom + "@" + mucService;
        MultiUserChat chat = this.multiUserChatManager.getMultiUserChat(roomJID);
        if (chat != null) {
            chat.destroy(reason, alternateJID);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void manageAffiliation(MultiUserChat chat, String nickname, String affiliation, String command) throws XMPPException {
        Occupant occupant = chat.getOccupant(chat.getRoom() + "/" + nickname);
        if (occupant == null) return;
        String jid = occupant.getJid();
        if (affiliation.equals(ADMIN)) {
            if (command.equals(GRANT)) {
                chat.grantAdmin(jid);
            } else {
                if (!command.equals(REVOKE)) throw new XMPPException("Wrong command must be: 'grant' or 'revoke'");
                chat.revokeAdmin(jid);
            }
        }
        if (affiliation.equals(MEMBER)) {
            if (command.equals(GRANT)) {
                chat.grantMembership(jid);
            } else {
                if (!command.equals(REVOKE)) throw new XMPPException("Wrong command must be: 'grant' or 'revoke'");
                chat.revokeMembership(jid);
            }
        }
        if (!affiliation.equals(OWNER)) throw new XMPPException("Wrong affiliation must be: 'owner, 'admin' or 'member'");
        if (command.equals(GRANT)) {
            chat.grantOwnership(jid);
            return;
        } else {
            if (!command.equals(REVOKE)) throw new XMPPException("Wrong command must be: 'grant' or 'revoke'");
            chat.revokeOwnership(jid);
        }
    }

    class ClientAliveChecker
    extends Thread {
        long tmp;

        public ClientAliveChecker() {
            this.tmp = XMPPSessionImpl.this.awayTime;
            this.start();
        }

        public void run() {
            try {
                Thread.sleep(XMPPSessionImpl.this.disconnectTime);
                if (!XMPPSessionImpl.this.alive_ && this.tmp == XMPPSessionImpl.this.awayTime) {
                    XMPPSessionImpl.this.connection_.sendPacket((Packet)new Presence(Presence.Type.unavailable));
                    XMPPSessionImpl.this.presence = new Presence(Presence.Type.unavailable);
                    Thread.sleep(XMPPSessionImpl.this.closeTime);
                    if (!XMPPSessionImpl.this.alive_ && this.tmp == XMPPSessionImpl.this.awayTime) {
                        XMPPSessionImpl.this.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

