/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.rest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.CacheControl;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.xmpp.bean.ConfigRoomBean;
import org.exoplatform.services.xmpp.bean.FormBean;
import org.exoplatform.services.xmpp.bean.FullRoomInfoBean;
import org.exoplatform.services.xmpp.bean.HostedRoomBean;
import org.exoplatform.services.xmpp.bean.InitInfoBean;
import org.exoplatform.services.xmpp.bean.InterlocutorListBean;
import org.exoplatform.services.xmpp.bean.MessageBean;
import org.exoplatform.services.xmpp.bean.MessageListBean;
import org.exoplatform.services.xmpp.connection.XMPPSession;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.services.xmpp.connection.impl.XMPPSessionImpl;
import org.exoplatform.services.xmpp.ext.transport.AIMTransport;
import org.exoplatform.services.xmpp.ext.transport.GtalkTransport;
import org.exoplatform.services.xmpp.ext.transport.ICQTransport;
import org.exoplatform.services.xmpp.ext.transport.MSNTransport;
import org.exoplatform.services.xmpp.ext.transport.YahooTransport;
import org.exoplatform.services.xmpp.history.HistoricalMessage;
import org.exoplatform.services.xmpp.userinfo.OrganizationUserInfoServiceImpl;
import org.exoplatform.services.xmpp.util.PresenceUtil;
import org.exoplatform.services.xmpp.util.TransformUtils;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;
import org.exoplatform.ws.frameworks.json.transformer.Json2BeanInputTransformer;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;

public class RESTXMPPService
implements ResourceContainer {
    protected static final String JSON_CONTENT_TYPE = "application/json";
    private final Log log = ExoLogger.getLogger((String)"RESTXMPPService");
    private final XMPPMessenger messenger;

    public RESTXMPPService(XMPPMessenger messenger) {
        this.messenger = messenger;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/createroom/{username}/{room}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response createRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @QueryParam(value="nickname") String nickname) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.createRoom(room, nickname);
                Form form = session.getConfigFormRoom(room);
                FormBean formBean = TransformUtils.formToFormBean(form);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok((Object)formBean, (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
            }
        }
        this.log.error((Object)"XMPPSesion is null");
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/muc/configroom/{username}/{room}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response configRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, ConfigRoomBean configRoom) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                if (session.getMultiUserChat(room) != null) {
                    session.configRoom(room, configRoom);
                }
                return Response.Builder.ok().build();
            }
            this.log.error((Object)"XMPPSesion is null");
            return Response.Builder.withStatus((int)500).errorMessage("XMPPSesion is null!").build();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/getroomconfig/{username}/{room}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRoomConfigForm(@URIParam(value="username") String username, @URIParam(value="room") String room) {
        XMPPSession session = this.messenger.getSession(username);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        if (session != null) {
            try {
                Form form = session.getConfigFormRoom(room);
                if (form != null) {
                    FormBean formBean = TransformUtils.formToFormBean(form);
                    return Response.Builder.ok((Object)formBean, (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cacheControl).build();
            }
            catch (Exception e) {
                e.printStackTrace();
                return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/getroominfo/{username}/{room}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRoomInfo(@URIParam(value="username") String username, @URIParam(value="room") String room) {
        XMPPSession session = this.messenger.getSession(username);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        if (session != null) {
            try {
                FullRoomInfoBean infoBean = session.getRoomInfo(room);
                if (infoBean != null) {
                    return Response.Builder.ok((Object)infoBean, (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cacheControl).build();
            }
            catch (XMPPException e) {
                return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + (Object)((Object)e)).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/rooms/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRooms(@URIParam(value="username") String username) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                XMPPConnection connection = session.getConnection();
                Collection collectionMUCService = MultiUserChat.getServiceNames((XMPPConnection)connection);
                String mucService = collectionMUCService.toArray()[0].toString();
                ArrayList<HostedRoomBean> rooms = new ArrayList<HostedRoomBean>();
                Collection hostedRooms = MultiUserChat.getHostedRooms((XMPPConnection)connection, (String)mucService);
                for (HostedRoom hostedRoom : hostedRooms) {
                    HostedRoomBean roomBean = new HostedRoomBean();
                    roomBean.setJid(hostedRoom.getJid());
                    roomBean.setName(hostedRoom.getName());
                    RoomInfo roomInfo = MultiUserChat.getRoomInfo((XMPPConnection)connection, (String)hostedRoom.getJid());
                    if (roomInfo != null) {
                        roomBean.setDescription(roomInfo.getDescription());
                    }
                    rooms.add(roomBean);
                }
                InitInfoBean infoBean = new InitInfoBean();
                infoBean.setHostedRooms(rooms);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok((Object)infoBean, (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
            }
            catch (Exception e) {
                e.printStackTrace();
                return Response.Builder.withStatus((int)500).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/decline/{username}/{inviter}/{room}/")
    public Response declineToRoom(@URIParam(value="username") String username, @URIParam(value="inviter") String inviter, @URIParam(value="room") String room, @QueryParam(value="reason") String reason) {
        XMPPSession session = this.messenger.getSession(username);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        if (session != null) {
            try {
                session.declineRoom(room, inviter, reason);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            catch (XMPPException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
            }
        }
        this.log.error((Object)"XMPPSesion is null");
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/destroy/{username}/{room}/")
    public Response destroyRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @QueryParam(value="reason") String reason, @QueryParam(value="altroom") String altRoom) {
        XMPPSession session = this.messenger.getSession(username);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        if (session != null) {
            try {
                if (session.destroyRoom(room, reason, altRoom).booleanValue()) {
                    return Response.Builder.ok().cacheControl(cacheControl).build();
                }
                return Response.Builder.withStatus((int)400).errorMessage("Chat is null").cacheControl(cacheControl).build();
            }
            catch (XMPPException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
            }
        }
        this.log.error((Object)"XMPPSesion is null");
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/invite/{username}/{invitee}/{room}/")
    public Response inviteToRoom(@URIParam(value="username") String username, @URIParam(value="invitee") String invitee, @URIParam(value="room") String room, @QueryParam(value="raeson") String reason) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.inviteToRoom(room, invitee, reason).booleanValue()) {
                    return Response.Builder.ok().cacheControl(cacheControl).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cacheControl).build();
            }
            catch (XMPPException e) {
                e.printStackTrace();
                return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).cacheControl(cacheControl).errorMessage("session null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/join/{username}/{room}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response joinRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @QueryParam(value="nickname") String nickname, @QueryParam(value="password") String password) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.joinRoom(room, nickname, password);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            catch (XMPPException e) {
                e.printStackTrace();
                return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("Session is null").cacheControl(cacheControl).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/leaveroom/{username}/{room}/")
    public Response leftRoom(@URIParam(value="username") String username, @URIParam(value="room") String room) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.leaveRoom(room).booleanValue()) {
                    return Response.Builder.ok().cacheControl(cacheControl).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cacheControl).build();
            }
            catch (XMPPException e) {
                e.printStackTrace();
                return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("Session is null").cacheControl(cacheControl).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/managerole/{username}/{room}/{nickname}/")
    public Response manageRoleRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="nickname") String nickname, @QueryParam(value="role") String role, @QueryParam(value="command") String command) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                MultiUserChat chat = session.getMultiUserChat(room);
                if (chat != null) {
                    session.manageRole(chat, nickname, role, command);
                    return Response.Builder.ok().cacheControl(cacheControl).build();
                }
                this.log.error((Object)"Chat is null");
                return Response.Builder.withStatus((int)404).errorMessage("Chat is null").build();
            }
            catch (XMPPException e) {
                this.log.error((Object)e.getMessage());
                return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).cacheControl(cacheControl).build();
            }
        }
        this.log.error((Object)"Sesion is null");
        return Response.Builder.withStatus((int)404).errorMessage("Session is null").cacheControl(cacheControl).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/manageaffiliation/{username}/{room}/{name}/")
    public Response manageAffilationRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="name") String nickname, @QueryParam(value="affiliation") String affiliation, @QueryParam(value="command") String command) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                MultiUserChat chat = session.getMultiUserChat(room);
                if (chat != null) {
                    session.manageAffiliation(chat, nickname, affiliation, command);
                    return Response.Builder.ok().cacheControl(cacheControl).build();
                }
                this.log.error((Object)"Chat is null");
                return Response.Builder.withStatus((int)404).errorMessage("Chat is null").build();
            }
            catch (XMPPException e) {
                this.log.error((Object)e.getMessage());
                return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).cacheControl(cacheControl).build();
            }
        }
        this.log.error((Object)"Sesion is null");
        return Response.Builder.withStatus((int)404).errorMessage("Session is null").cacheControl(cacheControl).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/kick/{username}/{room}/{nickname}/")
    public Response kickUserFromRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="nickname") String nickname, @QueryParam(value="reason") String reason) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                MultiUserChat chat = session.getMultiUserChat(room);
                if (chat != null) {
                    session.kickUser(chat, nickname, reason);
                    return Response.Builder.ok().cacheControl(cacheControl).build();
                }
                this.log.error((Object)"Chat is null");
                return Response.Builder.withStatus((int)404).errorMessage("Chat is null").build();
            }
            catch (XMPPException e) {
                String c = e.getXMPPError().getCondition();
                if (c.equals(XMPPError.Condition.not_allowed.toString())) {
                    this.log.error((Object)(e.getXMPPError().getCondition() + " : 405 error can occur if a moderator or a user with an affiliation of 'owner' or 'admin' was intended to be kicked (Not Allowed error)"));
                    return Response.Builder.withStatus((int)405).errorMessage("a 405 error can occur if a moderator or a user with an affiliation of 'owner' or 'admin' was intended to be kicked (Not Allowed error)").cacheControl(cacheControl).build();
                }
                if (c.equals(XMPPError.Condition.forbidden.toString())) {
                    this.log.error((Object)(e.getXMPPError().getCondition() + " : 403 error can occur if the occupant that intended to kick another occupant does not have kicking privileges (i.e. Forbidden error)"));
                    return Response.Builder.withStatus((int)403).errorMessage("a 403 error can occur if the occupant that intended to kick another occupant does not have kicking privileges (i.e. Forbidden error)").cacheControl(cacheControl).build();
                }
                if (c.equals(XMPPError.Condition.unexpected_condition.toString())) {
                    this.log.error((Object)(e.getXMPPError().getCondition() + " : 400 error can occur if the provided nickname is not present in the room"));
                    return Response.Builder.withStatus((int)400).errorMessage(" : 400 error can occur if the provided nickname is not present in the room").cacheControl(cacheControl).build();
                }
                this.log.error((Object)(e.getXMPPError().getCondition() + (Object)((Object)e)));
                return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).cacheControl(cacheControl).build();
            }
        }
        this.log.error((Object)"Sesion is null");
        return Response.Builder.withStatus((int)404).errorMessage("Session is null").cacheControl(cacheControl).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/ban/{username}/{room}/{name}/")
    public Response banUserFromRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="name") String nickname, @QueryParam(value="reason") String reason) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                MultiUserChat chat = session.getMultiUserChat(room);
                if (chat != null) {
                    session.banUser(chat, nickname, reason);
                    return Response.Builder.ok().cacheControl(cacheControl).build();
                }
                this.log.error((Object)"Chat is null");
                return Response.Builder.withStatus((int)404).errorMessage("Chat is null").build();
            }
            catch (XMPPException e) {
                String c = e.getXMPPError().getCondition();
                if (c.equals(XMPPError.Condition.not_allowed.toString())) {
                    this.log.error((Object)(e.getXMPPError().getCondition() + " : 405 error can occur if a moderator or a user with an affiliation of 'owner' or 'admin' was intended to be kicked (Not Allowed error)"));
                    return Response.Builder.withStatus((int)405).errorMessage("a 405 error can occur if a moderator or a user with an affiliation of 'owner' or 'admin' was intended to be kicked (Not Allowed error)").cacheControl(cacheControl).build();
                }
                this.log.error((Object)(e.getXMPPError().getCondition() + (Object)((Object)e)));
                return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).cacheControl(cacheControl).build();
            }
        }
        this.log.error((Object)"XMPPSesion is null");
        return Response.Builder.withStatus((int)404).errorMessage("Session is null").cacheControl(cacheControl).build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/addtransport/")
    public Response addTransport(@QueryParam(value="username") String username, @QueryParam(value="remoteusername") String remoteUser, @QueryParam(value="remotepassword") String remotePassword, @QueryParam(value="transport") String transport) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                String serviceName = session.getConnection().getServiceName();
                if (transport.equalsIgnoreCase("yahoo")) {
                    YahooTransport yahooTransport = new YahooTransport(serviceName);
                    session.addTransport(yahooTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("icq")) {
                    ICQTransport icqTransport = new ICQTransport(serviceName);
                    session.addTransport(icqTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("msn")) {
                    MSNTransport msnTransport = new MSNTransport(serviceName);
                    session.addTransport(msnTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("aim")) {
                    AIMTransport aimTransport = new AIMTransport(serviceName);
                    session.addTransport(aimTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("gtalk")) {
                    GtalkTransport gtalkTransport = new GtalkTransport(serviceName);
                    session.addTransport(gtalkTransport, remoteUser, remotePassword, true);
                } else {
                    this.log.error((Object)"Wrong transport name!");
                }
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            this.log.error((Object)"XMPPSesion is null");
            return Response.Builder.withStatus((int)403).errorMessage("XMPPSession is null").build();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/add/{username}/{adduser}/")
    public Response addBoddyToRoster(@URIParam(value="username") String username, @URIParam(value="adduser") String adduser, @QueryParam(value="nickname") String nickname, @QueryParam(value="group") String group) {
        XMPPSession session = this.messenger.getSession(username);
        try {
            if (session != null) {
                if (nickname == null) {
                    nickname = adduser;
                }
                session.addBuddy(adduser, nickname, group);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            this.log.error((Object)"XMPPSession is null");
            return Response.Builder.withStatus((int)500).build();
        }
        catch (XMPPException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/update/{username}/{upduser}/")
    public Response updateBoddy(@URIParam(value="username") String username, @URIParam(value="upduser") String upduser, @QueryParam(value="nickname") String nickname, @QueryParam(value="group") String group) {
        XMPPSession session = this.messenger.getSession(username);
        try {
            if (session != null) {
                if (nickname == null) {
                    nickname = upduser;
                }
                session.updateBuddy(upduser, nickname, group);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)500).build();
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/group/{username}/{group}/")
    public Response createGroup(@URIParam(value="username") String username, @URIParam(value="group") String group) {
        XMPPSessionImpl session = (XMPPSessionImpl)this.messenger.getSession(username);
        if (session != null) {
            session.createGroup(group);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.Builder.ok().cacheControl(cacheControl).build();
        }
        return Response.Builder.withStatus((int)500).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/askforsubscription/{username}/{askuser}/")
    public Response askForSubscription(@URIParam(value="username") String username, @URIParam(value="askuser") String askuser, @QueryParam(value="nickname") String nickname) {
        XMPPSession session = this.messenger.getSession(username);
        try {
            if (session != null) {
                if (session.getBuddy(askuser) == null) {
                    return Response.Builder.withStatus((int)400).errorMessage("Not found contact").build();
                }
                if (nickname == null) {
                    nickname = askuser;
                }
                session.askForSubscription(askuser, nickname);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            this.log.error((Object)"XMPPSesion is null");
            return Response.Builder.withStatus((int)500).build();
        }
        catch (XMPPException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/rosterclean/{username}/")
    public Response cleanBuddylist(@URIParam(value="username") String username) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.cleanBuddiesList();
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            this.log.error((Object)"XMPPSesion is null");
            return Response.Builder.withStatus((int)500).errorMessage("XMPPSesion is null").build();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getmessages/{usernameto}/{usernamefrom}/{isGroupChat}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getAllHistory(@URIParam(value="usernameto") String usernameto, @URIParam(value="usernamefrom") String usernamefrom, @URIParam(value="isGroupChat") Boolean isGroupChat) {
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                list = session.getAllHistory(usernameto, usernamefrom, isGroupChat);
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (!list.isEmpty()) {
                    for (HistoricalMessage historicalMessage : list) {
                        listBean.add(TransformUtils.messageToBean(historicalMessage));
                    }
                }
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getmessages/{usernameto}/{usernamefrom}/{isGroupChat}/{dateformat}/{from}/{to}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getHistoryBetweenDate(@URIParam(value="usernameto") String usernameto, @URIParam(value="usernamefrom") String usernamefrom, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="dateformat") String dateformat, @URIParam(value="from") String from, @URIParam(value="to") String to) {
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
                Date dateFrom = dateFormat.parse(from);
                Date dateTo = dateFormat.parse(to);
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (dateFrom.before(dateTo)) {
                    list = session.getHistoryBetweenDate(usernameto, usernamefrom, isGroupChat, dateFrom, dateTo);
                    if (!list.isEmpty()) {
                        for (HistoricalMessage historicalMessage : list) {
                            listBean.add(TransformUtils.messageToBean(historicalMessage));
                        }
                    }
                    CacheControl cacheControl = new CacheControl();
                    cacheControl.setNoCache(true);
                    cacheControl.setNoStore(true);
                    return Response.Builder.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
                }
                return Response.Builder.withStatus((int)409).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getmessages/{usernameto}/{usernamefrom}/{isGroupChat}/{dateformat}/{from}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getHistoryFromDateToNow(@URIParam(value="usernameto") String usernameto, @URIParam(value="usernamefrom") String usernamefrom, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="dateformat") String dateformat, @URIParam(value="from") String from) {
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
                Date dateFrom = dateFormat.parse(from);
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (dateFrom.before(Calendar.getInstance().getTime())) {
                    list = session.getHistoryFromDateToNow(usernameto, usernamefrom, isGroupChat, dateFrom);
                    if (!list.isEmpty()) {
                        for (HistoricalMessage historicalMessage : list) {
                            listBean.add(TransformUtils.messageToBean(historicalMessage));
                        }
                    }
                    CacheControl cacheControl = new CacheControl();
                    cacheControl.setNoCache(true);
                    cacheControl.setNoStore(true);
                    return Response.Builder.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
                }
                return Response.Builder.withStatus((int)409).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getinterlocutors/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getInterlocutors(@URIParam(value="username") String username) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok((Object)new InterlocutorListBean(session.getInterlocutors(username)), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/getsearchform/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getSearchUsersForm(@URIParam(value="username") String username, @QueryParam(value="searchservice") String searchService) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                Form form = session.getSearchForm(searchService);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok((Object)TransformUtils.formToFormBean(form), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
            }
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.Builder.withStatus((int)403).cacheControl(cacheControl).errorMessage("session null!").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/getuserinfo/{username}/{needinfo}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUserInfo(@URIParam(value="username") String username, @URIParam(value="needinfo") String needinfo) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                System.out.println(session.getUserInfo(needinfo));
                return Response.Builder.ok((Object)session.getUserInfo(needinfo), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/login/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response login(@QueryParam(value="username") String _username, @QueryParam(value="password") String _password) {
        try {
            this.messenger.login(_username, _password);
            XMPPSession session = this.messenger.getSession(_username);
            XMPPConnection connection = session.getConnection();
            String mainServiceName = session.getConnection().getServiceName();
            List<String> services = session.getSearchServices();
            Form form = session.getSearchForm(services.get(0));
            Roster buddyList = session.getConnection().getRoster();
            session.removeAllTransport();
            Collection collectionMUCService = MultiUserChat.getServiceNames((XMPPConnection)connection);
            String mucService = collectionMUCService.toArray()[0].toString();
            Collection hostedRooms = MultiUserChat.getHostedRooms((XMPPConnection)connection, (String)mucService);
            InitInfoBean initInfoBean = new InitInfoBean();
            initInfoBean.setForm(TransformUtils.formToFormBean(form));
            initInfoBean.setMainServiceName(mainServiceName);
            initInfoBean.setMucServicesNames(collectionMUCService);
            initInfoBean.setRoster(TransformUtils.rosterToRosterBean(buddyList));
            initInfoBean.setSearchServicesNames(services);
            initInfoBean.setHostedRooms(TransformUtils.hostedRoomsToBeansCollection(hostedRooms));
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.Builder.ok((Object)initInfoBean, (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).header("Set-Cookie", "userTicket=" + UUID.randomUUID().toString()).build();
        }
        catch (Exception e) {
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/login2/{forcache}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response login2(@URIParam(value="forcache") String forcache) {
        try {
            this.log.info((Object)("Random number for cache problem: " + forcache));
            ConversationState curentState = ConversationState.getCurrent();
            String username = curentState.getIdentity().getUserId();
            this.log.info((Object)("Userid for login : " + username));
            RootContainer container = RootContainer.getInstance();
            container = container.getPortalContainer("portal");
            OrganizationUserInfoServiceImpl organization = (OrganizationUserInfoServiceImpl)container.getComponentInstanceOfType(OrganizationUserInfoServiceImpl.class);
            String password = organization.getOrganizationService().getUserHandler().findUserByName(username).getPassword();
            this.messenger.login(username, password);
            XMPPSession session = this.messenger.getSession(username);
            XMPPConnection connection = session.getConnection();
            String mainServiceName = session.getConnection().getServiceName();
            List<String> services = session.getSearchServices();
            Form form = session.getSearchForm(services.get(0));
            Roster buddyList = session.getConnection().getRoster();
            session.removeAllTransport();
            Collection collectionMUCService = MultiUserChat.getServiceNames((XMPPConnection)connection);
            String mucService = collectionMUCService.toArray()[0].toString();
            Collection hostedRooms = MultiUserChat.getHostedRooms((XMPPConnection)connection, (String)mucService);
            ArrayList<HostedRoomBean> rooms = new ArrayList<HostedRoomBean>();
            for (HostedRoom hostedRoom : hostedRooms) {
                HostedRoomBean roomBean = new HostedRoomBean();
                roomBean.setJid(hostedRoom.getJid());
                roomBean.setName(hostedRoom.getName());
                rooms.add(roomBean);
            }
            InitInfoBean initInfoBean = new InitInfoBean();
            initInfoBean.setForm(TransformUtils.formToFormBean(form));
            initInfoBean.setMainServiceName(mainServiceName);
            initInfoBean.setMucServicesNames(collectionMUCService);
            initInfoBean.setRoster(TransformUtils.rosterToRosterBean(buddyList));
            initInfoBean.setSearchServicesNames(services);
            initInfoBean.setHostedRooms(rooms);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.Builder.ok((Object)initInfoBean, (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).header("Set-Cookie", "userTicket=" + UUID.randomUUID().toString()).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/logout/{username}/")
    public Response logout(@URIParam(value="username") String _username) {
        try {
            this.messenger.getSession(_username).removeAllTransport();
            this.messenger.logout(_username);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.Builder.ok().cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/messagereceive/{username}/{messageid}/")
    public Response messageReceive(@URIParam(value="username") String username, @URIParam(value="messageid") String messageId) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.messageReceive(messageId);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/del/{username}/{removeboddy}/")
    public Response removeBuddy(@URIParam(value="username") String username, @URIParam(value="removeboddy") String removeboddy) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                if (session.removeBuddy(removeboddy)) {
                    CacheControl cacheControl = new CacheControl();
                    cacheControl.setNoCache(true);
                    cacheControl.setNoStore(true);
                    return Response.Builder.ok().cacheControl(cacheControl).build();
                }
                return Response.Builder.withStatus((int)404).errorMessage("Buddy not found").build();
            }
            return Response.Builder.withStatus((int)403).errorMessage("Sesion is null").build();
        }
        catch (Exception e) {
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/removetransport/{username}/{transport}/")
    public Response removeTransport(@URIParam(value="username") String username, @URIParam(value="transport") String _transport) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                String serviceName = session.getConnection().getServiceName();
                if (_transport.equalsIgnoreCase("yahoo")) {
                    YahooTransport yahooTransport = new YahooTransport(serviceName);
                    session.removeTransport(yahooTransport);
                } else if (_transport.equalsIgnoreCase("icq")) {
                    ICQTransport icqTransport = new ICQTransport(serviceName);
                    session.removeTransport(icqTransport);
                } else if (_transport.equalsIgnoreCase("msn")) {
                    MSNTransport msnTransport = new MSNTransport(serviceName);
                    session.removeTransport(msnTransport);
                } else if (_transport.equalsIgnoreCase("aim")) {
                    AIMTransport aimTransport = new AIMTransport(serviceName);
                    session.removeTransport(aimTransport);
                } else if (_transport.equalsIgnoreCase("gtalk")) {
                    GtalkTransport gtalkTransport = new GtalkTransport(serviceName);
                    session.removeTransport(gtalkTransport);
                }
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)403).errorMessage("sesion is null").build();
        }
        catch (Exception e) {
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/searchuser/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response searchUsers(@URIParam(value="username") String username, @QueryParam(value="search") String search, @QueryParam(value="username") Boolean byUsername, @QueryParam(value="name") Boolean byName, @QueryParam(value="email") Boolean byEmail, @QueryParam(value="searchservice") String searchService) {
        try {
            XMPPSession session;
            if (byUsername == null) {
                byUsername = new Boolean(false);
            }
            if (byName == null) {
                byName = new Boolean(false);
            }
            if (byEmail == null) {
                byEmail = new Boolean(false);
            }
            if ((session = this.messenger.getSession(username)) != null) {
                ReportedData reportedData = session.searchUser(search, byUsername, byName, byEmail, searchService);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok((Object)TransformUtils.reportedSateToSearchResultsBean(reportedData), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)403).errorMessage("session null").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/sendmessage/{username}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response sendMessage(@URIParam(value="username") String username, MessageBean messageBean) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                String from = session.getUsername().split("/")[0];
                Message message = new Message(messageBean.getTo(), Message.Type.chat);
                message.setFrom(from);
                message.setBody(messageBean.getBody());
                session.sendMessage(message);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/muc/sendmessage/{username}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response sendMUCMessage(@URIParam(value="username") String username, MessageBean messageBean) {
        try {
            String room = messageBean.getTo();
            String body = messageBean.getBody();
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.sendMessageToMUC(room, body);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoCache(true);
                cacheControl.setNoStore(true);
                return Response.Builder.ok().cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)500).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/sendstatus/{username}/{status}/")
    public Response setUserStatus(@URIParam(value="username") String username, @URIParam(value="status") String status) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            Presence presence = PresenceUtil.getPresence(status);
            if (presence == null) {
                return Response.Builder.withStatus((int)403).errorMessage("Get unknow status.").build();
            }
            session.sendPresence(presence);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.Builder.ok().cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/subscribeuser/{username}/{subsuser}/")
    public Response subscribeUser(@URIParam(value="username") String _username, @URIParam(value="subsuser") String _subsuser) {
        XMPPSession session = this.messenger.getSession(_username);
        if (session != null) {
            session.subscribeUser(_subsuser);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.Builder.ok().cacheControl(cacheControl).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Session is null").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/unsubscribeuser/{username}/{unsubsuser}/")
    public Response unsubscribeUser(@URIParam(value="username") String username, @URIParam(value="unsubsuser") String unsubsuser) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            session.unsubscribeUser(unsubsuser);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.Builder.ok().cacheControl(cacheControl).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Session is null").build();
    }
}

