/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.xmpp.bean.ContactBean;
import org.exoplatform.services.xmpp.bean.FieldBean;
import org.exoplatform.services.xmpp.bean.FormBean;
import org.exoplatform.services.xmpp.bean.HostedRoomBean;
import org.exoplatform.services.xmpp.bean.MUCPacketBean;
import org.exoplatform.services.xmpp.bean.MessageBean;
import org.exoplatform.services.xmpp.bean.PresenceBean;
import org.exoplatform.services.xmpp.bean.SearchResultsBean;
import org.exoplatform.services.xmpp.history.HistoricalMessage;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.packet.MUCUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformUtils {
    public static PresenceBean presenceToBean(Presence presence) {
        PresenceBean presenceBean = new PresenceBean();
        presenceBean.setFrom(presence.getFrom());
        try {
            presenceBean.setMode(presence.getMode().name());
        }
        catch (Exception e) {
            presenceBean.setMode(null);
        }
        try {
            presenceBean.setType(presence.getType().name());
        }
        catch (Exception e) {
            presenceBean.setType(null);
        }
        return presenceBean;
    }

    public static List<ContactBean> rosterToRosterBean(Roster roster) {
        Collection collection = roster.getEntries();
        ArrayList<ContactBean> list = new ArrayList<ContactBean>();
        for (RosterEntry re : collection) {
            ContactBean contactBean = new ContactBean();
            contactBean.setNickname(re.getName());
            if (re.getStatus() == RosterPacket.ItemStatus.SUBSCRIPTION_PENDING) {
                contactBean.setSubscriptionStatus("SUBSCRIPTION_PENDING");
            }
            if (re.getStatus() == RosterPacket.ItemStatus.UNSUBCRIPTION_PENDING) {
                contactBean.setSubscriptionStatus("UNSUBSCRIPTION_PENDING");
            }
            if (re.getType() != null) {
                contactBean.setSubscriptionType(re.getType().name());
            }
            Collection collectionGroup = re.getGroups();
            ArrayList<String> groupNames = new ArrayList<String>();
            for (RosterGroup group : collectionGroup) {
                groupNames.add(group.getName());
            }
            contactBean.setGroups(groupNames);
            contactBean.setUser(re.getUser());
            contactBean.setPresence(TransformUtils.presenceToBean(roster.getPresence(re.getUser())));
            Iterator iterator = roster.getPresences(re.getUser());
            list.add(contactBean);
        }
        return list;
    }

    public static MUCPacketBean packetToMUCPacketBean(Packet packet) {
        MUCPacketBean packetBean = new MUCPacketBean();
        MUCUser packetExtension = (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
        if (packet instanceof Presence) {
            MUCUser.Item item;
            Presence prs = (Presence)packet;
            packetBean.setPresence(TransformUtils.presenceToBean(prs));
            MUCUser.Destroy destroy = packetExtension.getDestroy();
            if (destroy != null) {
                packetBean.setDestroy(destroy);
            }
            if ((item = packetExtension.getItem()) != null) {
                packetBean.setItem(item);
            }
        }
        if (packet instanceof Message) {
            MUCUser.Invite invite;
            Message msg = (Message)packet;
            packetBean.setMessage(TransformUtils.messageToBean(msg));
            MUCUser.Decline decline = packetExtension.getDecline();
            if (decline != null) {
                packetBean.setDecline(decline);
            }
            if ((invite = packetExtension.getInvite()) != null) {
                packetBean.setInvite(invite);
            }
        }
        return packetBean;
    }

    public static MessageBean messageToBean(Message message) {
        return new MessageBean(message.getPacketID(), message.getFrom(), message.getTo(), message.getType().name(), message.getBody());
    }

    public static MessageBean messageToBean(HistoricalMessage message) {
        MessageBean messageBean = new MessageBean(message.getId(), message.getFrom(), message.getTo(), message.getType(), message.getBody());
        messageBean.setDateSend(message.getDateSend().toString());
        return messageBean;
    }

    public static FormBean formToFormBean(Form form) {
        FormBean formBean = new FormBean();
        Iterator iterator = form.getDataFormToSend().getFields();
        ArrayList<FieldBean> fieldBeans = new ArrayList<FieldBean>();
        while (iterator.hasNext()) {
            FormField formField = (FormField)iterator.next();
            fieldBeans.add(TransformUtils.fieldToFieldBean(formField));
        }
        formBean.setFields(fieldBeans);
        formBean.setInstructions(form.getInstructions());
        formBean.setTitle(form.getTitle());
        formBean.setType(form.getType());
        return formBean;
    }

    public static FieldBean fieldToFieldBean(FormField formField) {
        FieldBean fieldBean = new FieldBean();
        ArrayList<String> values = new ArrayList<String>();
        Iterator iterator = formField.getValues();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            values.add(value);
        }
        fieldBean.setValues(values);
        fieldBean.setVariable(formField.getVariable());
        fieldBean.setDescription(formField.getDescription());
        fieldBean.setLabel(formField.getLabel());
        fieldBean.setType(formField.getType());
        return fieldBean;
    }

    public static HostedRoomBean hostedRoomToBean(HostedRoom hostedRoom) {
        return new HostedRoomBean(hostedRoom.getJid(), hostedRoom.getName());
    }

    public static List<HostedRoomBean> hostedRoomsToBeansCollection(Collection<HostedRoom> collection) {
        ArrayList<HostedRoomBean> rooms = new ArrayList<HostedRoomBean>();
        for (HostedRoom hostedRoom : collection) {
            rooms.add(TransformUtils.hostedRoomToBean(hostedRoom));
        }
        return rooms;
    }

    public static SearchResultsBean reportedSateToSearchResultsBean(ReportedData reportedData) {
        ArrayList<Map<String, List<String>>> list = new ArrayList<Map<String, List<String>>>();
        Iterator reportedDataRows = reportedData.getRows();
        while (reportedDataRows.hasNext()) {
            ReportedData.Row reportedDataRow = (ReportedData.Row)reportedDataRows.next();
            HashMap map = new HashMap();
            Iterator reportedDataColumns = reportedData.getColumns();
            while (reportedDataColumns.hasNext()) {
                String columnName = ((ReportedData.Column)reportedDataColumns.next()).getVariable();
                Iterator reportedDataFields = reportedDataRow.getValues(columnName);
                ArrayList listValue = new ArrayList();
                while (reportedDataFields.hasNext()) {
                    listValue.add(reportedDataFields.next());
                }
                map.put(columnName.toLowerCase(), listValue);
            }
            list.add(map);
        }
        return new SearchResultsBean(list);
    }
}

