/**
 * @author Uoc Nguyen
 */
function UIChatDragDrop() {
  this.scKey = 'border' ;
  this.scValue = 'solid 1px #000' ;
  this.DOMUtil = eXo.core.DOMUtil ;
  this.DragDrop = eXo.core.DragDrop ;
  this.dropableSets = [];
  this.dragableSets = [];
} ;

UIChatDragDrop.prototype.init = function(rootNode, dragableNodeInfos) {
  this.regDnDItem(rootNode, dragableNodeInfos) ;
} ;

UIChatDragDrop.prototype.regDnDItem = function(rootNode, dragableNodeInfos) {
  for (var i=0; i<dragableNodeInfos.length; i++) {
    var nodeList = eXo.core.DOMUtil.findDescendantsByClass(rootNode, dragableNodeInfos[i].tagName, dragableNodeInfos[i].className);
    if (nodeList) {
      for (var j=0; j<nodeList.length; j++) {
        nodeList[j].style.cursor = 'move';
        if (window.addEventListener) {
          nodeList[j].addEventListener('mousedown', this.mouseDownTrigger, false);
        } else {
          nodeList[j].attachEvent('onmousedown', this.mouseDownTrigger, false);
        }
      }
    }
  }
} ;

/**
 * 
 * @param {Event} e
 */
UIChatDragDrop.prototype.mouseDownTrigger = function(e) {
  e = e ? e : window.event ;
  if (e.button == 1 || e.which == 1) {
    return eXo.communication.chat.webui.UIChatDragDrop.initDnD(eXo.communication.chat.webui.UIChatDragDrop.dropableSets, this, this, e) ;
  }
  return true ;
} ;

UIChatDragDrop.prototype.initDnD = function(dropableObjs, clickObj, dragObj, e) {
  var clickBlock = (clickObj && clickObj.tagName) ? clickObj : document.getElementById(clickObj) ;
  var dragBlock = (dragObj && dragObj.tagName) ? dragObj : document.getElementById(dragObj) ;
  
  var blockWidth = clickBlock.offsetWidth ;
  var blockHeight = clickBlock.offsetHeight ;
  
  var uiDragObjectNode = this.DOMUtil.findAncestorByClass(dragBlock, 'UIDragObject');
  
  this.DragDrop.initCallback = this.initCallback ;
  this.DragDrop.dragCallback = this.dragCallback ;
  this.DragDrop.dropCallback = this.dropCallback ;
  this.DragDrop.init(dropableObjs, clickBlock, uiDragObjectNode, e) ;
  return false ;
} ;

UIChatDragDrop.prototype.synDragObjectPos = function(dndEvent) {
  if (!dndEvent.backupMouseEvent) {
    dndEvent.backupMouseEvent = window.event ;
    if (!dndEvent.backupMouseEvent) {
      return ;
    }
  }
  var dragObject = dndEvent.dragObject ;
  var mouseX = eXo.core.Browser.findMouseXInPage(dndEvent.backupMouseEvent) ;
  var mouseY = eXo.core.Browser.findMouseYInPage(dndEvent.backupMouseEvent)
  dragObject.style.top = mouseY + 'px' ;
  dragObject.style.left = mouseX + 'px' ;
} ;

UIChatDragDrop.prototype.initCallback = function(dndEvent) {
  eXo.communication.chat.webui.UIChatDragDrop.synDragObjectPos(dndEvent) ;
} ;

UIChatDragDrop.prototype.dragCallback = function(dndEvent) {
  var dragObject = dndEvent.dragObject ;
  if (!dragObject.style.display ||
      dragObject.style.display == 'none') {
    dragObject.style.display = 'block' ;
  }

//  dragObject.style[eXo.communication.chat.webui.UIChatDragDrop.scKey] = eXo.communication.chat.webui.UIChatDragDrop.scValue;

//  eXo.communication.chat.webui.UIChatDragDrop.synDragObjectPos(dndEvent) ;
} ;

UIChatDragDrop.prototype.dropCallback = function(dndEvent) {} ;

eXo.communication.chat.webui.UIChatDragDrop = new UIChatDragDrop();
