/**
 * @author Uoc Nguyen Ba
 */
function UIJoinRoomPopupWindow() {
}

UIJoinRoomPopupWindow.prototype.init = function(rootNode, UIMainChatWindow) {
  this.rootNode = rootNode;
  this.UIMainChatWindow = UIMainChatWindow;
  var DOMUtil = eXo.core.DOMUtil;
  var tmpNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'table', 'UIGrid');
  this.roomListContainerNode = tmpNode.getElementsByTagName('tbody')[0];
  this.joinRoomButtonNode = eXo.core.DOMUtil.findFirstDescendantByClass(this.rootNode, 'a', 'JoinRoomButton');
  this.LocalTemplateEngine = this.UIMainChatWindow.LocalTemplateEngine;
};

UIJoinRoomPopupWindow.prototype.setVisible = function(visible) {
  if (this.UIMainChatWindow.userStatus == this.UIMainChatWindow.OFFLINE_STATUS) {
    return;
  }
  if (visible) {
    this.UIMainChatWindow.jabberGetRoomList();
    this.setButtonAction(false);
    if (this.rootNode.style.display != 'block') {
      this.rootNode.style.display = 'block'; 
    }
  } else {
    if (this.rootNode.style.display != 'none') {
      this.rootNode.style.display = 'none'; 
    }
  }
};

UIJoinRoomPopupWindow.prototype.updateRoomList = function(roomList) {
  this.roomListContainerNode.innerHTML = '<span/>';
  for (var i=0; i<roomList.length; i++) {
    var roomInfo = roomList[i];
    roomInfo.enabled4Add = true;
    this.roomListContainerNode.appendChild(this.createRoomNode(roomInfo));
  }
};

UIJoinRoomPopupWindow.prototype.createRoomNode = function(roomInfo) {
  var DOMUtil = eXo.core.DOMUtil;
  var uiContactRowNode = document.createElement('tr');
  uiContactRowNode.className = 'UIRoomRow';
  var tdTmpNode = document.createElement('td');
  
  //var selectBoxNode = document.createElement('input');
  
  //selectBoxNode.type = 'checkbox';
  //selectBoxNode.className = 'CheckBox';
  var checkBoxHTML = '<input type="radio" class="CheckBox"';
  if (!roomInfo.enabled4Add) {
    checkBoxHTML += ' checked="true" disabled="true"';
  }
  checkBoxHTML += 'name="roomName" value="' + roomInfo['name'] +
    '" onclick="eXo.communication.chat.webui.UIJoinRoomPopupWindow.selectRoom(event);">';
  
  //tdTmpNode.appendChild(selectBoxNode);
  tdTmpNode.innerHTML = checkBoxHTML;
  uiContactRowNode.appendChild(tdTmpNode.cloneNode(true));
  
  tdTmpNode.innerHTML = '<span/>';
  
  var tmpRoomName = roomInfo['name'];
  if (tmpRoomName.length > 30) {
    tmpRoomName = tmpRoomName.substr(0, 27) + '...';
  }
  tdTmpNode.innerHTML = tmpRoomName;//roomInfo['name'];
  uiContactRowNode.appendChild(tdTmpNode.cloneNode(true));
  tdTmpNode.innerHTML = roomInfo['description'];
  uiContactRowNode.appendChild(tdTmpNode.cloneNode(true));
  
  return uiContactRowNode;
};

UIJoinRoomPopupWindow.prototype.selectRoom = function(event) {
  var DOMUtil = eXo.core.DOMUtil;
  event = event || window.event;
  var srcElement = event.srcElement || event.target;
  /*
  var checkBoxList = DOMUtil.findDescendantsByClass(DOMUtil.findAncestorByClass(srcElement, 'UIGrid'), 'input', 'CheckBox');
  for (var i=0; i<checkBoxList.length; i++) {
    var currentNode = checkBoxList[i];
    if (currentNode != srcElement) {
      currentNode.checked = false;
    }
  }
  */
  srcElement.checked = true;
  eXo.communication.chat.webui.UIJoinRoomPopupWindow.setButtonAction(true);
};

UIJoinRoomPopupWindow.prototype.setButtonAction = function(isActive) {
  if (isActive) {
    this.joinRoomButtonNode.href = this.joinRoomButtonNode.getAttribute('jsbk');
  } else {
    this.joinRoomButtonNode.setAttribute('jsbk', this.joinRoomButtonNode.href);
    this.joinRoomButtonNode.href = '#';
  }
};

UIJoinRoomPopupWindow.prototype.joinRoomAction = function() {
  this.setVisible(false);
  var DOMUtil = eXo.core.DOMUtil;
  var checkBoxList = DOMUtil.findDescendantsByClass(this.roomListContainerNode, 'input', 'CheckBox');
  for (var i=0; i<checkBoxList.length; i++) {
    var currentNode = checkBoxList[i];
    if (currentNode.checked) {
      this.UIMainChatWindow.jabberJoinToRoom(currentNode.value);
    }
  }
};

eXo.communication.chat.webui.UIJoinRoomPopupWindow = new UIJoinRoomPopupWindow();
