/**
 * @author Uoc Nguyen Ba
 */

// -- Ajax handle --
function ChatAjaxHandler(action) {
  this.action = action;
  this.flags = {debuge: false};
}

ChatAjaxHandler.prototype.onLoading = function(requestObj) {
  var UIMainChatWindow = eXo.communication.chat.webui.UIMainChatWindow;
  if (!UIMainChatWindow) return;
  if (this.handler.flags['debug']) {
    console.info('[' + this.handler.action + '] ' + UIMainChatWindow.LOADING_STATE);
  }
  UIMainChatWindow.update(UIMainChatWindow.LOADING_STATE, requestObj, this.handler.action);
};

ChatAjaxHandler.prototype.onSuccess = function(requestObj) {
  var UIMainChatWindow = eXo.communication.chat.webui.UIMainChatWindow;
  if (!UIMainChatWindow) return;
  if (this.handler.flags['debug']) {
    console.info('[' + this.handler.action + '] ' + UIMainChatWindow.SUCCESS_STATE);
  }
  UIMainChatWindow.update(UIMainChatWindow.SUCCESS_STATE, requestObj, this.handler.action);
};

ChatAjaxHandler.prototype.onError = function(requestObj) {
  var UIMainChatWindow = eXo.communication.chat.webui.UIMainChatWindow;
  if (!UIMainChatWindow) return;
  if (this.handler.flags['debug']) {
    console.info('[' + this.handler.action + '] ' + UIMainChatWindow.ERROR_STATE);
  }
  UIMainChatWindow.update(UIMainChatWindow.ERROR_STATE, requestObj, this.handler.action);
};

ChatAjaxHandler.prototype.onTimeout = function(requestObj) {
  var UIMainChatWindow = eXo.communication.chat.webui.UIMainChatWindow;
  if (!UIMainChatWindow) return;
  if (this.handler.flags['debug']) {
    console.info('[' + this.handler.action + '] ' + UIMainChatWindow.TIMEOUT_STATE);
  }
  UIMainChatWindow.update(UIMainChatWindow.TIMEOUT_STATE, requestObj, this.handler.action);
};

function UIMainChatWindow() {
  this.LOGIN_ACTION                       = 'Login';
  this.LOGOUT_ACTION                      = 'Logout';
  this.SEND_STATUS_ACTION                 = 'Send status';
  this.SEND_SUBSCRIPTION_ACTION           = 'Send subscription';
  this.ASK_4_SUBSCRIPTION_ACTION          = 'Ask for subscription';
  this.ADD_USER_ACTION                    = 'Add user';
  this.SEND_MESSAGE_ACTION                = 'Send message';
  this.GET_SUBSCRIPTION_REQUESTS_ACTION   = 'Get subscription requests';
  this.CLEAN_BUDDY_LIST_ACTION            = 'Clean buddy list';
  this.REMOVE_USER_ACTION                 = 'Remove user';
  this.UNSUBSCRIPT_BUDDY_ACTION           = 'Unsubscript buddy';
  this.ORG_GET_ALL_CONTACT_ACTION         = 'Org Service get all contact';
  this.ORG_FUZZY_SEARCH_USER_ACTION       = 'Org Service fuzzy contact search';
  this.CREATE_ROOM_ACTION                 = 'Create room';
  this.CREATE_CONVERSATION_ACTION         = 'Create conversation';
  this.CONFIG_ROOM_ACTION                 = 'Config room';
  this.GET_ROOM_CONFIG_ACTION             = 'Get room\'s config';
  this.GET_ROOM_INFO_ACTION               = 'Get room\'s information';
  this.GET_ROOM_LIST_ACTION               = 'Get room list';
  this.INVITE_JOIN_ROOM_ACTION            = 'Invite join room';
  this.DECLINE_JOIN_ROOM_ACTION           = 'Decline join room';
  this.JOIN_TO_ROOM_ACTION                = 'Join to room';
  this.LEAVE_FROM_ROOM_ACTION             = 'Leave from room';

  this.LOADING_STATE                      = 'Loading';
  this.SUCCESS_STATE                      = 'Success';
  this.ERROR_STATE                        = 'Error';
  this.TIMEOUT_STATE                      = 'Timeout';

  this.LOADING_STATE_CLASS                = 'LoadingIcon';
  this.ONLINE_STATE_CLASS                 = 'OnlineIcon';
  this.OFFLINE_STATE_CLASS                = 'OfflineIcon';

  this.LOGEDIN_MODE                       = 'Loged in';
  this.NOT_LOGEDIN_MODE                   = 'Not loged in';
  
  this.ONLINE_STATUS                      = "Available";
  this.OFFLINE_STATUS                     = "Unavailable";
  this.FREE_TO_CHAT_STATUS                = "Free to chat";
  this.DO_NOT_DISTURB_STATUS              = "Do not disturb";
  this.AWAY_STATUS                        = "Away";
  this.EXTEND_AWAY_STATUS                 = "Extend away";

  this.MAX_CONNECTION_TRY = 5;
  this.CHECK_EVENT_TIMEOUT = 1*1000;

  this.ChatSessionHandler = eXo.communication.chat.webui.ChatSessionHandler;
  this.XMPPCommunicator = eXo.communication.chat.core.XMPPCommunicator;

  this.userToken = false;
  this.userStatus = false;
  this.lastStatusSent = false;
  this.activeAction = false;
  this.guiMode = false;
  this.userNames = new Array();
  this.timeoutCount = 0;
  this.errorCount = 0;
  this.flags = {debug: true};
  this.serverInfo = false;
  this.buddyItemActionStack = false;
  this.hostedRoomList = false;
  this.serverDataStack = false;
  this.actionHandler = {};
};

UIMainChatWindow.prototype.init = function(rootNode, userToken) {
  this.rootNode = (typeof(rootNode) == 'string') ? document.getElementById(rootNode) : rootNode;
  var DOMUtil = eXo.core.DOMUtil;
  this.LocalTemplateEngine = eXo.communication.chat.core.LocalTemplateEngine;
  this.addContactIconNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'a', 'AddContactIcon');
  this.statusIconNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'StatusIcon');
  //this.statusbarNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'Information');
  this.loginFormNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'fieldset', 'LoginForm');
  this.buddyListNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'BuddyList');
  this.buddyItemActionMenuNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'BuddyItemActionMenu');
  
  this.chatPopupNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'ChatPopup');
  this.addContactPopupNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'AddContactPopup');
  this.createNewRoomPopupNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'CreateNewRoomPopup');
  this.roomConfigPopupNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'RoomConfigPopup');
  this.joinRoomPopupNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'JoinRoomPopup');
  
  this.ChatSessionHandler = eXo.communication.chat.webui.ChatSessionHandler;
  this.XMPPCommunicator = eXo.communication.chat.core.XMPPCommunicator;
  this.UIAddContactPopupWindow = eXo.communication.chat.webui.UIAddContactPopupWindow;
  this.UIChatWindow = eXo.communication.chat.webui.UIChatWindow;
  this.UIChatWindow.flags['debug'] = this.flags['debug'];
  this.UICreateNewRoomPopupWindow = eXo.communication.chat.webui.UICreateNewRoomPopupWindow;
  this.UIRoomConfigPopupWindow = eXo.communication.chat.webui.UIRoomConfigPopupWindow;
  this.UIJoinRoomPopupWindow = eXo.communication.chat.webui.UIJoinRoomPopupWindow;
  
  this.UIChatWindow.init(this.chatPopupNode, this);
  this.UIAddContactPopupWindow.init(this.addContactPopupNode, this);
  this.UICreateNewRoomPopupWindow.init(this.createNewRoomPopupNode, this);
  this.UIRoomConfigPopupWindow.init(this.roomConfigPopupNode, this);
  this.UIJoinRoomPopupWindow.init(this.joinRoomPopupNode, this);

  this.userStatus = false;
  this.lastStatusSent = false;
  this.activeAction = false;
  this.guiMode = false;
  this.userNames = new Array();
  this.isGetMsgInProcess = false;
  this.serverInfo = false;
  this.userToken = userToken;
  this.buddyItemActionStack = {};
  this.hostedRoomList = {};
  this.serverDataStack = {};
  var component = eXo.communication.chat.webui.component;
  this.buddyListControlObj = 
    new component.BuddyListControl(this.buddyListNode, this.buddyItemActionCallbackWrapper, this);
  this.buddyListControlObj.flags['debug'] = this.flags['debug'];
  // Detect if user info pass through url
  var searchStr = window.location.search;
  if (searchStr != '') {
    searchStr = searchStr.replace('?', '');
    var argStrList = searchStr.split('&');
    for (var i=0; i<argStrList.length; i++) {
      if (argStrList[i].indexOf('username') != -1) {
        this.jabberLogin(argStrList[i].split('=')[1]);
        break;
      }
    }
  }
};

UIMainChatWindow.prototype.getUserName = function(userNameFullStr) {
  if (userNameFullStr.indexOf('/') != -1) {
    return (userNameFullStr.substring(0, userNameFullStr.indexOf('/')));
  } else {
    return userNameFullStr;
  }
};

UIMainChatWindow.prototype.getAjaxHandler = function() {
  var chatAjaxHandlerTmp = new ChatAjaxHandler(this.activeAction);
  chatAjaxHandlerTmp.flags['debug'] = this.flags['debug'];
  return chatAjaxHandlerTmp;
};

UIMainChatWindow.prototype.getTryCount = function() {
  return (this.errorCount + this.timeoutCount);
};

UIMainChatWindow.prototype.resetAllTryCount = function() {
  this.errorCount = 0;
  this.timeoutCount = 0;
};

// -- Ajax callback update --
/**
 *
 * @param {Object} state
 * @param {Object} requestObj
 */
UIMainChatWindow.prototype.update = function(state, requestObj, action) {
  // Update icon and statusbar message
  switch (state) {
    case this.LOADING_STATE :
      //this.statusbarNode.innerHTML = this.LOADING_STATE + '...';
      if (this.activeActionLoading == action) {
        this.errorCount ++;
      }
      this.activeActionLoading = action;
      break;

    case this.SUCCESS_STATE :
      var eventId = 'restEvent_' + (new Date()).getTime();
      this.resetAllTryCount();
      //this.statusbarNode.innerHTML = this.SUCCESS_STATE;
      if (requestObj.responseText) {
        try {
          this.serverDataStack[eventId] = eXo.core.JSON.parse(requestObj.responseText);
          if (this.flags['debug']) {
            console.dir(this.serverDataStack[eventId]);
          }
        } catch (e) {
          // TODO
        }
      }
      var successAction = action;
      window.setTimeout(function() {
        eXo.communication.chat.webui.UIMainChatWindow.processSuccessAction(successAction, eventId);
      }, 1);
      this.activeAction = false;
      break;

    case this.ERROR_STATE :
      this.errorCount ++;
      //this.statusbarNode.innerHTML = this.ERROR_STATE;
      this.processErrorAction(action);
      this.activeAction = false;
      break;

    case this.TIMEOUT_STATE :
      this.timeoutCount ++;
      //this.statusbarNode.innerHTML = this.TIMEOUT_STATE;
      this.processTimeoutAction(action);
      this.activeAction = false;
      break;

    default :
      break;
  }
  if (state != this.LOADING_STATE) {
    this.activeActionLoading = false;
  }
  if (this.getTryCount() == this.MAX_CONNECTION_TRY) {
    //this.statusbarNode.innerHTML = 'Server down or error! try to reconnect later';
  }
};

UIMainChatWindow.prototype.processSuccessAction = function(action, eventId) {
  var serverData = this.serverDataStack[eventId];
  switch (action) {
    case this.LOGIN_ACTION:
      this.postChangeStatus(this.ONLINE_STATUS, eventId);
      break;
      
    case this.CREATE_ROOM_ACTION:
      break;

    case this.JOIN_TO_ROOM_ACTION:
      var lastRoomName = false;
      for (var item in this.hostedRoomList) {
        if (this.hostedRoomList[item].name) {
          lastRoomName = item;
        }
      }
      if (lastRoomName) {
        this.jabberGetRoomConfig(lastRoomName);
      }
      break;

    case this.GET_ROOM_CONFIG_ACTION:
      if (this.flags['debug']) {
        console.warn('==================================================');
        console.debug('Room\' configuration: ', serverData);
        console.warn('==================================================');
      }
      break;

    case this.SEND_STATUS_ACTION:
      this.postChangeStatus(this.lastStatusSent, eventId);
      break;

    case this.ORG_FUZZY_SEARCH_USER_ACTION:
    case this.ORG_GET_ALL_CONTACT_ACTION:
      if (serverData.users) {
        var userList = serverData.users;
        this.UIAddContactPopupWindow.updateContactList(userList);
      }
      break;
    
    case this.GET_ROOM_LIST_ACTION:
      this.UIJoinRoomPopupWindow.updateRoomList(serverData.hostedRooms);
      break;

    case this.GET_SUBSCRIPTION_REQUESTS_ACTION:
      break;

    case this.SEND_SUBSCRIPTION_ACTION:
      break;

    case this.UNSUBSCRIPT_BUDDY_ACTION:
      break;

    case this.REMOVE_USER_ACTION:
      break;

    case this.SEND_MESSAGE_ACTION:
      break;

    case this.LOGOUT_ACTION:
      this.postChangeStatus(this.OFFLINE_STATUS);
      this.UIChatWindow.destroySession();
      break;

    default:
      break;
  }
  if (this.serverDataStack[eventId]) {
    this.serverDataStack[eventId] = null;
  }
};

UIMainChatWindow.prototype.processTimeoutAction = function(action) {
};

UIMainChatWindow.prototype.processErrorAction = function(action){
  switch (action) {
    default:
      break;
  }
};

// Listeners for cometd connection

UIMainChatWindow.prototype.groupChatListener = function(eventObj) {
  var eventId = 'groupChatCometdEvent_' + (new Date()).getTime();
  this.serverDataStack[eventId] = eXo.core.JSON.parse(eventObj.data);
  window.setTimeout(function() {
      eXo.communication.chat.webui.UIMainChatWindow.processGroupChat(eventId);
  }, 1);
};

UIMainChatWindow.prototype.rosterListener = function(eventObj) {
  var eventId = 'rosterCometdEvent_' + (new Date()).getTime();
  this.serverDataStack[eventId] = eXo.core.JSON.parse(eventObj.data);
  window.setTimeout(function() {
      eXo.communication.chat.webui.UIMainChatWindow.processRoster(eventId);
  }, 1);
};

UIMainChatWindow.prototype.presenceListener = function(eventObj) {
  var eventId = 'presenceCometdEvent_' + (new Date()).getTime();
  this.serverDataStack[eventId] = eXo.core.JSON.parse(eventObj.data);
  window.setTimeout(function() {
      eXo.communication.chat.webui.UIMainChatWindow.processPresences(eventId);
  }, 1);
};

UIMainChatWindow.prototype.subscriptionListener = function(eventObj) {
  var eventId = 'subscriptionCometdEvent_' + (new Date()).getTime();
  this.serverDataStack[eventId] = eXo.core.JSON.parse(eventObj.data);
  window.setTimeout(function() {
      eXo.communication.chat.webui.UIMainChatWindow.processSubscriptions(eventId);
  }, 1);
};

UIMainChatWindow.prototype.messageListener = function(eventObj) {
  var eventId = 'messageCometdEvent_' + (new Date()).getTime();
  this.serverDataStack[eventId] = eXo.core.JSON.parse(eventObj.data);
  window.setTimeout(function() {
      eXo.communication.chat.webui.UIMainChatWindow.processMessages(eventId);
  }, 1);
};

// --+--
UIMainChatWindow.prototype.processMessages = function(eventId) {
  var serverData = this.serverDataStack[eventId];
  if (serverData &&
      serverData.messages) {
    console.debug('processMessages: id:= ' + eventId, serverData)
    var messages = serverData.messages;
    this.displayMessages(messages);
  }
  this.serverDataStack[eventId] = null;
};

UIMainChatWindow.prototype.processRoster = function(eventId) {
  var roster = false;
  var serverData = this.serverDataStack[eventId]; 
  if (this.flags['debug']) {
    console.debug('processRoster: id:= ' + eventId, serverData);
  }
  roster = serverData.roster;
  this.buddyListControlObj.build(roster);
  this.serverDataStack[eventId] = null;
};

UIMainChatWindow.prototype.processPresences = function(eventId) {
  var presences = false;
  var serverData = this.serverDataStack[eventId]; 
  if (this.flags['debug']) {
    console.debug('processPresences: id:= ' + eventId, serverData);
  }
  presences = serverData.presences;

  // Split to 2 presence list to update.
  var mainPresences = [];
  var roomPresences = [];
  var mucServiceName = this.serverInfo.mucServicesNames[0];
  for (var i=0; i<presences.length; i++) {
    var presence = presences[i];
    if (presence.from.indexOf('@' + mucServiceName + '/') != -1) {
      if (presence.type != 'unavailable') {
        roomPresences.push(presence);
      }
    } else {
      mainPresences.push(presence);
    }
  }
  if (roomPresences.length > 0) {
    this.UIChatWindow.updatePresence(presences, true);
  }
  if (mainPresences.length > 0) {
    this.buddyListControlObj.update(presences);
    this.UIChatWindow.updatePresence(presences, false);
  }
  this.serverDataStack[eventId] = null;
};

UIMainChatWindow.prototype.processSubscriptions = function(eventId) {
  var serverData = this.serverDataStack[eventId];
  if (this.flags['debug']) {
    console.debug('Subscription event: id:= ' + eventId, serverData);
  }
  if (!serverData) {
    this.serverDataStack[eventId] = null;
  }
  if (serverData.subscriptions) {
    var subscriptions = serverData.subscriptions;

    for (var i=0; i<subscriptions.length; i++) {
      var subscription = subscriptions[i];
      switch (subscription.type) {
        case 'subscribed':
          break;
        case 'unsubscribed':
          break;
        case 'subscribe':
          var requestUser = subscription.from;
          requestUser = requestUser.substring(0, requestUser.indexOf('@'));
          if (window.confirm('Do you want to allow [' + requestUser + '] to see your status\n and add him/her to your contact list?')) {
            this.jabberSendSubscription(requestUser);
            this.jabberAddUser(requestUser);
          } else {
            this.jabberUnsubscriptUser(requestUser);
          }
          break;
      }
    }
  } else if (serverData.presences) {
    this.processRoster(eventId);
  }
  this.serverDataStack[eventId] = null;
};

UIMainChatWindow.prototype.processGroupChat = function(eventId) {
  var serverData = this.serverDataStack[eventId];
  if (this.flags['debug']) {
    console.debug('GroupChat: id:= ' + eventId, serverData);
  }
  if (!serverData) return;
  if (serverData.mucEvents) {
    var mucEvents = serverData.mucEvents;
    for (var i=0; i<mucEvents.length; i++) {
      var mucEvent = mucEvents[i];
      if (mucEvent.invite) {
        var msgBuf = mucEvent.invite.from + ' invite you join to room: "' + mucEvent.message.from + '"'
        var roomName = mucEvent.message.from;
        if (window.confirm(msgBuf)) {
          roomName = roomName.substr(0, roomName.indexOf('@'));
          this.jabberJoinToRoom(roomName);
        }
        continue;
      }
      if (mucEvent.item && 
          mucEvent.item.jid.indexOf(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP] + '@' + this.serverInfo.mainServiceName) != -1 &&
          mucEvent.item.affiliation == 'owner' &&
          mucEvent.item.role == 'moderator') {
        var msgBuf = 'Room @ ' + mucEvent.presence.from + ' has been created.';
        console.info(msgBuf);
        // TODO: remove auto accept default room's configuration
        //this.UIRoomConfigPopupWindow.setVisible(true);
        this.sendDefaultConfigRoom(mucEvent);
        continue;
      }
      // Member leaved room
      if (mucEvent.item &&
          mucEvent.presence.type == 'unavailable') {
        var userName = mucEvent.item.jid;
        userName = userName.substr(0, userName.indexOf('/'));
        var roomName = mucEvent.presence.from;
        roomName = roomName.substr(0, roomName.indexOf('/'));
        this.UIChatWindow.updateRoster(userName, roomName);
        continue;
      }
      if (mucEvent.message) {
        this.displayMessages(mucEvent.message);
        continue;
      }
      
      if (mucEvent.presence) {
        this.UIChatWindow.updatePresence(mucEvent.presence);
        continue;
      }
    }
  }
  
  this.serverDataStack[eventId] = null;
};

UIMainChatWindow.prototype.sendDefaultConfigRoom = function(mucEvent) {
  var roomName = mucEvent.presence.from;
  roomName = roomName.substr(0, roomName.indexOf('@'));
  var defaultRoomConfig = {
    roomdesc : "", 
    changesubject : true,
    maxusers :["40"],
    presencebroadcast : ["moderator","participant","visitor"],
    publicroom : true,
    persistentroom : false,
    moderatedroom : false,
    membersonly : false,
    allowinvites : false,
    passwordprotectedroom : false,
    roomsecret : "xxx", 
    whois : ["anyone"],
    reservednick : false,
    canchangenick : false,
    roomadmins : [],
    roomowners : []
  };
  defaultRoomConfig = eXo.core.JSON.stringify(defaultRoomConfig);
  this.jabberSendConfigRoom(roomName, defaultRoomConfig);
};
// -/-

// --  GUI handle --
UIMainChatWindow.prototype.cancelEvent = function(event) {
  if (event.preventDefault) {
    event.preventDefault();
    event.stopPropagation();
  } else {
    event.cancelBubble = true;
  }
};

UIMainChatWindow.prototype.xLogin = function(userName) {
  this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP] = userName;
  this.preChangeStatus(this.ONLINE_STATUS);
};

UIMainChatWindow.prototype.preChangeStatus = function(status, skipCheck) {
  if (!this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP] ||
      !status || 
      ((this.userStatus != this.ONLINE_STATUS) && (this.userStatus == status))) {
    return false;
  }
  this.lastStatusSent = status;
  this.setChangeStatusMenuVisible(this.statusIconNode, false);
  var DOMUtil = eXo.core.DOMUtil;
  var userNameNode = DOMUtil.findFirstDescendantByClass(this.statusIconNode, 'div', 'Text');
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  userNameNode.innerHTML = userName;
  switch (status) {
    case this.ONLINE_STATUS:
      if (!this.userStatus ||
          (this.userStatus == this.OFFLINE_STATUS)) {
        this.jabberLogin(userName);
        break;
      }
      if (skipCheck ||
          (this.userStatus != this.ONLINE_STATUS)) {
        this.jabberSendStatus(this.ONLINE_STATUS);
      }
      
      break;
    case this.OFFLINE_STATUS:
      if (this.userStatus != this.OFFLINE_STATUS) {
        this.jabberLogout();
      }
      break;
    case this.AWAY_STATUS:
      if (this.userStatus != this.OFFLINE_STATUS) {
        this.jabberSendStatus(this.AWAY_STATUS);
      }
      break;  
    case this.EXTEND_AWAY_STATUS:
      if (this.userStatus != this.OFFLINE_STATUS) {
        this.jabberSendStatus(this.EXTEND_AWAY_STATUS);
      }
      break;  
    case this.FREE_TO_CHAT_STATUS:
      if (this.userStatus != this.OFFLINE_STATUS) {
        this.jabberSendStatus(this.FREE_TO_CHAT_STATUS);
      }
      break;  
    default:
      break;
  }
};

UIMainChatWindow.prototype.postChangeStatus = function(status, eventId) {
  if (!this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP] || 
      !status) {
    return false;
  }
  var serverData = this.serverDataStack[eventId];
  this.lastStatusSent = false;
  var DOMUtil = eXo.core.DOMUtil;
  var userNameNode = DOMUtil.findFirstDescendantByClass(this.statusIconNode, 'div', 'Text');
  userNameNode.innerHTML = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  var userStatusIconNode = DOMUtil.findAncestorByTagName(this.statusIconNode, 'div');
  console.warn('User changed status: ' + this.userStatus + ' -> ' + status);
  this.userStatus = status;
  switch (status) {
    case this.ONLINE_STATUS:
      userStatusIconNode.className = 'OnlineIcon';
      if (!serverData) {
        break;
      }
      this.serverInfo = serverData;
      this.UIChatWindow.initSession();
      this.timeoutCount = 0;
      this.errorCount = 0;
      this.addContactIconNode.onclick = function() {
        eXo.communication.chat.webui.UIAddContactPopupWindow.setVisible(true);
      };
      // Create buddy list
      if (this.serverInfo.roster) {
        this.buddyListControlObj.build(this.serverInfo.roster);
      }

      eXo.core.Cometd.exoId = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
      eXo.core.Cometd.exoToken = this.userToken;

      eXo.core.Cometd.subscribe('/eXo/Application/Chat/message', function(eventObj) {
        eXo.communication.chat.webui.UIMainChatWindow.messageListener(eventObj);
      });

      eXo.core.Cometd.subscribe('/eXo/Application/Chat/groupchat', function(eventObj) {
        eXo.communication.chat.webui.UIMainChatWindow.groupChatListener(eventObj);
      });

      eXo.core.Cometd.subscribe('/eXo/Application/Chat/presence', function(eventObj) {
        eXo.communication.chat.webui.UIMainChatWindow.presenceListener(eventObj);
      });

	    eXo.core.Cometd.subscribe('/eXo/Application/Chat/roster', function(eventObj) {
        eXo.communication.chat.webui.UIMainChatWindow.rosterListener(eventObj);
      });

      eXo.core.Cometd.subscribe('/eXo/Application/Chat/subscription', function(eventObj) {
        eXo.communication.chat.webui.UIMainChatWindow.subscriptionListener(eventObj);
      });

      if (!eXo.core.Cometd.isConnected()) {
  		  eXo.core.Cometd.init();
    	}
      
      // Register onunload event to window for clean logout when user leave this page.
      if (window.addEventListener) {
        window.addEventListener('unload', function() {eXo.communication.chat.webui.UIMainChatWindow.jabberLogout()}, false);
      } else {
        window.attachEvent('onunload', function() {eXo.communication.chat.webui.UIMainChatWindow.jabberLogout()}, false);
      }
      this.preChangeStatus(this.ONLINE_STATUS, true);
      
      break;
    case this.OFFLINE_STATUS:
    	if (eXo.core.Cometd.isConnected()) {
  		  eXo.core.Cometd.disconnect();
    	}
      this.buddyListControlObj.cleanup();
      this.addContactIconNode.onclick = null;
      userStatusIconNode.className = 'OfflineIcon';
      break;
    case this.AWAY_STATUS:
      userStatusIconNode.className = 'AwayIcon';
      break;  
    case this.EXTEND_AWAY_STATUS:
      userStatusIconNode.className = 'ExtendsAwayIcon';
      break;  
    case this.FREE_TO_CHAT_STATUS:
      userStatusIconNode.className = 'FreeToChat';
      break;  
    default:
      break;
  }
};

UIMainChatWindow.prototype.setChangeStatusMenuVisible = function(nodeObj, visible) {
  if (!nodeObj) {
    nodeObj = this.statusIconNode;
  }
  var menuNode = eXo.core.DOMUtil.findPreviousElementByTagName(nodeObj.parentNode, 'div');
  var display = visible ? 'block' : 'none';
  if (visible == null) {
    display = menuNode.style.display;
    if (display == 'block') {
      display = 'none';
    } else {
      display = 'block';
    }
  }
  if (display == 'block') {
    menuNode.style.top = nodeObj.offsetTop + nodeObj.offsetHeight;
    menuNode.style.left = nodeObj.offsetLeft;
  }
  if (menuNode.style.display != display) {
    menuNode.style.display = display;
  }
  if (display == 'block') {
    if (window.addEventListener) {
      document.addEventListener('click', this.setChangeStatusMenuVisibleWrapper, false);
    } else {
      document.attachEvent('onclick', this.setChangeStatusMenuVisibleWrapper, false);
    }
  } else {
    if (window.addEventListener) {
      document.removeEventListener('click', this.setChangeStatusMenuVisibleWrapper, false);
    } else {
      document.detachEvent('onclick', this.setChangeStatusMenuVisibleWrapper, false);
    }
  }
  return false;
};

UIMainChatWindow.prototype.setChangeStatusMenuVisibleWrapper = function(event) {
  event = event || window.event;
  var srcElement = event.srcElement || event.target;
  if (srcElement.className.indexOf('StatusIcon') != -1) {
    return true;
  }
  eXo.communication.chat.webui.UIMainChatWindow.setChangeStatusMenuVisible(null, false);
};

UIMainChatWindow.prototype.createRoomChat = function(roomInfo) {
  this.hostedRoomList[roomInfo.name] = roomInfo;
  this.jabberCreateRoom(roomInfo.name);
};

UIMainChatWindow.prototype.buddyItemActionCallbackWrapper = function(event) {
  event = event || window.event;
  return eXo.communication.chat.webui.UIMainChatWindow.buddyItemActionCallback(event);
};

UIMainChatWindow.prototype.buddyItemActionCallback = function(event) {
//  console.warn('button pressed:' + event.button);
  var buddyNode = event.srcElement || event.target;
  buddyNode = eXo.core.DOMUtil.findAncestorByClass(buddyNode, 'TitleIconChat');
  var targetPerson = buddyNode.getAttribute('username');
  switch (event.button) {
    // Left click
    case 0:
    case 1:
      this.createNewConversation(targetPerson);
      break;
    // Right click
    case 2: 
      this.preProcessBuddyItemAction(event);
      break;
  }
  this.cancelEvent(event);
  return false;
};

UIMainChatWindow.prototype.removeUserCallback = function(event) {
  event = event || window.event;
  var buddyNode = event.srcElement || event.target;
  buddyNode = eXo.core.DOMUtil.findAncestorByClass(buddyNode, 'TitleIconChat');
  var buddyId = buddyNode.getAttribute('userName');
  eXo.communication.chat.webui.UIMainChatWindow.removeContact(buddyId);
};

UIMainChatWindow.prototype.removeContact = function(buddyId) {
  if (window.confirm('Are you sure to remove \'' + buddyId + '\'')) {
    buddyId = buddyId.substring(0, buddyId.indexOf('@'));
    eXo.communication.chat.webui.UIMainChatWindow.jabberUnsubscriptUser(buddyId);
    eXo.communication.chat.webui.UIMainChatWindow.jabberRemoveUser(buddyId);
  }
};

/**
 * 
 * @param {Event} event
 */
UIMainChatWindow.prototype.createNewConversation = function(targetPerson) {
  this.UIChatWindow.createNewTab(targetPerson);
  return false;
};

/**
 * 
 * @param {Event} event
 */
UIMainChatWindow.prototype.preProcessBuddyItemAction = function(event) {
  event = event ? event : window.event;
  var buddyNode = event.srcElement || event.target;
  buddyNode = eXo.core.DOMUtil.findAncestorByClass(buddyNode, 'TitleIconChat');
  var userName = buddyNode.getAttribute('username');
  var uiMainChatWindow = eXo.communication.chat.webui.UIMainChatWindow;
  uiMainChatWindow.buddyItemActionStack['username'] = userName ;
  var topPos = event.clientY + document.documentElement.scrollTop;
  var leftPos = event.clientX + document.documentElement.scrollLeft;
  with (uiMainChatWindow.buddyItemActionMenuNode.style) {
    top = topPos + 'px';
    left = leftPos + 'px';
    display = 'block';
  }
  if (window.addEventListener) {
    window.addEventListener('click', uiMainChatWindow.postProcessBuddyItemAction, false);
  } else {
    window.attachEvent('onclick', uiMainChatWindow.postProcessBuddyItemAction, false);
  }
  return false;
};

UIMainChatWindow.prototype.postProcessBuddyItemAction = function(event, action) {
  event = event || window.event;
  if (!action) {
    if (event) {
      var srcElement = event.srcElement || event.target;
      if (srcElement.className.indexOf('IconChat') != -1) {
        return true;
      }
    }
    var UIMainChatWindow = eXo.communication.chat.webui.UIMainChatWindow;
    UIMainChatWindow.buddyItemActionMenuNode.style.display = 'none';
    if (window.addEventListener) {
      window.removeEventListener('click', UIMainChatWindow.postProcessBuddyItemAction, false);
    } else {
      window.detachEvent('onclick', UIMainChatWindow.postProcessBuddyItemAction, false);
    }
    return;
  }
  this.buddyItemActionMenuNode.style.display = 'none';
  var targetPerson = this.buddyItemActionStack['username'];
  if (!targetPerson) {
    return;
  }
  switch (action) {
    case this.REMOVE_USER_ACTION:
      this.removeContact(targetPerson);
      break;
    case this.CREATE_CONVERSATION_ACTION:
      this.UIChatWindow.createNewTab(targetPerson);
      break;
    default:
      break;
  }
  this.buddyItemActionStack['username'] = false;
};

/**
 *
 * @param {Array} contactList
 */
UIMainChatWindow.prototype.addContacts = function(contactList){
  for (var i=0; i<contactList.length; i++) {
    var contact = contactList[i];
    this.jabberAddUser(contact);
  }
};

/**
 *
 * @param {Array} messages
 */
UIMainChatWindow.prototype.displayMessages = function(messages) {
  try {
    if (messages.length > 1) {
      var lastSender = messages[0].from;
      var lastSenderPoint = 0;
      for (var i=1; i<messages.length; i++) {
        var msgObj = messages[i];
        if (lastSender != msgObj.from || i == (messages.length -1)) {
          var buffer = '';
          for (var j=lastSenderPoint; j<=i; j++) {
            if (j<i) {
              buffer += messages[j].body + '<br/>';
            } else {
              buffer += messages[j].body;
            }
          }
          var isGroupChat = false;
          if (messages[lastSenderPoint].type == 'groupchat') {
            isGroupChat = true;
          }
          this.UIChatWindow.displayMessage(messages[lastSenderPoint].from, buffer, isGroupChat);
          lastSenderPoint = i;
          lastSender = msgObj.from;
        }
      }
    } else if (messages.length > 0) {
      var msgObj = messages[0];
      var isGroupChat = false;
      if (msgObj.type == 'groupchat') {
        isGroupChat = true;
      }
      this.UIChatWindow.displayMessage(msgObj.from, msgObj.body, isGroupChat);
    }
  } catch(e) {
    console.error('Look up error! developer');
    console.dir(e);
    debugger;
  }
};

// -/-

// -- Organization service ----
UIMainChatWindow.prototype.orgFuzzySearchUser = function(question, from, to) {
  this.activeAction = this.ORG_FUZZY_SEARCH_USER_ACTION;
  question = question || '';
  this.XMPPCommunicator.orgFuzzySearchUser(question, from, to, this.getAjaxHandler());
};

// -- Organization service ----
UIMainChatWindow.prototype.orgSearchUser = function(userName) {
  this.activeAction = this.ORG_GET_ALL_CONTACT_ACTION;
  userName = userName || '';
  this.XMPPCommunicator.orgSearchUser(userName, this.getAjaxHandler());
};
// -/-

// -- Wrapper method ----------
UIMainChatWindow.prototype.wrapperMethod = function(callbackMethod) {
  if (callbackMethod) {
    eval(callbackMethod);
  }
};

// -- Jabber protocol handle --
UIMainChatWindow.prototype.jabberLogin = function(userName) {
  if (!userName || userName == 'null') {
    return false;
  }
  this.userNames['xmpp'] = userName;
  this.activeAction = this.LOGIN_ACTION;
  this.XMPPCommunicator.addTransport(this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler());
  return false;
};

UIMainChatWindow.prototype.jabberCleanBuddyList = function() {
  this.activeAction = this.CLEAN_BUDDY_LIST_ACTION;
  this.XMPPCommunicator.cleanBuddyList(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler());
};

UIMainChatWindow.prototype.jabberRemoveUser = function(buddyId) {
  this.activeAction = this.REMOVE_USER_ACTION;
  this.XMPPCommunicator.removeUser(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], buddyId, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler());
};

UIMainChatWindow.prototype.jabberUnsubscriptUser = function(buddyId) {
  this.activeAction = this.UNSUBSCRIPT_BUDDY_ACTION;
  this.XMPPCommunicator.unSubscribeUser(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], buddyId, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler());
};

UIMainChatWindow.prototype.jabberSendStatus = function(status) {
  this.activeAction = this.SEND_STATUS_ACTION;
  this.XMPPCommunicator.sendStatus(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler(), status);
};

UIMainChatWindow.prototype.jabberSendMessage = function(sendTo, msg) {
  this.activeAction = this.SEND_MESSAGE_ACTION;
  var msgPackage = '{"to":"' + sendTo + '", "body":"' + msg + '"}';
  this.XMPPCommunicator.sendMessage(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler(), msgPackage);
};

UIMainChatWindow.prototype.jabberSendRoomMessage = function(sendTo, msg) {
  this.activeAction = this.SEND_MESSAGE_ACTION;
  var msgPackage = '{"to":"' + sendTo + '", "body":"' + msg + '"}';
  this.XMPPCommunicator.sendRoomMessage(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler(), msgPackage);
};

UIMainChatWindow.prototype.jabberGetSubscriptionRequests = function() {
  this.activeAction = this.GET_SUBSCRIPTION_REQUESTS_ACTION;
  this.isGetMsgInProcess = true;
  this.XMPPCommunicator.getSubscriptionRequests(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler());
};

UIMainChatWindow.prototype.jabberAsk4Subscription = function(ask4SubUser) {
  this.activeAction = this.ASK_4_SUBSCRIPTION_ACTION;
  this.XMPPCommunicator.askForSubscription(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], ask4SubUser, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler());
};

UIMainChatWindow.prototype.jabberAddUser = function(addUser) {
  this.activeAction = this.ADD_USER_ACTION;
  this.XMPPCommunicator.addUser(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], addUser, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler());
};

UIMainChatWindow.prototype.jabberSendSubscription = function(subUser) {
  this.activeAction = this.SEND_SUBSCRIPTION_ACTION;
  this.XMPPCommunicator.subscribeUser(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], subUser, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler());
};

/**
 * 
 * @param {String} roomName
 */
UIMainChatWindow.prototype.jabberCreateRoom = function(roomName) {
  this.UIChatWindow.createNewTab(roomName + '@' + this.serverInfo.mucServicesNames[0], true);
  this.activeAction = this.CREATE_ROOM_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.createRoomchat(userName, userName, roomName, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler()); 
};

/**
 * 
 * @param {String} roomName
 * @param {String} roomConfigJson
 */
UIMainChatWindow.prototype.jabberSendConfigRoom = function(roomName, roomConfigJson) {
  this.activeAction = this.CONFIG_ROOM_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.sendConfigRoom(userName, roomName, roomConfigJson, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler()); 
};

/**
 * 
 * @param {String} roomName
 */
UIMainChatWindow.prototype.jabberGetRoomInfo = function(roomName) {
  this.activeAction = this.GET_ROOM_INFO_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.getRoomInfo(userName, roomName, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler()); 
};

/**
 * 
 * @param {String} roomName
 */
UIMainChatWindow.prototype.jabberGetRoomConfig = function(roomName) {
  this.activeAction = this.GET_ROOM_CONFIG_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.getRoomConfig(userName, roomName, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler()); 
};

UIMainChatWindow.prototype.jabberGetRoomList = function() {
  this.activeAction = this.GET_ROOM_LIST_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.getRoomList(userName, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler()); 
};

UIMainChatWindow.prototype.jabberSetRoleRoom = function(roomName, nickName, role, command) {
  this.activeAction = this.SET_ROLE_ROOM_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.setRoleForRoom(userName, nickName, roomName, role, command, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler);
};

UIMainChatWindow.prototype.jabberKickUserFromRoom = function(roomName, nickName, reason) {
  this.activeAction = this.KICK_USER_FROM_ROOM_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.kickUserFromRoom(userName, nickName, roomName, reason, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler);
};

UIMainChatWindow.prototype.jabberBanUserFromRoom = function(roomName, nickName, reason) {
  this.activeAction = this.BAN_USER_FROM_ROOM_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.banUserFromRoom(userName, nickName, roomName, reason, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler);
};

/**
 * 
 * @param {String} inviter
 * @param {String} roomName
 */
UIMainChatWindow.prototype.jabberInviteJoinRoom = function(inviter, roomName) {
  this.activeAction = this.INVITE_JOIN_ROOM_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.inviteJoinRoom(userName, inviter, roomName, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler()); 
};

/**
 * 
 * @param {String} inviter
 * @param {String} roomName
 */
UIMainChatWindow.prototype.jabberDeclineJoinRoom = function(inviter, roomName) {
  this.activeAction = this.DECLINE_JOIN_ROOM_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.declineInviteJoinRoom(userName, inviter, roomName, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler()); 
};

/**
 * 
 * @param {String} roomName
 */
UIMainChatWindow.prototype.jabberJoinToRoom = function(roomName) {
  this.UIChatWindow.createNewTab(roomName + '@' + this.serverInfo.mucServicesNames[0], true);
  this.activeAction = this.JOIN_TO_ROOM_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.joinToRoom(userName, roomName, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler()); 
};

/**
 * 
 * @param {String} roomName
 */
UIMainChatWindow.prototype.jabberLeaveFromRoom = function(roomName) {
  this.activeAction = this.LEAVE_FROM_ROOM_ACTION;
  var userName = this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP];
  this.XMPPCommunicator.leaveFromRoom(userName, roomName, this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler()); 
};

UIMainChatWindow.prototype.jabberLogout = function() {
  if (window.parent &&
      window.parent.eXo.communication.chat.webui.eXoChatLoader) {
    window.parent.eXo.communication.chat.webui.eXoChatLoader.setChatWindowVisible(false);
  }
  if (!this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP]) {
  	return;
  }
  // Remove all old cookies for last session
  document.cookie = ''; 
  this.activeAction = this.LOGOUT_ACTION;
  this.XMPPCommunicator.removeTransport(this.userNames[this.XMPPCommunicator.TRANSPORT_XMPP], this.XMPPCommunicator.TRANSPORT_XMPP, this.getAjaxHandler());
  return false;
};
// -/-

UIMainChatWindow.prototype.yahooLogin = function(nodeObj) {};

UIMainChatWindow.prototype.gtalkLogin = function(nodeObj) {};

UIMainChatWindow.prototype.msnLogin = function(nodeObj) {};

UIMainChatWindow.prototype.aimLogin = function(nodeObj) {};

UIMainChatWindow.prototype.icqLogin = function(nodeObj) {};

eXo.communication.chat.webui.UIMainChatWindow = new UIMainChatWindow();
