/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.rest.RESTOrganizationService;
import org.exoplatform.services.rest.Response;

public abstract class RESTOrganizationServiceAbstractImpl
implements RESTOrganizationService {
    protected static final Log LOGGER = ExoLogger.getLogger((String)"ws.RESTOrganizationService");
    protected final GroupHandler groupHandler;
    protected final UserHandler userHandler;
    protected final MembershipHandler membershipHandler;
    protected final MembershipTypeHandler membershipTypeHandler;

    protected RESTOrganizationServiceAbstractImpl(OrganizationService organizationService) {
        this.groupHandler = organizationService.getGroupHandler();
        this.userHandler = organizationService.getUserHandler();
        this.membershipHandler = organizationService.getMembershipHandler();
        this.membershipTypeHandler = organizationService.getMembershipTypeHandler();
    }

    public Response createGroup(String baseURI, String groupName, String label, String description, String parentId) {
        Group parent = null;
        Group group = null;
        try {
            if (parentId != null && parentId.length() > 0 && (parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId)) == null) {
                return Response.Builder.withStatus((int)404).errorMessage("Parent group '" + parentId + "' not found!").build();
            }
            group = this.groupHandler.createGroupInstance();
            group.setGroupName(groupName);
            group.setLabel(label);
            group.setDescription(description);
            this.groupHandler.addChild(parent, group, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
        return Response.Builder.ok((Object)group).build();
    }

    public Response createMembership(String baseURI, String username, String groupId, String type) {
        Membership m = null;
        try {
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                return Response.Builder.withStatus((int)404).errorMessage("User : '" + username + "' not found!").build();
            }
            Group group = this.groupHandler.findGroupById(groupId = groupId.startsWith("/") ? groupId : "/" + groupId);
            if (group == null) {
                return Response.Builder.withStatus((int)404).errorMessage("Group : '" + groupId + "' not found!").build();
            }
            MembershipType membershipType = this.membershipTypeHandler.findMembershipType(type);
            m = this.membershipHandler.findMembershipByUserGroupAndType(username, groupId, type);
            if (membershipType == null) {
                return Response.Builder.withStatus((int)404).errorMessage("MembershipType : '" + type + "' not found!").build();
            }
            this.membershipHandler.linkMembership(user, group, membershipType, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
        return Response.Builder.ok((Object)m).build();
    }

    public Response createUser(String baseURI, String username, String password, String firstname, String lastname, String email) {
        try {
            User user = this.userHandler.createUserInstance(username);
            if (user == null) {
                return Response.Builder.withStatus((int)404).errorMessage("User '" + username + "' not found.").build();
            }
            user.setPassword(password);
            user.setFirstName(firstname);
            user.setLastName(lastname);
            user.setEmail(email);
            this.userHandler.createUser(user, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
        return null;
    }

    public Response deleteGroup(String groupId) {
        try {
            groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            Group group = this.groupHandler.findGroupById(groupId);
            if (group == null) {
                return Response.Builder.withStatus((int)404).errorMessage("Group '" + groupId + "' not found!").build();
            }
            this.groupHandler.removeGroup(group, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
        return null;
    }

    public Response deleteMembership(String membershipId) {
        try {
            this.membershipHandler.removeMembership(membershipId, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
        return null;
    }

    public Response deleteUser(String username) {
        try {
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                return Response.Builder.withStatus((int)404).errorMessage("User '" + username + "' not found.").build();
            }
            this.userHandler.removeUser(username, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
        return null;
    }

    public Response deleteUserFromGroup(String baseURI, String groupId, String username) {
        try {
            String string = groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            if (this.userHandler.findUserByName(username) == null || this.groupHandler.findGroupById(groupId) == null) {
                return Response.Builder.withStatus((int)404).errorMessage("Group or user not found!").build();
            }
            Collection memberships = this.membershipHandler.findMembershipsByUserAndGroup(username, groupId);
            for (Membership m : memberships) {
                this.membershipHandler.removeMembership(m.getId(), true);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
        return null;
    }

    public Response updateGroup(String baseURI, String groupId, String name, String label, String description) {
        try {
            groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            Group group = this.groupHandler.findGroupById(groupId);
            if (group == null) {
                return Response.Builder.withStatus((int)404).errorMessage("Group '" + groupId + "' not found!").build();
            }
            group.setGroupName(name);
            group.setLabel(label);
            group.setDescription(description);
            this.groupHandler.saveGroup(group, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
        return null;
    }

    public Response updateUser(String baseURI, String username, String password, String firstname, String lastname, String email) {
        try {
            User user = this.userHandler.findUserByName(username);
            user.setPassword(password);
            user.setFirstName(firstname);
            user.setLastName(lastname);
            user.setEmail(email);
            this.userHandler.saveUser(user, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot manage user : ", (Throwable)e);
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
        return null;
    }
}

