/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven.plugin.exobuild;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.codehaus.plexus.util.StringUtils;
import org.exoplatform.maven.plugin.exobuild.AbstractDependencyMojo;
import org.exoplatform.maven.plugin.exobuild.utils.DependencyStatusSets;
import org.exoplatform.maven.plugin.exobuild.utils.resolvers.DefaultArtifactsResolver;
import org.exoplatform.maven.plugin.exobuild.utils.translators.ClassifierTypeTranslator;

public abstract class AbstractDependencyFilterMojo
extends AbstractDependencyMojo {
    protected boolean excludeTransitive;
    protected String includeTypes;
    protected String excludeTypes;
    protected String includeScope;
    protected String excludeScope;
    protected String includeClassifiers;
    protected String excludeClassifiers;
    protected String classifier;
    protected String type;
    protected String excludeArtifactIds;
    protected String includeArtifactIds;
    protected String excludeGroupIds;
    protected String includeGroupIds;
    protected File markersDirectory;
    protected boolean overWriteReleases;
    protected boolean overWriteSnapshots;
    protected boolean overWriteIfNewer;

    protected abstract ArtifactsFilter getMarkedArtifactFilter();

    protected Set getResolvedDependencies(boolean stopOnFailure) throws MojoExecutionException {
        DependencyStatusSets status = this.getDependencySets(stopOnFailure);
        return status.getResolvedDependencies();
    }

    protected DependencyStatusSets getDependencySets(boolean stopOnFailure) throws MojoExecutionException {
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ScopeFilter(this.includeScope, this.excludeScope));
        filter.addFilter((ArtifactsFilter)new TypeFilter(this.includeTypes, this.excludeTypes));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(this.includeClassifiers, this.excludeClassifiers));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(this.includeGroupIds, this.excludeGroupIds));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(this.includeArtifactIds, this.excludeArtifactIds));
        Set artifacts = this.project.getArtifacts();
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        DependencyStatusSets status = null;
        status = StringUtils.isNotEmpty((String)this.classifier) ? this.getClassifierTranslatedDependencies(artifacts, stopOnFailure) : this.filterMarkedDependencies(artifacts);
        return status;
    }

    protected DependencyStatusSets getClassifierTranslatedDependencies(Set artifacts, boolean stopOnFailure) throws MojoExecutionException {
        HashSet unResolvedArtifacts = new HashSet();
        Set resolvedArtifacts = artifacts;
        DependencyStatusSets status = new DependencyStatusSets();
        if (StringUtils.isNotEmpty((String)this.classifier)) {
            ClassifierTypeTranslator translator = new ClassifierTypeTranslator(this.classifier, this.type, this.factory);
            artifacts = translator.translate(artifacts, this.getLog());
            status = this.filterMarkedDependencies(artifacts);
            artifacts = status.getResolvedDependencies();
            DefaultArtifactsResolver artifactsResolver = new DefaultArtifactsResolver(this.resolver, this.local, this.remoteRepos, stopOnFailure);
            resolvedArtifacts = artifactsResolver.resolve(artifacts, this.getLog());
            unResolvedArtifacts.addAll(artifacts);
            unResolvedArtifacts.removeAll(resolvedArtifacts);
        }
        status.setResolvedDependencies(resolvedArtifacts);
        status.setUnResolvedDependencies(unResolvedArtifacts);
        return status;
    }

    protected DependencyStatusSets filterMarkedDependencies(Set artifacts) throws MojoExecutionException {
        Set unMarkedArtifacts;
        FilterArtifacts filter = new FilterArtifacts();
        filter.clearFilters();
        filter.addFilter(this.getMarkedArtifactFilter());
        try {
            unMarkedArtifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        HashSet skippedArtifacts = new HashSet();
        skippedArtifacts.addAll(artifacts);
        skippedArtifacts.removeAll(unMarkedArtifacts);
        return new DependencyStatusSets(unMarkedArtifacts, null, skippedArtifacts);
    }

    public File getMarkersDirectory() {
        return this.markersDirectory;
    }

    public void setMarkersDirectory(File theMarkersDirectory) {
        this.markersDirectory = theMarkersDirectory;
    }
}

