/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven.plugin.exobuild.fromConfiguration;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.exoplatform.maven.plugin.exobuild.fromConfiguration.AbstractFromConfigurationMojo;
import org.exoplatform.maven.plugin.exobuild.fromConfiguration.ArtifactItem;
import org.exoplatform.maven.plugin.exobuild.utils.filters.ArtifactItemFilter;
import org.exoplatform.maven.plugin.exobuild.utils.filters.DestFileFilter;

public class CopyMojo
extends AbstractFromConfigurationMojo {
    private boolean stripVersion = false;

    public void execute() throws MojoExecutionException {
        ArrayList theArtifactItems = this.getProcessedArtifactItems(this.stripVersion);
        for (ArtifactItem artifactItem : theArtifactItems) {
            if (artifactItem.isNeedsProcessing()) {
                this.copyArtifact(artifactItem);
                continue;
            }
            this.getLog().info((CharSequence)(artifactItem + " already exists in " + artifactItem.getOutputDirectory()));
        }
    }

    protected void copyArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        File destFile = new File(artifactItem.getOutputDirectory(), artifactItem.getDestFileName());
        this.copyFile(artifactItem.getArtifact().getFile(), destFile);
    }

    protected ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem item) {
        DestFileFilter destinationNameOverrideFilter = new DestFileFilter(this.isOverWriteReleases(), this.isOverWriteSnapshots(), this.isOverWriteIfNewer(), false, false, false, this.stripVersion, item.getOutputDirectory());
        return destinationNameOverrideFilter;
    }

    public boolean isStripVersion() {
        return this.stripVersion;
    }

    public void setStripVersion(boolean stripVersion) {
        this.stripVersion = stripVersion;
    }
}

