/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventFilter;
import org.jboss.servlet.http.HttpEventFilterChain;
import org.jboss.servlet.http.HttpEventServlet;

public final class ApplicationFilterChain
implements FilterChain,
HttpEventFilterChain {
    private static final ThreadLocal lastServicedRequest;
    private static final ThreadLocal lastServicedResponse;
    public static final int INCREMENT = 10;
    private RequestFacade requestFacade = null;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pointer = 0;
    private int pos = 0;
    private int filterCount = 0;
    private Wrapper wrapper = null;
    private Servlet servlet = null;
    private static final StringManager sm;
    private static Class[] classType;
    private static Class[] classTypeUsedInService;
    private static Class[] cometClassType;
    private static Class[] classTypeUsedInEvent;

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            final ServletRequest req = request;
            final ServletResponse res = response;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilter(req, res);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.internalDoFilter(request, response);
        }
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        InstanceSupport support = this.wrapper.getInstanceSupport();
        Throwable throwable = null;
        if (this.pos < this.filterCount) {
            ApplicationFilterConfig filterConfig = this.filters[this.pos++];
            ++this.pointer;
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                support.fireInstanceEvent("beforeFilter", filter, request, response);
                if (Globals.IS_SECURITY_ENABLED) {
                    ServletRequest req = request;
                    ServletResponse res = response;
                    Principal principal = ((HttpServletRequest)req).getUserPrincipal();
                    Object[] args = new Object[]{req, res, this};
                    SecurityUtil.doAsPrivilege("doFilter", filter, classType, args, principal);
                    args = null;
                } else {
                    filter.doFilter(request, response, (FilterChain)this);
                }
            }
            catch (IOException e) {
                throwable = e;
                throw e;
            }
            catch (ServletException e) {
                throwable = e;
                throw e;
            }
            catch (RuntimeException e) {
                throwable = e;
                throw e;
            }
            catch (Throwable e) {
                throwable = e;
                throw new ServletException(sm.getString("filterChain.filter"), e);
            }
            finally {
                --this.pointer;
                if (filter != null) {
                    support.fireInstanceEvent("afterFilter", filter, request, response, throwable);
                }
            }
            return;
        }
        ++this.pointer;
        try {
            support.fireInstanceEvent("beforeService", this.servlet, request, response);
            if (Globals.STRICT_SERVLET_COMPLIANCE) {
                lastServicedRequest.set(request);
                lastServicedResponse.set(response);
            }
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                if (Globals.IS_SECURITY_ENABLED) {
                    ServletRequest req = request;
                    ServletResponse res = response;
                    Principal principal = ((HttpServletRequest)req).getUserPrincipal();
                    Object[] args = new Object[]{req, res};
                    SecurityUtil.doAsPrivilege("service", this.servlet, classTypeUsedInService, args, principal);
                    args = null;
                } else {
                    this.servlet.service((ServletRequest)((HttpServletRequest)request), (ServletResponse)((HttpServletResponse)response));
                }
            } else {
                this.servlet.service(request, response);
            }
        }
        catch (IOException e) {
            throwable = e;
            throw e;
        }
        catch (ServletException e) {
            throwable = e;
            throw e;
        }
        catch (RuntimeException e) {
            throwable = e;
            throw e;
        }
        catch (Throwable e) {
            throwable = e;
            throw new ServletException(sm.getString("filterChain.servlet"), e);
        }
        finally {
            --this.pointer;
            if (Globals.STRICT_SERVLET_COMPLIANCE) {
                lastServicedRequest.set(null);
                lastServicedResponse.set(null);
            }
            support.fireInstanceEvent("afterService", this.servlet, request, response, throwable);
        }
    }

    @Override
    public void doFilterEvent(HttpEvent event) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            final HttpEvent ev = event;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilterEvent(ev);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.internalDoFilterEvent(event);
        }
    }

    public static ServletRequest getLastServicedRequest() {
        return (ServletRequest)lastServicedRequest.get();
    }

    public static ServletResponse getLastServicedResponse() {
        return (ServletResponse)lastServicedResponse.get();
    }

    private void internalDoFilterEvent(HttpEvent event) throws IOException, ServletException {
        InstanceSupport support = this.wrapper.getInstanceSupport();
        Throwable throwable = null;
        if (this.pos < this.filterCount) {
            ApplicationFilterConfig filterConfig = this.filters[this.pos++];
            ++this.pointer;
            HttpEventFilter filter = null;
            try {
                filter = (HttpEventFilter)filterConfig.getFilter();
                support.fireInstanceEvent("beforeFilter", (Filter)filter, event);
                if (Globals.IS_SECURITY_ENABLED) {
                    HttpEvent ev = event;
                    Principal principal = ev.getHttpServletRequest().getUserPrincipal();
                    Object[] args = new Object[]{ev, this};
                    SecurityUtil.doAsPrivilege("doFilterEvent", filter, cometClassType, args, principal);
                    args = null;
                } else {
                    filter.doFilterEvent(event, this);
                }
            }
            catch (IOException e) {
                throwable = e;
                throw e;
            }
            catch (ServletException e) {
                throwable = e;
                throw e;
            }
            catch (RuntimeException e) {
                throwable = e;
                throw e;
            }
            catch (Throwable e) {
                throwable = e;
                throw new ServletException(sm.getString("filterChain.filter"), e);
            }
            finally {
                --this.pointer;
                if (filter != null) {
                    support.fireInstanceEvent("afterFilter", (Filter)filter, event, throwable);
                }
            }
            return;
        }
        ++this.pointer;
        try {
            support.fireInstanceEvent("beforeService", this.servlet, event);
            if (Globals.IS_SECURITY_ENABLED) {
                HttpEvent ev = event;
                Principal principal = ev.getHttpServletRequest().getUserPrincipal();
                Object[] args = new Object[]{ev};
                SecurityUtil.doAsPrivilege("event", this.servlet, classTypeUsedInEvent, args, principal);
                args = null;
            } else {
                ((HttpEventServlet)this.servlet).event(event);
            }
        }
        catch (IOException e) {
            throwable = e;
            throw e;
        }
        catch (ServletException e) {
            throwable = e;
            throw e;
        }
        catch (RuntimeException e) {
            throwable = e;
            throw e;
        }
        catch (Throwable e) {
            throwable = e;
            throw new ServletException(sm.getString("filterChain.servlet"), e);
        }
        finally {
            --this.pointer;
            support.fireInstanceEvent("afterService", this.servlet, event, throwable);
        }
    }

    void addFilter(ApplicationFilterConfig filterConfig) {
        if (this.filterCount == this.filters.length) {
            ApplicationFilterConfig[] newFilters = new ApplicationFilterConfig[this.filterCount + 10];
            System.arraycopy(this.filters, 0, newFilters, 0, this.filterCount);
            this.filters = newFilters;
        }
        this.filters[this.filterCount++] = filterConfig;
    }

    void release() {
        for (int i = 0; i < this.filterCount; ++i) {
            this.filters[i] = null;
        }
        this.filterCount = 0;
        this.pos = 0;
        this.pointer = 0;
        this.servlet = null;
        this.wrapper = null;
        this.requestFacade.releaseFilterChain();
    }

    void reuse() {
        this.pos = 0;
        this.pointer = 0;
    }

    void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setRequestFacade(RequestFacade requestFacade) {
        this.requestFacade = requestFacade;
    }

    public ApplicationFilterConfig[] getFilters() {
        return this.filters;
    }

    public int getFilterCount() {
        return this.filterCount;
    }

    public int getPointer() {
        return this.pointer;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    static {
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            lastServicedRequest = new ThreadLocal();
            lastServicedResponse = new ThreadLocal();
        } else {
            lastServicedRequest = null;
            lastServicedResponse = null;
        }
        sm = StringManager.getManager("org.apache.catalina.core");
        classType = new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class};
        classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};
        cometClassType = new Class[]{HttpEvent.class, HttpEventFilterChain.class};
        classTypeUsedInEvent = new Class[]{HttpEvent.class};
    }
}

