/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.jni.Library;
import org.jboss.logging.Logger;

public class AprLifecycleListener
implements LifecycleListener {
    private static Logger log = Logger.getLogger(AprLifecycleListener.class);
    protected StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected static final int TCN_REQUIRED_MAJOR = 1;
    protected static final int TCN_REQUIRED_MINOR = 1;
    protected static final int TCN_REQUIRED_PATCH = 8;
    protected static final int TCN_RECOMMENDED_PV = 21;
    protected static String SSLEngine = "on";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean aprInitialized = false;

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("init".equals(event.getType()) && (aprInitialized = this.init())) {
            try {
                AprLifecycleListener.initializeSSL();
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) {
                    log.info((Object)this.sm.getString("aprListener.sslInit"));
                }
                log.debug((Object)this.sm.getString("aprListener.sslInit"), t);
            }
        }
    }

    private boolean init() {
        int major = 0;
        int minor = 0;
        int patch = 0;
        if (aprInitialized) {
            return true;
        }
        try {
            String methodName = "initialize";
            Class[] paramTypes = new Class[]{String.class};
            Object[] paramValues = new Object[]{null};
            Class<?> clazz = Class.forName("org.apache.tomcat.jni.Library");
            Method method = clazz.getMethod(methodName, paramTypes);
            method.invoke(null, paramValues);
            major = clazz.getField("TCN_MAJOR_VERSION").getInt(null);
            minor = clazz.getField("TCN_MINOR_VERSION").getInt(null);
            patch = clazz.getField("TCN_PATCH_VERSION").getInt(null);
        }
        catch (Throwable t) {
            if (!log.isDebugEnabled()) {
                log.info((Object)this.sm.getString("aprListener.aprInit", System.getProperty("java.library.path")));
            } else {
                log.debug((Object)this.sm.getString("aprListener.aprInit", System.getProperty("java.library.path")), t);
            }
            return false;
        }
        if (major != 1 || minor != 1 || patch < 8) {
            log.error((Object)this.sm.getString("aprListener.tcnInvalid", major + "." + minor + "." + patch, "1.1.8"));
            return false;
        }
        if (patch < 21) {
            if (!log.isDebugEnabled()) {
                log.info((Object)this.sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.1.21"));
            } else {
                log.debug((Object)this.sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.1.21"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("aprListener.tcnValid", major + "." + minor + "." + patch));
            log.debug((Object)this.sm.getString("aprListener.flags", Library.APR_HAVE_IPV6, Library.APR_HAS_SENDFILE, Library.APR_HAS_RANDOM));
        }
        return true;
    }

    private static synchronized void initializeSSL() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        String methodName = "randSet";
        Class[] paramTypes = new Class[]{String.class};
        Object[] paramValues = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("org.apache.tomcat.jni.SSL");
        Method method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        methodName = "initialize";
        paramValues[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        sslInitialized = true;
    }

    public static boolean isAprInitialized() {
        return aprInitialized;
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String SSLEngine) {
        AprLifecycleListener.SSLEngine = SSLEngine;
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        AprLifecycleListener.SSLRandomSeed = SSLRandomSeed;
    }
}

