/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.utils.AbstractWSDLFilePublisher;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSDLFilePublisher
extends AbstractWSDLFilePublisher {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSDLFilePublisher.class);
    private static final Logger log = Logger.getLogger(WSDLFilePublisher.class);

    public WSDLFilePublisher(ArchiveDeployment dep) {
        super(dep);
    }

    public void publishWsdlFiles(QName serviceName, String wsdlLocation, Bus bus, List<ServiceInfo> serviceInfos) throws IOException {
        String deploymentName = this.dep.getCanonicalName();
        File wsdlFile = this.getPublishLocation(serviceName.getLocalPart(), deploymentName, wsdlLocation);
        wsdlFile.getParentFile().mkdirs();
        try {
            ServiceWSDLBuilder builder = new ServiceWSDLBuilder(bus, serviceInfos);
            Definition def = builder.build();
            Document doc = WSDLFilePublisher.getWsdlDocument(bus, def);
            WSDLFilePublisher.writeDocument(doc, wsdlFile);
            URL wsdlPublishURL = new URL(URLDecoder.decode(wsdlFile.toURI().toURL().toExternalForm(), "UTF-8"));
            log.info((Object)("WSDL published to: " + wsdlPublishURL));
            if (def == null) {
                throw new NotImplementedException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"WSDL20_NOT_SUPPORTED", (Object[])new Object[0]));
            }
            LinkedList published = new LinkedList();
            this.publishWsdlImports(wsdlPublishURL, def, published);
            this.publishSchemaImports(wsdlPublishURL, doc.getDocumentElement(), published);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PUBLISH_WSDL", (Object[])new Object[]{wsdlFile}), e);
        }
    }

    private static Document getWsdlDocument(Bus bus, Definition def) throws WSDLException {
        WSDLWriter wsdlWriter = ((WSDLManager)bus.getExtension(WSDLManager.class)).getWSDLFactory().newWSDLWriter();
        def.setExtensionRegistry(((WSDLManager)bus.getExtension(WSDLManager.class)).getExtensionRegistry());
        return wsdlWriter.getDocument(def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDocument(Document doc, File file) throws IOException, XMLStreamException {
        String enc = null;
        try {
            enc = doc.getXmlEncoding();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (enc == null) {
            enc = "utf-8";
        }
        FileOutputStream fos = new FileOutputStream(new File(file.toURI()));
        try {
            XMLStreamWriter writer = StaxUtils.createXMLStreamWriter((OutputStream)fos, (String)enc);
            StaxUtils.writeNode((Node)doc, (XMLStreamWriter)writer, (boolean)true);
            writer.flush();
        }
        finally {
            fos.close();
        }
    }

    private File getPublishLocation(String serviceName, String archiveName, String wsdlLocation) throws IOException {
        File result;
        if (wsdlLocation == null && serviceName == null) {
            log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GET_PUBLISH_LOCATION", (Object[])new Object[0]));
            return null;
        }
        if (archiveName.startsWith("http://")) {
            archiveName = archiveName.replace("http://", "http-");
        }
        File locationFile = new File(this.serverConfig.getServerDataDir().getCanonicalPath() + "/wsdl/" + archiveName);
        if (wsdlLocation != null && wsdlLocation.indexOf(this.expLocation) >= 0) {
            wsdlLocation = wsdlLocation.substring(wsdlLocation.indexOf(this.expLocation) + this.expLocation.length());
            result = new File(locationFile + "/" + wsdlLocation);
        } else if (wsdlLocation != null && (wsdlLocation.startsWith("vfsfile:") || wsdlLocation.startsWith("file:") || wsdlLocation.startsWith("jar:") || wsdlLocation.startsWith("vfszip:"))) {
            wsdlLocation = wsdlLocation.substring(wsdlLocation.lastIndexOf("/") + 1);
            result = new File(locationFile + "/" + wsdlLocation);
        } else {
            result = new File(locationFile + "/" + serviceName + ".wsdl");
        }
        return result;
    }
}

