/*
 * Copyright (C) 2003-2012 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.forum.service.cache.model.key;

import org.exoplatform.forum.common.cache.model.ScopeCacheKey;



public class PostListCountKey extends ScopeCacheKey {
  private static final long serialVersionUID = 1L;

  private final String type;
  private final String key;
  private final String topicId;

  public PostListCountKey(String type, String key, String topicId) {
    this.type = type;
    this.key = key;
    this.topicId = topicId;
  }
  
  public String getTopicId() {
    return topicId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof PostListCountKey)) return false;
    if (!super.equals(o)) return false;

    PostListCountKey that = (PostListCountKey) o;

    if (key != null ? !key.equals(that.key) : that.key != null) return false;
    if (type != null ? !type.equals(that.type) : that.type != null) return false;
    if (topicId != null ? !topicId.equals(that.topicId) : that.topicId != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = super.hashCode();
    result = 31 * result + (type != null ? type.hashCode() : 0);
    result = 31 * result + (key != null ? key.hashCode() : 0);
    result = 31 * result + (topicId != null ? topicId.hashCode() : 0);
    return result;
  }
}
