/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.exoplatform.services.jcr.impl.core.query.sql;

public class ASTLiteral extends SimpleNode
{

   private String value;

   private int type;

   public ASTLiteral(int id)
   {
      super(id);
   }

   public ASTLiteral(JCRSQLParser p, int id)
   {
      super(p, id);
   }

   public String getValue()
   {
      return value;
   }

   public void setValue(String value)
   {
      this.value = value;
   }

   public int getType()
   {
      return type;
   }

   public void setType(int type)
   {
      this.type = type;
   }

   /**
    * Accept the visitor. *
    */
   public Object jjtAccept(JCRSQLParserVisitor visitor, Object data)
   {
      return visitor.visit(this, data);
   }

   public String toString()
   {
      return super.toString() + ": " + value + " type:" + type;
   }
}
