/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.jcr.ext.backup;

import junit.framework.TestCase;

import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.services.jcr.ext.backup.impl.JcrRestoreWiFilter;

import java.io.File;

/**
 * Created by The eXo Platform SAS.
 * 
 * <br>Date: 2011
 *
 * @author <a href="mailto:alex.reshetnyak@exoplatform.com.ua">Alex Reshetnyak</a> 
 * @version $Id: TestJcrREstoreWiFilter.java 111 2011-11-11 11:11:11Z rainf0x $
 */
public class TestJcrRestoreWiFilter
   extends TestCase
{

   public void testListFiles() throws Exception
   {
      File tempDir = new File(PrivilegedSystemHelper.getProperty("java.io.tmpdir") + File.separator + Math.random());
      PrivilegedFileHelper.mkdirs(tempDir);
      PrivilegedFileHelper.deleteOnExit(tempDir);

      for (int i = 0; i < 7; i++)
      {
         File f = PrivilegedFileHelper.createTempFile("jcrrestorewi", ".tmp", tempDir);
         PrivilegedFileHelper.deleteOnExit(f);
      }

      File[] files = PrivilegedFileHelper.listFiles(tempDir, new JcrRestoreWiFilter());

      assertEquals(7, files.length);
   }
}
