/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;

import org.apache.lucene.search.Sort;

/**
 * <code>MultiColumnQuery</code> defines an interface for a query that returns
 * {@link MultiColumnQueryHits}.
 */
public interface MultiColumnQuery {

    /**
     * Executes this query and returns multi column query hits.
     *
     * @param searcher        the index searcher.
     * @param sort            the sort criteria.
     * @param resultFetchHint the result fetch hint.
     * @return the query hits.
     * @throws IOException if an error occurs while executing the query.
     */
    public MultiColumnQueryHits execute(JcrIndexSearcher searcher,
                                        Sort sort,
                                        long resultFetchHint)
            throws IOException;
}
