/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.io.Writer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.action.EditDocumentActionComponent;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentFormController;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UISelectDocumentForm;
import org.exoplatform.ecm.webui.form.DialogFormActionListeners;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;

@ComponentConfigs(value={@ComponentConfig(type=UIFormMultiValueInputSet.class, id="WYSIWYGRichTextMultipleInputset", events={@EventConfig(listeners={UIDialogForm.AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormMultiValueInputSet.RemoveActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SaveAndCloseActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE), @EventConfig(listeners={DialogFormActionListeners.RemoveDataActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DialogFormActionListeners.ChangeTabActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIDocumentForm
extends UIDialogForm
implements UIPopupComponent,
UISelectable {
    public static final String FIELD_TAXONOMY = "categories";
    public static final String POPUP_TAXONOMY = "PopupComponent";
    private List<String> listTaxonomyName = new ArrayList<String>();
    private boolean canChangeType = true;
    private static final Log LOG = ExoLogger.getLogger((String)UIDocumentForm.class.getName());

    public boolean isCanChangeType() {
        return this.canChangeType;
    }

    public void setCanChangeType(boolean canChangeType) {
        this.canChangeType = canChangeType;
    }

    public UIDocumentForm() throws Exception {
        this.setActions(new String[]{"Save", "SaveAndClose", "Close"});
    }

    private String getChangeTypeActionLink() throws Exception {
        if (!this.isAddNew || !this.canChangeType) {
            return "";
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String action = "ChangeType";
        String strChangeTypeLabel = res.getString(this.getName() + ".action." + action);
        StringBuilder link = new StringBuilder();
        link.append("<a onclick=\"").append(this.event(action)).append("\" class=\"ChangeTypeLink\">(").append(strChangeTypeLabel).append(")</a>");
        return link.toString();
    }

    public List<String> getlistTaxonomyName() {
        return this.listTaxonomyName;
    }

    public void setListTaxonomyName(List<String> listTaxonomyNameNew) {
        this.listTaxonomyName = listTaxonomyNameNew;
    }

    public void releaseLock() throws Exception {
        if (this.isEditing()) {
            super.releaseLock();
        }
    }

    public String getDMSWorkspace() throws Exception {
        DMSConfiguration dmsConfig = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        return dmsConfig.getConfig().getSystemWorkspace();
    }

    public Node getRootPathTaxonomy(Node node) throws Exception {
        try {
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            List allTaxonomyTrees = taxonomyService.getAllTaxonomyTrees();
            for (Node taxonomyTree : allTaxonomyTrees) {
                if (!node.getPath().startsWith(taxonomyTree.getPath())) continue;
                return taxonomyTree;
            }
            return null;
        }
        catch (AccessDeniedException accessDeniedException) {
            return null;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.contentType};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.isUpdateSelect = true;
        UIFormInput formInput = this.getUIInput(selectField);
        if (formInput instanceof UIFormInputBase) {
            ((UIFormInputBase)formInput).setValue((Object)value.toString());
        } else if (formInput instanceof UIFormMultiValueInputSet) {
            UIFormMultiValueInputSet inputSet = (UIFormMultiValueInputSet)formInput;
            String valueTaxonomy = String.valueOf(value).trim();
            List values = inputSet.getValue();
            if (!this.getListTaxonomy().contains(valueTaxonomy)) {
                this.getListTaxonomy().add(valueTaxonomy);
                values.add(this.getCategoryLabel(valueTaxonomy));
            }
            inputSet.setValue(values);
        }
        UIDocumentFormController uiContainer = (UIDocumentFormController)this.getParent();
        uiContainer.removeChildById(POPUP_TAXONOMY);
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            if (this.contentType != null && this.contentType.length() > 0 && userName != null & userName.length() > 0) {
                return templateService.getTemplatePathByUser(true, this.contentType, userName);
            }
            return null;
        }
        catch (AccessControlException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("AccessControlException: user [" + userName + "] does not have access to the template for content type [" + this.contentType + "] in repository + [" + this.repositoryName + "]"));
            }
            return null;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.contentType};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    private String getTemplateLabel() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getTemplateLabel(this.contentType);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().require("SHARED/uiDocumentForm", "uiDocumentForm").addScripts("uiDocumentForm.UIDocForm.UpdateGUI();").addScripts("uiDocumentForm.UIDocForm.AutoFocus();");
        context.getJavascriptManager().loadScriptResource("wcm-webui-ext");
        context.getJavascriptManager().addCustomizedOnLoadScript((CharSequence)"changeWarning();");
        super.processRender(context);
    }

    public void processRenderAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        Writer writer = context.getWriter();
        writer.append("<h5 class=\"title uiDialogAction clearfix\" >");
        writer.append("<div class=\"dialogAction pull-right\">");
        String[] listAction = this.getActions();
        String contextID = "UIDocumentForm_" + System.currentTimeMillis();
        int count = 0;
        for (String action : listAction) {
            String actionLabel;
            String btn = count++ == 0 ? "btn btn-primary" : "btn";
            try {
                actionLabel = res.getString(this.getName() + ".action." + action);
            }
            catch (MissingResourceException e) {
                actionLabel = action;
            }
            String link = this.event(action);
            writer.append("<button type=\"button\" ").append("onclick=\"").append(link).append("\" class=\"" + btn + "\">").append(actionLabel).append("</button>");
        }
        String fullscreen = res.getString(this.getName() + ".tooltip.FullScreen");
        writer.append("<a class=\"actionIcon\" onclick='eXo.webui.UIDocForm.FullScreenToggle(this); return false;'><i ").append(fullscreen).append("\" id=\"").append(contextID).append("\" class=\"uiIconEcmsExpand uiIconEcmsLightGrey\"></i></a>");
        writer.append("</div>");
        writer.append("<span class='uiDialogTitle'>" + this.getTemplateLabel() + " " + this.getChangeTypeActionLink() + "</span>");
        writer.append("</h5>");
        context.getJavascriptManager().loadScriptResource("uiDocumentForm");
        context.getJavascriptManager().addCustomizedOnLoadScript((CharSequence)("eXo.webui.UIDocForm.initFullScreenStatus(\"" + contextID + "\");"));
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public Node getCurrentNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public String getLastModifiedDate() throws Exception {
        return this.getLastModifiedDate(this.getCurrentNode());
    }

    public synchronized void renderField(String name) throws Exception {
        if (FIELD_TAXONOMY.equals(name) && !this.isAddNew && !this.isUpdateSelect) {
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            List listCategories = taxonomyService.getAllCategories(this.getNode());
            for (Node itemNode : listCategories) {
                Node taxonomyTree = this.getRootPathTaxonomy(itemNode);
                if (taxonomyTree == null) continue;
                String categoryPath = itemNode.getPath().replaceAll(taxonomyTree.getPath(), "");
                if (this.getListTaxonomy().contains(taxonomyTree.getName() + categoryPath)) continue;
                if (!this.listTaxonomyName.contains(this.getCategoryLabel(taxonomyTree.getName() + categoryPath))) {
                    this.listTaxonomyName.add(this.getCategoryLabel(taxonomyTree.getName() + categoryPath));
                }
                this.getListTaxonomy().add(taxonomyTree.getName() + categoryPath);
            }
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)this.getChildById(FIELD_TAXONOMY);
            if (uiSet != null) {
                uiSet.setValue(this.listTaxonomyName);
            }
        }
        super.renderField(name);
    }

    private synchronized List<String> getAddedListCategory(List<String> taxonomyList, List<String> existingList) {
        ArrayList<String> addedList = new ArrayList<String>();
        for (String addedCategory : taxonomyList) {
            if (existingList.contains(addedCategory)) continue;
            addedList.add(addedCategory);
        }
        return addedList;
    }

    private synchronized List<String> getRemovedListCategory(List<String> taxonomyList, List<String> existingList) {
        ArrayList<String> removedList = new ArrayList<String>();
        for (String existedCategory : existingList) {
            if (taxonomyList.contains(existedCategory)) continue;
            removedList.add(existedCategory);
        }
        return removedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node saveDocument(Event<UIDocumentForm> event) throws Exception {
        String nodeType;
        Node homeNode;
        UIFormMultiValueInputSet uiSet;
        UIDocumentForm documentForm = (UIDocumentForm)((Object)event.getSource());
        UIJCRExplorer uiExplorer = (UIJCRExplorer)documentForm.getAncestorOfType(UIJCRExplorer.class);
        List inputs = documentForm.getChildren();
        UIApplication uiApp = (UIApplication)documentForm.getAncestorOfType(UIApplication.class);
        boolean hasCategories = false;
        String categoriesPath = "";
        TaxonomyService taxonomyService = (TaxonomyService)documentForm.getApplicationComponent(TaxonomyService.class);
        if (documentForm.isAddNew()) {
            for (int i = 0; i < inputs.size(); ++i) {
                UIFormInput input = (UIFormInput)inputs.get(i);
                if (input.getName() == null || !input.getName().equals("name")) continue;
                String[] arrFilterChar = new String[]{"]", "["};
                String valueName = input.getValue().toString();
                if (Utils.isNameValid((String)valueName, (String[])arrFilterChar)) continue;
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.name-not-allowed", null, 1));
                return null;
            }
        }
        int index = 0;
        List listTaxonomy = documentForm.getListTaxonomy();
        if (documentForm.isReference && (uiSet = (UIFormMultiValueInputSet)documentForm.getChildById(FIELD_TAXONOMY)) != null && uiSet.getName() != null && uiSet.getName().equals(FIELD_TAXONOMY)) {
            hasCategories = true;
            listTaxonomy = uiSet.getValue();
            for (String category : listTaxonomy) {
                categoriesPath = categoriesPath.concat(category).concat(",");
            }
            if (listTaxonomy != null && listTaxonomy.size() > 0) {
                try {
                    for (String categoryPath : listTaxonomy) {
                        index = categoryPath.indexOf("/");
                        if (index < 0) {
                            taxonomyService.getTaxonomyTree(categoryPath);
                            continue;
                        }
                        taxonomyService.getTaxonomyTree(categoryPath.substring(0, index)).getNode(categoryPath.substring(index + 1));
                    }
                }
                catch (Exception e) {
                    uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                    return null;
                }
            }
        }
        Map inputProperties = DialogFormUtil.prepareMap((List)inputs, (Map)documentForm.getInputProperties(), (Map)documentForm.getInputOptions());
        Node newNode = null;
        Node currentNode = uiExplorer.getCurrentNode();
        if (documentForm.isAddNew()) {
            UIDocumentFormController uiDFController = (UIDocumentFormController)documentForm.getParent();
            homeNode = currentNode;
            nodeType = ((UIDocumentForm)uiDFController.getChild(UIDocumentForm.class)).getContentType();
            if (homeNode.isLocked()) {
                homeNode.getSession().addLockToken(LockUtil.getLockToken((Node)homeNode));
            }
        } else {
            String lockToken;
            Node documentNode = documentForm.getNode();
            for (String removedNode : documentForm.getRemovedNodes()) {
                documentNode.getNode(removedNode).remove();
            }
            homeNode = documentNode.getParent();
            nodeType = documentNode.getPrimaryNodeType().getName();
            if (documentNode.isLocked() && (lockToken = LockUtil.getLockToken((Node)documentNode)) != null && !lockToken.isEmpty()) {
                documentNode.getSession().addLockToken(lockToken);
            }
        }
        try {
            CmsService cmsService = (CmsService)documentForm.getApplicationComponent(CmsService.class);
            cmsService.getPreProperties().clear();
            String addedPath = cmsService.storeNode(nodeType, homeNode, inputProperties, documentForm.isAddNew());
            try {
                newNode = (Node)homeNode.getSession().getItem(addedPath);
                if (newNode.isLocked()) {
                    newNode.getSession().addLockToken(LockUtil.getLockToken((Node)newNode));
                }
                List listTaxonomyTrees = taxonomyService.getAllTaxonomyTrees();
                List listExistedTaxonomy = taxonomyService.getAllCategories(newNode);
                ArrayList<String> listExistingTaxonomy = new ArrayList<String>();
                block32: for (Node existedTaxonomy : listExistedTaxonomy) {
                    for (Node taxonomyTrees : listTaxonomyTrees) {
                        if (!existedTaxonomy.getPath().contains(taxonomyTrees.getPath())) continue;
                        listExistingTaxonomy.add(taxonomyTrees.getName() + existedTaxonomy.getPath().substring(taxonomyTrees.getPath().length()));
                        continue block32;
                    }
                }
                if (hasCategories && !homeNode.isNodeType("exo:taxonomy")) {
                    for (String removedCate : documentForm.getRemovedListCategory(listTaxonomy, listExistingTaxonomy)) {
                        index = removedCate.indexOf("/");
                        if (index != -1) {
                            taxonomyService.removeCategory(newNode, removedCate.substring(0, index), removedCate.substring(index + 1));
                            continue;
                        }
                        taxonomyService.removeCategory(newNode, removedCate, "");
                    }
                }
                if (hasCategories && newNode != null && listTaxonomy != null && listTaxonomy.size() > 0) {
                    documentForm.releaseLock();
                    for (String categoryPath : documentForm.getAddedListCategory(listTaxonomy, listExistingTaxonomy)) {
                        index = categoryPath.indexOf("/");
                        try {
                            if (index != -1) {
                                taxonomyService.addCategory(newNode, categoryPath.substring(0, index), categoryPath.substring(index + 1));
                                continue;
                            }
                            taxonomyService.addCategory(newNode, categoryPath, "");
                        }
                        catch (AccessDeniedException accessDeniedException) {
                            uiApp.addMessage(new ApplicationMessage("AccessControlException.msg", null, 1));
                        }
                        catch (Exception e) {}
                    }
                } else {
                    ArrayList vals = new ArrayList();
                    if (newNode.hasProperty("exo:category")) {
                        newNode.setProperty("exo:category", vals.toArray(new Value[vals.size()]));
                    }
                    newNode.save();
                }
                uiExplorer.setCurrentPath(newNode.getPath());
                uiExplorer.setWorkspaceName(newNode.getSession().getWorkspace().getName());
                uiExplorer.refreshExplorer(newNode, true);
                uiExplorer.updateAjax(event);
                Node node = newNode;
                return node;
            }
            catch (Exception e) {
                Node node;
                String key;
                try {
                    uiExplorer.getSession().refresh(false);
                    uiExplorer.updateAjax(event);
                    uiExplorer.getSession().save();
                    uiExplorer.updateAjax(event);
                }
                catch (AccessControlException ace) {
                    throw new AccessDeniedException(ace.getMessage());
                }
                catch (VersionException ve) {
                    uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.in-versioning", null, 1));
                    addedPath = null;
                    return addedPath;
                }
                catch (ItemNotFoundException item) {
                    uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.item-not-found", null, 1));
                    addedPath = null;
                    return addedPath;
                }
                catch (AccessDeniedException accessDeniedException) {
                    uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.repository-exception-permission", null, 1));
                    addedPath = null;
                    return addedPath;
                }
                catch (ItemExistsException existedex) {
                    uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-allowed-same-name-sibling", null, 1));
                    addedPath = null;
                    return addedPath;
                }
                catch (ConstraintViolationException constraintViolationException) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"Unexpected error occurrs", (Throwable)constraintViolationException);
                    }
                    uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.constraintviolation-exception", null, 1));
                    addedPath = null;
                    return addedPath;
                }
                catch (RepositoryException repo) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"Unexpected error occurrs", (Throwable)repo);
                    }
                    uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.repository-exception", null, 1));
                    addedPath = null;
                    return addedPath;
                }
                catch (NumberFormatException nume) {
                    key = "UIDocumentForm.msg.numberformat-exception";
                    uiApp.addMessage(new ApplicationMessage(key, null, 1));
                    node = null;
                    return node;
                }
                catch (Exception e2) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"Unexpected error occurs", (Throwable)e2);
                    }
                    key = "UIDocumentForm.msg.cannot-save";
                    uiApp.addMessage(new ApplicationMessage(key, null, 1));
                    node = null;
                    return node;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                documentForm.releaseLock();
            }
        }
        finally {
            documentForm.releaseLock();
        }
        return null;
    }

    public static void closeForm(Event<UIDocumentForm> event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIDocumentForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
        if (uiExplorer != null) {
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            ((UIDocumentForm)((Object)event.getSource())).releaseLock();
            if (uiDocumentWorkspace.getChild(UIDocumentFormController.class) != null) {
                uiDocumentWorkspace.removeChild(UIDocumentFormController.class);
            } else {
                uiExplorer.cancelAction();
            }
            uiExplorer.updateAjax(event);
        }
    }

    public static class RemoveActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm uiDocumentForm;
            block4: {
                uiDocumentForm = (UIDocumentForm)((Object)event.getSource());
                String objectid = event.getRequestContext().getRequestParameter("objectId");
                String idx = objectid.replaceAll(UIDocumentForm.FIELD_TAXONOMY, "");
                try {
                    int idxInput = Integer.parseInt(idx);
                    uiDocumentForm.getListTaxonomy().remove(idxInput);
                    uiDocumentForm.getlistTaxonomyName().remove(idxInput);
                    uiDocumentForm.setIsUpdateSelect(true);
                }
                catch (NumberFormatException ne) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)ne.getMessage());
                    }
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)e.getMessage());
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentForm);
        }
    }

    public static class AddActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm uiDocumentForm = (UIDocumentForm)((Object)event.getSource());
            UIDocumentFormController uiFormController = (UIDocumentFormController)uiDocumentForm.getParent();
            String clickedField = event.getRequestContext().getRequestParameter("objectId");
            if (uiDocumentForm.isReference) {
                uiDocumentForm.setIsUpdateSelect(true);
                UIApplication uiApp = (UIApplication)uiDocumentForm.getAncestorOfType(UIApplication.class);
                try {
                    UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)uiDocumentForm.getChildById(UIDocumentForm.FIELD_TAXONOMY);
                    if (uiSet != null && uiSet.getName() != null && uiSet.getName().equals(UIDocumentForm.FIELD_TAXONOMY) && clickedField != null && clickedField.equals(UIDocumentForm.FIELD_TAXONOMY)) {
                        UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentForm.getAncestorOfType(UIJCRExplorer.class);
                        String repository = uiExplorer.getRepositoryName();
                        if (uiSet.getValue().size() == 0) {
                            uiSet.setValue(new ArrayList());
                        }
                        UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)uiFormController.createUIComponent(UIOneTaxonomySelector.class, null, null);
                        TaxonomyService taxonomyService = (TaxonomyService)uiDocumentForm.getApplicationComponent(TaxonomyService.class);
                        List lstTaxonomyTree = taxonomyService.getAllTaxonomyTrees();
                        if (lstTaxonomyTree.size() == 0) {
                            throw new AccessDeniedException();
                        }
                        String workspaceName = ((Node)lstTaxonomyTree.get(0)).getSession().getWorkspace().getName();
                        uiOneTaxonomySelector.setIsDisable(workspaceName, false);
                        uiOneTaxonomySelector.setRootNodeLocation(repository, workspaceName, ((Node)lstTaxonomyTree.get(0)).getPath());
                        uiOneTaxonomySelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
                        uiOneTaxonomySelector.init(uiExplorer.getSystemProvider());
                        String param = "returnField=categories";
                        uiOneTaxonomySelector.setSourceComponent((UIComponent)uiDocumentForm, new String[]{param});
                        UIPopupWindow uiPopupWindow = (UIPopupWindow)uiFormController.getChildById(UIDocumentForm.POPUP_TAXONOMY);
                        if (uiPopupWindow == null) {
                            uiPopupWindow = (UIPopupWindow)uiFormController.addChild(UIPopupWindow.class, null, UIDocumentForm.POPUP_TAXONOMY);
                        }
                        uiPopupWindow.setWindowSize(700, 450);
                        uiPopupWindow.setUIComponent((UIComponent)uiOneTaxonomySelector);
                        uiPopupWindow.setRendered(true);
                        uiPopupWindow.setShow(true);
                    }
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiFormController);
                }
                catch (AccessDeniedException accessDeniedException) {
                    uiApp.addMessage(new ApplicationMessage("Taxonomy.msg.AccessDeniedException", null, 1));
                    return;
                }
                catch (Exception e) {
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                    return;
                }
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiDocumentForm.getParent());
            }
        }
    }

    public static class SaveAndCloseActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            Node newNode = UIDocumentForm.saveDocument(event);
            if (newNode != null) {
                event.getRequestContext().setAttribute("nodePath", (Object)newNode.getPath());
            }
            UIDocumentForm.closeForm(event);
        }
    }

    public static class ChangeTypeActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm uiDocumentForm = (UIDocumentForm)((Object)event.getSource());
            UIDocumentFormController uiDCFormController = (UIDocumentFormController)uiDocumentForm.getParent();
            UISelectDocumentForm uiSelectForm = (UISelectDocumentForm)uiDCFormController.getChild(UISelectDocumentForm.class);
            uiSelectForm.setRendered(true);
            uiDocumentForm.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDCFormController);
        }
    }

    public static class CloseActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm.closeForm(event);
        }
    }

    public static class RemoveReferenceActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm uiForm = (UIDocumentForm)((Object)event.getSource());
            uiForm.isRemovePreference = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            uiForm.getUIStringInput(fieldName).setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class ShowComponentActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            String[] stringArray;
            UIDocumentForm uiForm = (UIDocumentForm)((Object)event.getSource());
            UIDocumentFormController uiContainer = (UIDocumentFormController)uiForm.getParent();
            uiForm.isShowingComponent = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            Map fieldPropertiesMap = (Map)uiForm.componentSelectors.get(fieldName);
            String classPath = (String)fieldPropertiesMap.get("selectorClass");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(classPath, true, cl);
            String rootPath = (String)fieldPropertiesMap.get("rootPath");
            UIComponent uiComp = uiContainer.createUIComponent(clazz, null, null);
            String selectorParams = (String)fieldPropertiesMap.get("selectorParams");
            UIJCRExplorer explorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            if (uiComp instanceof UIOneNodePathSelector) {
                String[] arrParams;
                String repositoryName = explorer.getRepositoryName();
                SessionProvider provider = explorer.getSessionProvider();
                String wsFieldName = (String)fieldPropertiesMap.get("workspaceField");
                String wsName = "";
                if (wsFieldName != null && wsFieldName.length() > 0) {
                    if (uiForm.getUIInput(wsFieldName) != null) {
                        wsName = (String)((UIFormInputBase)uiForm.getUIInput(wsFieldName)).getValue();
                        ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                    } else {
                        wsName = explorer.getCurrentWorkspace();
                        ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, false);
                    }
                }
                if (selectorParams != null && (arrParams = selectorParams.split(",")).length == 4) {
                    ((UIOneNodePathSelector)uiComp).setAcceptedNodeTypesInPathPanel(new String[]{"nt:file", "nt:folder", "nt:unstructured", "exo:taxonomy"});
                    wsName = arrParams[1];
                    rootPath = arrParams[2];
                    ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                    if (arrParams[3].indexOf(";") > -1) {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(arrParams[3].split(";"));
                    } else {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(new String[]{arrParams[3]});
                    }
                }
                if (rootPath == null) {
                    rootPath = "/";
                }
                ((UIOneNodePathSelector)uiComp).setRootNodeLocation(repositoryName, wsName, rootPath);
                ((UIOneNodePathSelector)uiComp).setShowRootPathSelect(true);
                ((UIOneNodePathSelector)uiComp).init(provider);
            } else if (uiComp instanceof UIOneTaxonomySelector) {
                NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
                String workspaceName = uiForm.getDMSWorkspace();
                ((UIOneTaxonomySelector)uiComp).setIsDisable(workspaceName, false);
                String rootTreePath = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
                Session session = explorer.getSessionByWorkspace(workspaceName);
                Node rootTree = (Node)session.getItem(rootTreePath);
                NodeIterator childrenIterator = rootTree.getNodes();
                if (childrenIterator.hasNext()) {
                    Node childNode = childrenIterator.nextNode();
                    rootTreePath = childNode.getPath();
                }
                ((UIOneTaxonomySelector)uiComp).setRootNodeLocation(uiForm.repositoryName, workspaceName, rootTreePath);
                ((UIOneTaxonomySelector)uiComp).init(WCMCoreUtils.getSystemSessionProvider());
            }
            uiContainer.initPopup(uiComp);
            String param = "returnField=" + fieldName;
            if (selectorParams == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = param;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = param;
                stringArray = stringArray3;
                stringArray3[1] = "selectorParams=" + selectorParams;
            }
            String[] params = stringArray;
            ((ComponentSelector)uiComp).setSourceComponent((UIComponent)uiForm, params);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class SaveActionListener
    extends EventListener<UIDocumentForm> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm documentForm;
            UIDocumentForm uIDocumentForm = documentForm = (UIDocumentForm)((Object)event.getSource());
            synchronized (uIDocumentForm) {
                UIJCRExplorer uiExplorer = (UIJCRExplorer)documentForm.getAncestorOfType(UIJCRExplorer.class);
                UIApplication uiApp = (UIApplication)documentForm.getAncestorOfType(UIApplication.class);
                Node newNode = UIDocumentForm.saveDocument(event);
                if (newNode != null) {
                    event.getRequestContext().setAttribute("nodePath", (Object)newNode.getPath());
                    UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
                    UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
                    uiDocumentWorkspace.removeChild(UIDocumentFormController.class);
                    documentForm.setIsUpdateSelect(false);
                    EditDocumentActionComponent.editDocument(event, null, (UIComponent)uiExplorer, uiExplorer, uiExplorer.getCurrentNode(), uiApp);
                }
            }
        }
    }
}

