/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeList;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionTaxonomyManager;
import org.exoplatform.ecm.webui.selector.UIPermissionSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.ext.manager.UIAbstractManager;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UITaxonomyManagerTrees
extends UIAbstractManager {
    public UITaxonomyManagerTrees() throws Exception {
        this.addChild(UITaxonomyTreeList.class, null, null);
    }

    public void initPopupTreeContainer(String id) throws Exception {
        UITaxonomyTreeContainer uiTaxonomyTreeContainer;
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById(id);
        if (uiPopup == null) {
            uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, id);
            uiPopup.setWindowSize(650, 170);
            uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)this.createUIComponent(UITaxonomyTreeContainer.class, null, null);
        } else {
            uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)uiPopup.findFirstComponentOfType(UITaxonomyTreeContainer.class);
            uiPopup.setRendered(true);
        }
        uiPopup.setUIComponent((UIComponent)uiTaxonomyTreeContainer);
        uiPopup.setShow(true);
        uiPopup.setShowMask(true);
        uiPopup.setResizable(true);
    }

    public void refresh() throws Exception {
        this.update();
    }

    public void update() throws Exception {
        UITaxonomyTreeList uiTaxonomyTreeList = (UITaxonomyTreeList)this.getChild(UITaxonomyTreeList.class);
        uiTaxonomyTreeList.refresh(uiTaxonomyTreeList.getUIPageIterator().getCurrentPage());
    }

    public void initPopupPermission(String membership) throws Exception {
        this.removePopup();
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupTaxonomyTreePermission");
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(560, 300);
        UIPermissionSelector uiTaxonomyTreePermission = (UIPermissionSelector)this.createUIComponent(UIPermissionSelector.class, null, null);
        uiTaxonomyTreePermission.setSelectedMembership(true);
        if (membership != null && membership.indexOf(":/") > -1) {
            String[] arrMember = membership.split(":/");
            uiTaxonomyTreePermission.setCurrentPermission("/" + arrMember[1]);
        }
        uiPopup.setUIComponent((UIComponent)uiTaxonomyTreePermission);
        uiPopup.setShow(true);
    }

    public String getSystemWorkspaceName() throws RepositoryException {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        return manageableRepository.getConfiguration().getSystemWorkspaceName();
    }

    public String getDmsSystemWorkspaceName() {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        DMSRepositoryConfiguration dmsRepoConfig = dmsConfiguration.getConfig();
        return dmsRepoConfig.getSystemWorkspace();
    }

    public void initPopupJCRBrowser(String workspace, boolean isDisable) throws Exception {
        this.removePopup();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupTaxonomyJCRBrowser");
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(610, 300);
        String[] filterType = new String[]{"nt:folder", "nt:unstructured"};
        UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)this.createUIComponent(UIOneNodePathSelector.class, null, null);
        uiOneNodePathSelector.setIsDisable(workspace, isDisable);
        uiOneNodePathSelector.setShowRootPathSelect(true);
        uiOneNodePathSelector.setAcceptedNodeTypesInTree(filterType);
        uiOneNodePathSelector.setAcceptedNodeTypesInPathPanel(filterType);
        uiOneNodePathSelector.setRootNodeLocation(repository, workspace, "/");
        if (WCMCoreUtils.isAnonim()) {
            uiOneNodePathSelector.init(WCMCoreUtils.createAnonimProvider());
        } else if (workspace.equals(this.getSystemWorkspaceName())) {
            uiOneNodePathSelector.init(WCMCoreUtils.getSystemSessionProvider());
        } else {
            uiOneNodePathSelector.init(WCMCoreUtils.getUserSessionProvider());
        }
        uiPopup.setUIComponent((UIComponent)uiOneNodePathSelector);
        UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)this.findFirstComponentOfType(UITaxonomyTreeContainer.class);
        uiOneNodePathSelector.setSourceComponent((UIComponent)uiTaxonomyTreeContainer, new String[]{"TaxoTreeHomePath"});
        uiPopup.setShow(true);
    }

    public void initPopupComponent(UIComponent uiComp, String id) throws Exception {
        this.removePopup();
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, id);
        uiPopup.setShowMask(true);
        uiPopup.setUIComponent(uiComp);
        uiPopup.setWindowSize(640, 300);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    private void removePopup() {
        UIActionTaxonomyManager uiManager = (UIActionTaxonomyManager)this.getAncestorOfType(UIActionTaxonomyManager.class);
        if (uiManager != null) {
            uiManager.removeChildById("PopupComponent");
        }
        this.removeChildById("PopupComponent");
        this.removeChildById("PopupTaxonomyTreePermission");
        this.removeChildById("PopupTaxonomyJCRBrowser");
    }
}

