/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.List;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.SourceStorage;
import org.exoplatform.application.gadget.impl.GadgetDefinition;
import org.exoplatform.application.gadget.impl.GadgetRegistryServiceImpl;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.upgrade.plugins.GadgetUpgrade;
import org.exoplatform.platform.upgrade.plugins.LocalGadgetImporter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeLocalGadgetsPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeLocalGadgetsPlugin.class);
    private List<GadgetUpgrade> gadgets;
    protected RepositoryService repositoryService;
    protected ConfigurationManager configurationManager;
    protected SourceStorage sourceStorage;
    protected GadgetRegistryServiceImpl gadgetRegistryService;

    public UpgradeLocalGadgetsPlugin(ConfigurationManager configurationManager, RepositoryService repositoryService, SourceStorage sourceStorage, GadgetRegistryService gadgetRegistryService, InitParams initParams) {
        super(initParams);
        this.gadgets = initParams.getObjectParamValues(GadgetUpgrade.class);
        this.repositoryService = repositoryService;
        this.configurationManager = configurationManager;
        this.sourceStorage = sourceStorage;
        this.gadgetRegistryService = (GadgetRegistryServiceImpl)gadgetRegistryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)("processing upgrading gadgets from version " + oldVersion + " to " + newVersion));
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            for (GadgetUpgrade gadgetUpgrade : this.gadgets) {
                try {
                    Gadget gadget;
                    block14: {
                        gadget = this.gadgetRegistryService.getGadget(gadgetUpgrade.getName());
                        if (gadget == null) {
                            LOG.warn((Object)("Can't find gadget '" + gadgetUpgrade.getName() + "'."));
                            continue;
                        }
                        LOG.info((Object)("Replacing gadget " + gadgetUpgrade.getName() + " with new content ..."));
                        try {
                            this.gadgetRegistryService.removeGadget(gadgetUpgrade.getName());
                        }
                        catch (Exception noSuchGadgetException) {
                            if (!LOG.isDebugEnabled()) break block14;
                            LOG.debug((Object)("gadget doesn't exist in the store: " + gadget.getName()));
                        }
                    }
                    try {
                        LocalGadgetImporter gadgetImporter = new LocalGadgetImporter(gadgetUpgrade.getName(), (GadgetRegistryService)this.gadgetRegistryService, gadgetUpgrade.getPath(), this.configurationManager, PortalContainer.getInstance());
                        GadgetDefinition def = this.gadgetRegistryService.getRegistry().addGadget(gadget.getName());
                        gadgetImporter.doImport(def);
                        gadget = this.gadgetRegistryService.getGadget(gadgetUpgrade.getName());
                        if (gadget != null) {
                            LOG.info((Object)("gadget " + gadgetUpgrade.getName() + " upgraded successfully."));
                            continue;
                        }
                        LOG.info((Object)("Gadget " + gadgetUpgrade.getName() + " wasn't imported. It will be imported automatically with GadgetDeployer Service."));
                    }
                    catch (Exception exception) {
                        LOG.info((Object)("Gadget " + gadgetUpgrade.getName() + " wasn't imported. It will be imported automatically with GadgetDeployer Service."));
                    }
                }
                catch (Exception exception) {
                    LOG.error((Object)("Error while proceeding '" + gadgetUpgrade.getName() + "' gadget upgrade."), (Throwable)exception);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not upgrade local gadget", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

