/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobInputStream;

public class BinaryData
implements BlobData {
    public static final BinaryData singleBitZero = new BinaryData(new byte[]{0}, 1L);
    public static final BinaryData singleBitOne = new BinaryData(new byte[]{-128}, 1L);
    public static final BinaryData zeroLengthBinary = new BinaryData(new byte[0], false);
    long id;
    protected byte[] data;
    private boolean isBits;
    private long bitLength;

    public static BinaryData getBitData(byte[] byArray, long l) {
        if (l == 1L) {
            return byArray[0] == 0 ? singleBitZero : singleBitOne;
        }
        return new BinaryData(byArray, l);
    }

    public BinaryData(byte[] byArray, boolean bl) {
        if (bl) {
            byArray = (byte[])ArrayUtil.duplicateArray(byArray);
        }
        this.data = byArray;
        this.bitLength = byArray.length * 8;
    }

    public BinaryData(SessionInterface sessionInterface, BlobData blobData, BlobData blobData2) {
        long l = blobData.length(sessionInterface) + blobData2.length(sessionInterface);
        if (l > Integer.MAX_VALUE) {
            throw Error.error(3401);
        }
        this.data = new byte[(int)l];
        System.arraycopy(blobData.getBytes(), 0, this.data, 0, (int)blobData.length(sessionInterface));
        System.arraycopy(blobData2.getBytes(), 0, this.data, (int)blobData.length(sessionInterface), (int)blobData2.length(sessionInterface));
        this.bitLength = (blobData.length(sessionInterface) + blobData2.length(sessionInterface)) * 8L;
    }

    public BinaryData(byte[] byArray, long l) {
        this.data = byArray;
        this.bitLength = l;
        this.isBits = true;
    }

    public BinaryData(long l, DataInput dataInput) {
        this.data = new byte[(int)l];
        this.bitLength = this.data.length * 8;
        try {
            dataInput.readFully(this.data);
        }
        catch (IOException iOException) {
            throw Error.error(467, iOException);
        }
    }

    @Override
    public byte[] getBytes() {
        return this.data;
    }

    @Override
    public long length(SessionInterface sessionInterface) {
        return this.data.length;
    }

    @Override
    public long bitLength(SessionInterface sessionInterface) {
        return this.bitLength;
    }

    @Override
    public boolean isBits() {
        return this.isBits;
    }

    @Override
    public byte[] getBytes(SessionInterface sessionInterface, long l, int n) {
        if (!BinaryData.isInLimits(this.data.length, l, n)) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, (int)l, byArray, 0, n);
        return byArray;
    }

    @Override
    public BlobData getBlob(SessionInterface sessionInterface, long l, long l2) {
        throw Error.runtimeError(201, "BinaryData");
    }

    @Override
    public InputStream getBinaryStream(SessionInterface sessionInterface) {
        return new BlobInputStream(sessionInterface, this, 0L, this.length(sessionInterface));
    }

    @Override
    public InputStream getBinaryStream(SessionInterface sessionInterface, long l, long l2) {
        if (!BinaryData.isInLimits(this.data.length, l, l2)) {
            throw new IndexOutOfBoundsException();
        }
        return new BlobInputStream(sessionInterface, this, l, this.length(sessionInterface));
    }

    @Override
    public int setBytes(SessionInterface sessionInterface, long l, byte[] byArray, int n, int n2) {
        if (!BinaryData.isInLimits(this.data.length, l, 0L)) {
            throw new IndexOutOfBoundsException();
        }
        if (!BinaryData.isInLimits(this.data.length, l, n2)) {
            this.data = (byte[])ArrayUtil.resizeArray(this.data, (int)l + n2);
        }
        System.arraycopy(byArray, n, this.data, (int)l, n2);
        this.bitLength = this.data.length * 8;
        return n2;
    }

    @Override
    public int setBytes(SessionInterface sessionInterface, long l, byte[] byArray) {
        this.setBytes(sessionInterface, l, byArray, 0, byArray.length);
        return byArray.length;
    }

    @Override
    public long setBinaryStream(SessionInterface sessionInterface, long l, InputStream inputStream) {
        return 0L;
    }

    @Override
    public OutputStream setBinaryStream(SessionInterface sessionInterface, long l) {
        return null;
    }

    @Override
    public void truncate(SessionInterface sessionInterface, long l) {
        if ((long)this.data.length > l) {
            this.data = (byte[])ArrayUtil.resizeArray(this.data, (int)l);
            this.bitLength = this.data.length * 8;
        }
    }

    @Override
    public BlobData duplicate(SessionInterface sessionInterface) {
        return new BinaryData(this.data, true);
    }

    @Override
    public long position(SessionInterface sessionInterface, byte[] byArray, long l) {
        if (byArray.length > this.data.length) {
            return -1L;
        }
        if (l >= (long)this.data.length) {
            return -1L;
        }
        return ArrayUtil.find(this.data, (int)l, this.data.length, byArray);
    }

    @Override
    public long position(SessionInterface sessionInterface, BlobData blobData, long l) {
        if (blobData.length(sessionInterface) > (long)this.data.length) {
            return -1L;
        }
        byte[] byArray = blobData.getBytes();
        return this.position(sessionInterface, byArray, l);
    }

    @Override
    public long nonZeroLength(SessionInterface sessionInterface) {
        return this.data.length;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    @Override
    public int getStreamBlockSize() {
        return 524288;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void free() {
    }

    @Override
    public void setSession(SessionInterface sessionInterface) {
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l2 >= 0L && l3 >= 0L && l2 + l3 <= l;
    }

    @Override
    public boolean isBinary() {
        return true;
    }
}

