/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.io.IOException;
import java.util.Arrays;

public class VisualSampleEntry
extends SampleEntry
implements ContainerBox {
    public static final String TYPE1 = "mp4v";
    public static final String TYPE2 = "s263";
    public static final String TYPE3 = "avc1";
    public static final String TYPE4 = "ovc1";
    public static final String TYPE_ENCRYPTED = "encv";
    private int width;
    private int height;
    private double horizresolution;
    private double vertresolution;
    private int frameCount;
    private String compressorname;
    private int depth;
    private long[] predefined = new long[3];
    private byte[] vc1Content;

    public VisualSampleEntry(byte[] type) {
        super(type);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getHorizresolution() {
        return this.horizresolution;
    }

    public double getVertresolution() {
        return this.vertresolution;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public String getCompressorname() {
        return this.compressorname;
    }

    public int getDepth() {
        return this.depth;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        if (TYPE4.equals(IsoFile.bytesToFourCC(this.type))) {
            byte[] vc1 = new byte[(int)size - 8];
            in.read(vc1);
            this.vc1Content = vc1;
        } else {
            long tmp = in.readUInt16();
            assert (0L == tmp) : "reserved byte not 0";
            tmp = in.readUInt16();
            assert (0L == tmp) : "reserved byte not 0";
            this.predefined[0] = in.readUInt32();
            this.predefined[1] = in.readUInt32();
            this.predefined[2] = in.readUInt32();
            this.width = in.readUInt16();
            this.height = in.readUInt16();
            this.horizresolution = in.readFixedPoint1616();
            this.vertresolution = in.readFixedPoint1616();
            tmp = in.readUInt32();
            assert (0L == tmp) : "reserved byte not 0";
            this.frameCount = in.readUInt16();
            int compressornameDisplayAbleData = in.readUInt8();
            if (compressornameDisplayAbleData > 31) {
                System.out.println("invalid compressor name displayable data: " + compressornameDisplayAbleData);
                compressornameDisplayAbleData = 31;
            }
            byte[] bytes = in.read(compressornameDisplayAbleData);
            this.compressorname = new String(bytes, "UTF-8");
            if (compressornameDisplayAbleData < 31) {
                byte[] zeros = in.read(31 - compressornameDisplayAbleData);
                assert (Arrays.equals(zeros, new byte[zeros.length])) : "The compressor name length was not filled up with zeros";
            }
            this.depth = in.readUInt16();
            tmp = in.readUInt16();
            assert (65535L == tmp);
            size -= 78L;
            while (size > 8L) {
                Box b = boxParser.parseBox(in, this, lastMovieFragmentBox);
                this.boxes.add(b);
                size -= b.getSize();
            }
        }
    }

    protected long getContentSize() {
        if (TYPE4.equals(IsoFile.bytesToFourCC(this.type))) {
            return this.vc1Content.length + 8;
        }
        long contentSize = 78L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        if (TYPE4.equals(IsoFile.bytesToFourCC(this.type))) {
            isos.write(new byte[6]);
            isos.writeUInt16(this.getDataReferenceIndex());
            isos.write(this.vc1Content);
        } else {
            isos.write(new byte[6]);
            isos.writeUInt16(this.getDataReferenceIndex());
            isos.writeUInt16(0);
            isos.writeUInt16(0);
            isos.writeUInt32(this.predefined[0]);
            isos.writeUInt32(this.predefined[1]);
            isos.writeUInt32(this.predefined[2]);
            isos.writeUInt16(this.getWidth());
            isos.writeUInt16(this.getHeight());
            isos.writeFixedPont1616(this.getHorizresolution());
            isos.writeFixedPont1616(this.getVertresolution());
            isos.writeUInt32(0L);
            isos.writeUInt16(this.getFrameCount());
            isos.writeUInt8(VisualSampleEntry.utf8StringLengthInBytes(this.getCompressorname()));
            isos.writeStringNoTerm(this.getCompressorname());
            for (int a = VisualSampleEntry.utf8StringLengthInBytes(this.getCompressorname()); a < 31; ++a) {
                isos.write(0);
            }
            isos.writeUInt16(this.getDepth());
            isos.writeUInt16(65535);
            for (Box boxe : this.boxes) {
                boxe.getBox(isos);
            }
        }
    }
}

