/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring;

import com.googlecode.mp4parser.authoring.MovieMetaData;
import com.googlecode.mp4parser.authoring.Track;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Movie {
    List<Track> tracks = new LinkedList<Track>();
    MovieMetaData movieMetaData = new MovieMetaData();

    public List<Track> getTracks() {
        return this.tracks;
    }

    public void setTracks(List<Track> tracks) {
        this.tracks = tracks;
    }

    public void addTrack(Track nuTrack) {
        if (this.getTrackByTrackId(nuTrack.getTrackMetaData().getTrackId()) != null) {
            nuTrack.getTrackMetaData().setTrackId(this.getNextTrackId());
        }
        this.tracks.add(nuTrack);
    }

    public MovieMetaData getMovieMetaData() {
        return this.movieMetaData;
    }

    public void setMovieMetaData(MovieMetaData movieMetaData) {
        this.movieMetaData = movieMetaData;
    }

    public String toString() {
        String s = "Movie{ ";
        for (Track track : this.tracks) {
            s = s + "track_" + track.getTrackMetaData().getTrackId() + " (" + (Object)((Object)track.getType()) + "), ";
        }
        s = s + ", movieMetaData=" + this.movieMetaData + '}';
        return s;
    }

    public long getNextTrackId() {
        long nextTrackId = 0L;
        for (Track track : this.tracks) {
            nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        return ++nextTrackId;
    }

    public Track getTrackByTrackId(long trackId) {
        for (Track track : this.tracks) {
            if (track.getTrackMetaData().getTrackId() != trackId) continue;
            return track;
        }
        return null;
    }
}

