/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.query;

import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.query.QueryResult;
import org.chromattic.core.DomainSession;
import org.chromattic.core.jcr.SessionWrapper;
import org.chromattic.core.query.QueryResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl<O>
implements org.chromattic.api.query.Query<O> {
    private final Query jcrQuery;
    private final Class<O> clazz;
    private final DomainSession session;

    QueryImpl(DomainSession session, Class<O> clazz, Query jcrQuery) throws RepositoryException {
        this.session = session;
        this.clazz = clazz;
        this.jcrQuery = jcrQuery;
    }

    public QueryResult<O> objects() throws ChromatticException {
        return this.objects(null, null);
    }

    public QueryResult<O> objects(Long offset, Long limit) throws ChromatticException {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException();
        }
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException();
        }
        try {
            SessionWrapper wrapper = this.session.getSessionWrapper();
            javax.jcr.query.QueryResult result = wrapper.executeQuery(this.jcrQuery, offset, limit);
            return new QueryResultImpl<O>(this.session, result.getNodes(), this.clazz);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }
}

