/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen;

import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chromattic.metamodel.typegen.NodeDefinition;
import org.chromattic.metamodel.typegen.NodeType;
import org.chromattic.metamodel.typegen.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeTypeSerializer {
    private static final Map<String, String> DEFAULT_MAPPINGS;
    private final LinkedHashMap<String, NodeType> nodeTypes;
    private final Map<String, String> mappings;
    private boolean generatedUndeclaredNodeType;

    public NodeTypeSerializer(List<NodeType> nodeTypes, Map<String, String> mappings) {
        if (nodeTypes == null) {
            throw new NullPointerException();
        }
        mappings = new HashMap<String, String>(mappings);
        mappings.putAll(DEFAULT_MAPPINGS);
        this.nodeTypes = new LinkedHashMap();
        this.mappings = mappings;
        this.generatedUndeclaredNodeType = false;
        for (NodeType nodeType : nodeTypes) {
            this.addNodeType(nodeType);
        }
    }

    public NodeTypeSerializer(List<NodeType> nodeTypes) {
        this(nodeTypes, Collections.emptyMap());
    }

    public NodeTypeSerializer(Map<String, String> mappings) {
        this(Collections.emptyList(), mappings);
    }

    protected NodeTypeSerializer() {
        this(Collections.emptyList(), Collections.emptyMap());
    }

    public boolean getGeneratedUndeclaredNodeType() {
        return this.generatedUndeclaredNodeType;
    }

    public void setGeneratedUndeclaredNodeType(boolean generatedUndeclaredNodeType) {
        this.generatedUndeclaredNodeType = generatedUndeclaredNodeType;
    }

    public void addNodeType(NodeType nodeType) {
        if (nodeType == null) {
            throw new NullPointerException("No node type provided");
        }
        this.nodeTypes.put(nodeType.getName(), nodeType);
    }

    public void addPrefixMapping(String namespacePrefix, String namespaceURI) {
        if (namespacePrefix == null) {
            throw new NullPointerException("No null namespace prefix accepted");
        }
        if (namespaceURI == null) {
            throw new NullPointerException("No null namespace uri accepted");
        }
        this.mappings.put(namespacePrefix, namespaceURI);
    }

    public abstract void writeTo(Writer var1) throws Exception;

    public final void writeTo() throws Exception {
        this.startNodeTypes(Collections.unmodifiableMap(this.mappings));
        HashSet<String> done = new HashSet<String>();
        HashSet<String> queued = new HashSet<String>();
        for (NodeType nodeType : this.nodeTypes.values()) {
            this.write(nodeType, done, queued);
        }
        this.endNodeTypes();
    }

    public void write(NodeType nodeType, Set<String> done, Set<String> queued) throws Exception {
        if (done.contains(nodeType.getName())) {
            return;
        }
        if (queued.contains(nodeType.getName())) {
            throw new AssertionError();
        }
        queued.add(nodeType.getName());
        for (NodeType superType : nodeType.getSuperTypes()) {
            this.write(superType, done, queued);
        }
        for (NodeDefinition childDef : nodeType.getChildNodeDefinitions().values()) {
            NodeType childDefNodeType = this.nodeTypes.get(childDef.getNodeTypeName());
            if (childDefNodeType == nodeType || childDefNodeType == null) continue;
            this.write(childDefNodeType, done, queued);
        }
        if (nodeType.isDeclared() || this.generatedUndeclaredNodeType) {
            this.write(nodeType);
        }
        queued.remove(nodeType.getName());
        done.add(nodeType.getName());
    }

    private void write(NodeType nodeType) throws Exception {
        LinkedHashSet<String> superTypeNames = new LinkedHashSet<String>();
        if (nodeType.declaredSuperTypes.isEmpty()) {
            superTypeNames.add("nt:base");
        }
        for (NodeType superType : nodeType.declaredSuperTypes) {
            superTypeNames.add(superType.getName());
        }
        if (nodeType.isReferenceable()) {
            superTypeNames.add("mix:referenceable");
        }
        this.startNodeType(nodeType.getClassName(), nodeType.getName(), nodeType.isMixin(), nodeType.isOrderable(), superTypeNames);
        this.startProperties();
        for (PropertyDefinition propertyDefinition : nodeType.getPropertyDefinitions().values()) {
            this.property(propertyDefinition.getName(), propertyDefinition.getType(), propertyDefinition.isMultiple(), propertyDefinition.getDefaultValues(), propertyDefinition.getValueConstraints());
        }
        this.endProperties();
        this.startChildNodes();
        for (NodeDefinition childNodeDefinition : nodeType.getChildNodeDefinitions().values()) {
            this.childNode(childNodeDefinition.getName(), childNodeDefinition.getNodeTypeName(), childNodeDefinition.isMandatory(), childNodeDefinition.isAutocreated());
        }
        this.endChildNodes();
        this.endNodeType();
    }

    public void startNodeTypes(Map<String, String> mappings) throws Exception {
    }

    public void startNodeType(String javaClassName, String name, boolean mixin, boolean orderableChildNodes, Collection<String> superTypeNames) throws Exception {
    }

    public void startProperties() throws Exception {
    }

    public void property(String name, int requiredType, boolean multiple, Collection<String> defaultValues, Collection<String> valueConstraints) throws Exception {
    }

    public void endProperties() throws Exception {
    }

    public void startChildNodes() throws Exception {
    }

    public void childNode(String name, String nodeTypeName, boolean mandatory, boolean autocreated) throws Exception {
    }

    public void endChildNodes() throws Exception {
    }

    public void endNodeType() throws Exception {
    }

    public void endNodeTypes() throws Exception {
    }

    static {
        HashMap<String, String> def = new HashMap<String, String>();
        def.put("nt", "http://www.jcp.org/jcr/nt/1.0");
        def.put("mix", "http://www.jcp.org/jcr/mix/1.0");
        def.put("jcr", "http://www.jcp.org/jcr/1.0");
        DEFAULT_MAPPINGS = Collections.unmodifiableMap(def);
    }
}

