/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileSection;
import org.exoplatform.social.webui.profile.UITitleBar;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.PersonalNameValidator;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIExperienceSection.gtmpl", events={@EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, confirm="UIExperienceSection.msg.confirmDeleteExp", phase=Event.Phase.DECODE), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UICheckBoxInput.class, id="UIFormCheckBoxEndDate", events={@EventConfig(phase=Event.Phase.DECODE, listeners={ShowHideEndDateActionListener.class})})})
public class UIExperienceSection
extends UIProfileSection {
    public static final String START_DATE_AFTER_TODAY = "UIExperienceSection.msg.StartDateAfterToday";
    public static final String END_DATE_AFTER_TODAY = "UIExperienceSection.msg.EndDateAfterToday";
    public static final String STARTDATE_BEFORE_ENDDATE = "UIExperienceSection.msg.startDateBeforeEndDate";
    public static final String DATE_FORMAT_MMDDYYYY = "MM/dd/yyyy";
    private static final String DATETIME_REGEX = "^(\\d{1,2}\\/\\d{1,2}\\/\\d{1,4})\\s*(\\s+\\d{1,2}:\\d{1,2}:\\d{1,2})?$";
    private static final String INVALID_START_DATE_MANDATORY = "UIExperienceSection.msg.Invalid-startdate-mandatory";
    private static final String INVALID_END_DATE_MANDATORY = "UIExperienceSection.msg.Invalid-enddate-mandatory";
    private static final String INVALID_START_DATE_FORMAT = "UIExperienceSection.msg.Invalid-startdate-format";
    private static final String INVALID_END_DATE_FORMAT = "UIExperienceSection.msg.Invalid-enddate-format";
    private static final String INVALID_COMPANY_STRINGLENGTH = "UIExperienceSection.msg.Invalid-company-stringlength";
    private static final String INVALID_COMPANY_MANDATORY = "UIExperienceSection.msg.Invalid-company-mandatory";
    private static final String INVALID_POSITION_STRINGLENGTH = "UIExperienceSection.msg.Invalid-position-stringlength";
    private static final String INVALID_POSITION_MANDATORY = "UIExperienceSection.msg.Invalid-position-mandatory";
    private static final String HTML_ATTRIBUTE_TITLE = "title";
    int expIdx = 0;

    public int getExpCount() {
        return this.expIdx;
    }

    public List<UIComponent> getChilds() {
        return this.getChildren();
    }

    public UIExperienceSection() throws Exception {
        this.addChild(UITitleBar.class, null, null);
    }

    public int getMonth(String inDate) throws ParseException {
        if (inDate == null || inDate.length() == 0) {
            return 0;
        }
        Calendar calendar = this.getCalendar(inDate);
        return calendar.get(2) + 1;
    }

    public int getDate(String inDate) throws ParseException {
        if (inDate == null || inDate.length() == 0) {
            return 0;
        }
        Calendar calendar = this.getCalendar(inDate);
        return calendar.get(5);
    }

    protected String calendarToString(Calendar cal) {
        String sDate = "";
        if (cal != null) {
            SimpleDateFormat sd = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY, Locale.ENGLISH);
            sDate = sd.format(cal.getTime());
        }
        return sDate;
    }

    protected Calendar stringToCalendar(String sDate) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY, Locale.ENGLISH);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(sd.parse(sDate));
            return calendar;
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected String displayDateTime(Object d) throws ParseException {
        Date date = this.stringToCalendar(d.toString()).getTime();
        Locale l = WebuiRequestContext.getCurrentInstance().getLocale();
        DateFormat sf = SimpleDateFormat.getDateInstance(1, l);
        return sf.format(date);
    }

    public int getYear(String inDate) throws ParseException {
        if (inDate == null || inDate.length() == 0) {
            return 0;
        }
        Calendar calendar = this.getCalendar(inDate);
        return calendar.get(1);
    }

    public List<HashMap<String, Object>> getPastExperience() throws Exception {
        ArrayList<HashMap<String, Object>> pastExperiences = new ArrayList<HashMap<String, Object>>();
        Profile p = this.getProfile();
        ArrayList experiences = (ArrayList)p.getProperty("experiences");
        if (experiences != null) {
            for (HashMap map : experiences) {
                if (((Boolean)map.get("isCurrent")).booleanValue()) continue;
                pastExperiences.add(map);
            }
        }
        return pastExperiences;
    }

    public List<HashMap<String, Object>> getCurrentExperience() throws Exception {
        ArrayList<HashMap<String, Object>> currentExperiences = new ArrayList<HashMap<String, Object>>();
        Profile p = this.getProfile();
        ArrayList experiences = (ArrayList)p.getProperty("experiences");
        if (experiences != null) {
            for (HashMap map : experiences) {
                if (!((Boolean)map.get("isCurrent")).booleanValue()) continue;
                currentExperiences.add(map);
            }
        }
        return currentExperiences;
    }

    private int saveProfileInfo() throws Exception {
        ArrayList experiences = new ArrayList();
        UIFormStringInput uiStringInput = null;
        UIFormTextAreaInput uiFormTextAreaInput = null;
        UICheckBoxInput uiCheckBox = null;
        UIFormDateTimeInput uiDateTimeInput = null;
        String company = null;
        String position = null;
        String description = null;
        String skills = null;
        String startDate = null;
        String endDate = null;
        Boolean isCurrent = null;
        Date sDate = null;
        Date eDate = null;
        Date today = new Date();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIApplication uiApplication = context.getUIApplication();
        Profile p = this.getProfile();
        List<UIComponent> listUIComp = this.getChilds();
        int totalUIComponent = listUIComp.size() - 1;
        int errorCode = 0;
        if (totalUIComponent == 0) {
            if (p != null) {
                Profile updateProfile = new Profile(p.getIdentity());
                updateProfile.setId(p.getId());
                updateProfile.setProperty("experiences", experiences);
                Utils.getIdentityManager().updateExperienceSection(updateProfile);
            }
            return errorCode;
        }
        for (int i = 1; i <= totalUIComponent; i += 7) {
            HashMap<String, Object> uiMap = new HashMap<String, Object>();
            uiStringInput = (UIFormStringInput)listUIComp.get(i);
            company = (String)uiStringInput.getValue();
            if (company == null || company.length() == 0) {
                uiApplication.addMessage(new ApplicationMessage(INVALID_COMPANY_MANDATORY, null, 1));
                errorCode = 1;
            }
            if ((position = (String)(uiStringInput = (UIFormStringInput)listUIComp.get(i + 1)).getValue()) == null || position.length() == 0) {
                uiApplication.addMessage(new ApplicationMessage(INVALID_POSITION_MANDATORY, null, 1));
                errorCode = 1;
            }
            uiFormTextAreaInput = (UIFormTextAreaInput)listUIComp.get(i + 2);
            description = (String)uiFormTextAreaInput.getValue();
            uiFormTextAreaInput = (UIFormTextAreaInput)listUIComp.get(i + 3);
            skills = (String)uiFormTextAreaInput.getValue();
            uiDateTimeInput = (UIFormDateTimeInput)listUIComp.get(i + 4);
            Locale locale = context.getParentAppRequestContext().getLocale();
            String currentPartern = uiDateTimeInput.getDatePattern_();
            SimpleDateFormat sf = new SimpleDateFormat(currentPartern, locale);
            Calendar cal = Calendar.getInstance();
            if (!"".equals(uiDateTimeInput.getValue())) {
                cal.setTime(sf.parse((String)uiDateTimeInput.getValue()));
                startDate = this.calendarToString(cal);
                if (startDate == null || startDate.length() == 0) {
                    uiApplication.addMessage(new ApplicationMessage(INVALID_START_DATE_MANDATORY, null, 1));
                    errorCode = 1;
                }
            }
            try {
                uiDateTimeInput = (UIFormDateTimeInput)listUIComp.get(i + 5);
                if (!"".equals(uiDateTimeInput.getValue())) {
                    cal.setTime(sf.parse((String)uiDateTimeInput.getValue()));
                }
            }
            catch (Exception e) {
                endDate = null;
            }
            uiCheckBox = (UICheckBoxInput)listUIComp.get(i + 6);
            isCurrent = (Boolean)uiCheckBox.getValue();
            if (startDate == null && (endDate != null || isCurrent.booleanValue()) || "".equals(startDate) && ("".equals(endDate) || isCurrent.booleanValue())) {
                uiApplication.addMessage(new ApplicationMessage(INVALID_START_DATE_MANDATORY, null, 1));
                errorCode = 1;
            }
            if (startDate != null && !"".equals(startDate)) {
                endDate = this.calendarToString(cal);
                sDate = this.stringToDate(startDate);
                eDate = this.stringToDate(endDate);
                if (endDate != null && !"".equals(endDate) && sDate.after(today)) {
                    uiApplication.addMessage(new ApplicationMessage(START_DATE_AFTER_TODAY, null, 1));
                    errorCode = 1;
                }
                if (!isCurrent.booleanValue()) {
                    if (endDate == null || endDate.length() == 0) {
                        uiApplication.addMessage(new ApplicationMessage(INVALID_END_DATE_MANDATORY, null, 1));
                        errorCode = 1;
                    }
                    if (eDate != null && eDate.after(today)) {
                        uiApplication.addMessage(new ApplicationMessage(END_DATE_AFTER_TODAY, null, 1));
                        errorCode = 1;
                    }
                    if (sDate != null && sDate.after(eDate)) {
                        uiApplication.addMessage(new ApplicationMessage(STARTDATE_BEFORE_ENDDATE, null, 1));
                        errorCode = 1;
                    }
                } else {
                    endDate = null;
                }
            }
            uiMap.put("company", this.escapeHtml(company));
            uiMap.put("position", this.escapeHtml(position));
            uiMap.put("description", this.escapeHtml(description));
            uiMap.put("skills", this.escapeHtml(skills));
            uiMap.put("startDate", startDate);
            uiMap.put("endDate", endDate);
            uiMap.put("isCurrent", isCurrent);
            experiences.add(uiMap);
        }
        if (errorCode == 1) {
            return errorCode;
        }
        p.setProperty("experiences", experiences);
        Utils.getIdentityManager().updateProfile(p);
        return errorCode;
    }

    private void addUIFormInput() throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        ++this.expIdx;
        this.addUIFormInput((UIFormInput)new UIFormStringInput("company" + this.expIdx, null, null).addValidator(PersonalNameValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("position" + this.expIdx, null, null).addValidator(PersonalNameValidator.class, new Object[0]));
        UIFormTextAreaInput description = new UIFormTextAreaInput("description" + this.expIdx, null, null);
        description.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIExperienceSection.label.description"));
        this.addUIFormInput((UIFormInput)description);
        UIFormTextAreaInput uiDespcription = (UIFormTextAreaInput)this.getChildById("description" + this.expIdx);
        uiDespcription.setColumns(28);
        uiDespcription.setRows(3);
        UIFormTextAreaInput skills = new UIFormTextAreaInput("skills" + this.expIdx, null, null);
        skills.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIExperienceSection.label.skills"));
        this.addUIFormInput((UIFormInput)skills);
        UIFormTextAreaInput uiFormTextAreaInput = (UIFormTextAreaInput)this.getChildById("skills" + this.expIdx);
        uiFormTextAreaInput.setColumns(28);
        uiFormTextAreaInput.setRows(3);
        UIFormDateTimeInput startDate = new UIFormDateTimeInput("startDate" + this.expIdx, null, null, false);
        startDate.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIExperienceSection.label.startDate"));
        this.addUIFormInput((UIFormInput)startDate.addValidator(ExpressionValidator.class, new Object[]{DATETIME_REGEX, INVALID_START_DATE_FORMAT}));
        UIFormDateTimeInput endDate = new UIFormDateTimeInput("endDate" + this.expIdx, null, null, false);
        endDate.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIExperienceSection.label.endDate"));
        this.addUIFormInput((UIFormInput)endDate.addValidator(ExpressionValidator.class, new Object[]{DATETIME_REGEX, INVALID_END_DATE_FORMAT}));
        UICheckBoxInput uiDateInputCheck = new UICheckBoxInput(Integer.toString(this.expIdx), null, Boolean.valueOf(false));
        uiDateInputCheck.setComponentConfig(UICheckBoxInput.class, "UIFormCheckBoxEndDate");
        uiDateInputCheck.setOnChange("ShowHideEndDate", uiDateInputCheck.getId());
        this.addUIFormInput((UIFormInput)uiDateInputCheck);
    }

    private Date stringToDate(String dateStr) throws ParseException {
        SimpleDateFormat formatDate = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY, Locale.ENGLISH);
        if (dateStr == null || dateStr.trim().length() == 0) {
            return null;
        }
        return formatDate.parse(dateStr);
    }

    private Calendar getCalendar(String inDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY, Locale.ENGLISH);
        Date date = format.parse(inDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static class ShowHideEndDateActionListener
    extends EventListener<UICheckBoxInput> {
        public void execute(Event<UICheckBoxInput> event) throws Exception {
            UICheckBoxInput sect = (UICheckBoxInput)event.getSource();
            UIExperienceSection uiForm = (UIExperienceSection)sect.getAncestorOfType(UIExperienceSection.class);
            UIFormDateTimeInput uiDateTime = (UIFormDateTimeInput)uiForm.getChildById("endDate" + sect.getId());
            boolean isCheck = sect.isChecked();
            uiDateTime.setRendered(!isCheck);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class EditActionListener
    extends UIProfileSection.EditActionListener {
        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIExperienceSection uiExpSection = (UIExperienceSection)sect;
            Profile p = sect.getProfile();
            List<UIComponent> listChild = uiExpSection.getChilds();
            ArrayList<String> listProfile = new ArrayList<String>();
            int childSize = listChild.size() - 1;
            String companyId = null;
            String positionId = null;
            String skillsId = null;
            String startDateId = null;
            String isCurrentId = null;
            String endDateId = null;
            String descriptionId = null;
            ArrayList experiences = (ArrayList)p.getProperty("experiences");
            if (experiences == null) {
                for (int idx = 1; idx <= childSize; idx += 7) {
                    sect.removeChild(UIFormStringInput.class);
                    sect.removeChild(UIFormStringInput.class);
                    sect.removeChild(UIFormTextAreaInput.class);
                    sect.removeChild(UIFormTextAreaInput.class);
                    sect.removeChild(UIFormDateTimeInput.class);
                    sect.removeChild(UIFormDateTimeInput.class);
                    sect.removeChild(UICheckBoxInput.class);
                }
            } else {
                for (HashMap map : experiences) {
                    listProfile.add(StringEscapeUtils.unescapeHtml((String)((String)map.get("company"))));
                    listProfile.add(StringEscapeUtils.unescapeHtml((String)((String)map.get("position"))));
                    listProfile.add(StringEscapeUtils.unescapeHtml((String)((String)map.get("description"))));
                    listProfile.add(StringEscapeUtils.unescapeHtml((String)((String)map.get("skills"))));
                    listProfile.add((String)map.get("startDate"));
                    listProfile.add((String)map.get("endDate"));
                    listProfile.add((String)map.get("isCurrent"));
                }
                int totalProfiles = listProfile.size();
                int numberOfChildren = 0;
                if (totalProfiles > childSize) {
                    for (numberOfChildren = childSize; totalProfiles > numberOfChildren; numberOfChildren += 7) {
                        uiExpSection.addUIFormInput();
                    }
                } else if (totalProfiles < childSize) {
                    for (numberOfChildren = childSize; totalProfiles < numberOfChildren; numberOfChildren -= 7) {
                        companyId = listChild.get(childSize - 6).getName();
                        positionId = listChild.get(childSize - 5).getName();
                        descriptionId = listChild.get(childSize - 4).getName();
                        skillsId = listChild.get(childSize - 3).getName();
                        startDateId = listChild.get(childSize - 2).getName();
                        endDateId = listChild.get(childSize - 1).getName();
                        isCurrentId = listChild.get(childSize).getName();
                        sect.removeChildById(companyId);
                        sect.removeChildById(positionId);
                        sect.removeChildById(descriptionId);
                        sect.removeChildById(skillsId);
                        sect.removeChildById(startDateId);
                        sect.removeChildById(endDateId);
                        sect.removeChildById(isCurrentId);
                    }
                }
                List<UIComponent> listChildForSetValue = uiExpSection.getChilds();
                for (int idx = 0; idx < totalProfiles; idx += 7) {
                    ((UIFormInput)listChildForSetValue.get(idx + 1)).setValue(listProfile.get(idx));
                    ((UIFormInput)listChildForSetValue.get(idx + 2)).setValue(listProfile.get(idx + 1));
                    ((UIFormInput)listChildForSetValue.get(idx + 3)).setValue(listProfile.get(idx + 2));
                    ((UIFormInput)listChildForSetValue.get(idx + 4)).setValue(listProfile.get(idx + 3));
                    if (listProfile.get(idx + 4) != null) {
                        ((UIFormDateTimeInput)listChildForSetValue.get(idx + 5)).setCalendar(uiExpSection.stringToCalendar(listProfile.get(idx + 4).toString()));
                    }
                    if (listProfile.get(idx + 5) != null) {
                        ((UIFormDateTimeInput)listChildForSetValue.get(idx + 6)).setCalendar(uiExpSection.stringToCalendar(listProfile.get(idx + 5).toString()));
                    } else {
                        ((UIFormInput)listChildForSetValue.get(idx + 6)).setValue(listProfile.get(idx + 5));
                    }
                    ((UICheckBoxInput)listChildForSetValue.get(idx + 7)).setValue((Boolean)listProfile.get(idx + 6));
                    ((UIFormDateTimeInput)listChildForSetValue.get(idx + 6)).setRendered((Boolean)((UICheckBoxInput)listChildForSetValue.get(idx + 7)).getValue() == false);
                }
            }
            super.execute(event);
        }
    }

    public static class SaveActionListener
    extends UIProfileSection.SaveActionListener {
        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIExperienceSection uiExperienceSectionSect = (UIExperienceSection)sect;
            if (uiExperienceSectionSect.saveProfileInfo() == 0) {
                super.execute(event);
            }
        }
    }

    public static class RemoveActionListener
    extends EventListener<UIExperienceSection> {
        public void execute(Event<UIExperienceSection> event) throws Exception {
            UIExperienceSection uiForm = (UIExperienceSection)((Object)event.getSource());
            String block = event.getRequestContext().getRequestParameter("objectId");
            int blockIdx = Integer.parseInt(block);
            String companyId = null;
            String positionId = null;
            String descriptionId = null;
            String skillsId = null;
            String startDateId = null;
            String endDateId = null;
            String isCurrentId = null;
            List<UIComponent> listChild = uiForm.getChilds();
            companyId = listChild.get(blockIdx).getId();
            positionId = listChild.get(blockIdx + 1).getId();
            descriptionId = listChild.get(blockIdx + 2).getId();
            skillsId = listChild.get(blockIdx + 3).getId();
            startDateId = listChild.get(blockIdx + 4).getId();
            endDateId = listChild.get(blockIdx + 5).getId();
            isCurrentId = listChild.get(blockIdx + 6).getId();
            uiForm.removeChildById(companyId);
            uiForm.removeChildById(positionId);
            uiForm.removeChildById(descriptionId);
            uiForm.removeChildById(skillsId);
            uiForm.removeChildById(startDateId);
            uiForm.removeChildById(endDateId);
            uiForm.removeChildById(isCurrentId);
        }
    }

    public static class AddActionListener
    extends EventListener<UIExperienceSection> {
        public void execute(Event<UIExperienceSection> event) throws Exception {
            UIExperienceSection uiForm = (UIExperienceSection)((Object)event.getSource());
            uiForm.addUIFormInput();
        }
    }
}

