/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/social/webui/space/UIManagePendingSpaces.gtmpl", events={@EventConfig(listeners={RevokePendingActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={LoadMoreSpaceActionListener.class})})
public class UIManagePendingSpaces
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIManagePendingSpaces.class);
    private static final String SPACE_DELETED_INFO = "UIManagePendingSpaces.msg.DeletedInfo";
    private static final String PENDING_STATUS = "pending";
    private static final String SEARCH_ALL = "All";
    private static final String SPACE_SEARCH = "SpaceSearch";
    SpaceService spaceService = null;
    String userId = null;
    private final Integer SPACES_PER_PAGE = 20;
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");
    private boolean loadAtEnd = false;
    private boolean hasUpdatedSpace = false;
    private int currentLoadIndex;
    private boolean enableLoadNext;
    private int loadingCapacity;
    private String spaceNameSearch;
    private List<Space> pendingSpacesList;
    private ListAccess<Space> pendingSpacesListAccess;
    private int pendingSpacesNum;
    private String selectedChar = null;

    public UIManagePendingSpaces() throws Exception {
        this.uiSpaceSearch.setTypeOfRelation(PENDING_STATUS);
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.init();
    }

    public void init() {
        try {
            this.setHasUpdatedSpace(false);
            this.setLoadAtEnd(false);
            this.enableLoadNext = true;
            this.currentLoadIndex = 0;
            this.loadingCapacity = this.SPACES_PER_PAGE;
            this.pendingSpacesList = new ArrayList<Space>();
            this.setPendingSpacesList(this.loadPendingSpaces(this.currentLoadIndex, this.loadingCapacity));
            this.setSelectedChar(SEARCH_ALL);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean enableLoadNext) {
        this.enableLoadNext = enableLoadNext;
    }

    public boolean isLoadAtEnd() {
        return this.loadAtEnd;
    }

    public void setLoadAtEnd(boolean loadAtEnd) {
        this.loadAtEnd = loadAtEnd;
    }

    public boolean isHasUpdatedSpace() {
        return this.hasUpdatedSpace;
    }

    public void setHasUpdatedSpace(boolean hasUpdatedSpace) {
        this.hasUpdatedSpace = hasUpdatedSpace;
    }

    public List<Space> getPendingSpacesList() throws Exception {
        if (this.isHasUpdatedSpace()) {
            this.setHasUpdatedSpace(false);
            this.setPendingSpacesList(this.loadPendingSpaces(0, this.pendingSpacesList.size()));
        }
        this.setEnableLoadNext(this.pendingSpacesList.size() >= this.SPACES_PER_PAGE && this.pendingSpacesList.size() < this.getPendingSpacesNum());
        return this.pendingSpacesList;
    }

    public void setPendingSpacesList(List<Space> pendingSpacesList) {
        this.pendingSpacesList = pendingSpacesList;
    }

    public int getPendingSpacesNum() {
        return this.pendingSpacesNum;
    }

    public void setPendingSpacesNum(int pendingSpacesNum) {
        this.pendingSpacesNum = pendingSpacesNum;
    }

    public String getSelectedChar() {
        return this.selectedChar;
    }

    public void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public String getSpaceNameSearch() {
        return this.spaceNameSearch;
    }

    public void setSpaceNameSearch(String spaceNameSearch) {
        this.spaceNameSearch = spaceNameSearch;
    }

    public ListAccess<Space> getPendingSpacesListAccess() {
        return this.pendingSpacesListAccess;
    }

    public void setPendingSpacesListAccess(ListAccess<Space> pendingSpacesListAccess) {
        this.pendingSpacesListAccess = pendingSpacesListAccess;
    }

    public void loadNext() throws Exception {
        this.currentLoadIndex += this.loadingCapacity;
        if (this.currentLoadIndex <= this.getPendingSpacesNum()) {
            this.pendingSpacesList.addAll(new ArrayList<Object>(Arrays.asList(this.getPendingSpacesListAccess().load(this.currentLoadIndex, this.loadingCapacity))));
        }
    }

    public void loadSearch() throws Exception {
        this.currentLoadIndex = 0;
        this.setPendingSpacesList(this.loadPendingSpaces(this.currentLoadIndex, this.loadingCapacity));
    }

    private List<Space> loadPendingSpaces(int index, int length) throws Exception {
        String charSearch = this.getSelectedChar();
        String searchCondition = this.uiSpaceSearch.getSpaceNameSearch();
        if (charSearch == null && searchCondition == null || charSearch != null && charSearch.equals(SEARCH_ALL)) {
            this.setPendingSpacesListAccess((ListAccess<Space>)this.getSpaceService().getPendingSpacesWithListAccess(this.getUserId()));
        } else {
            SpaceFilter spaceFilter = null;
            spaceFilter = charSearch != null ? new SpaceFilter(charSearch.charAt(0)) : new SpaceFilter(searchCondition);
            this.setPendingSpacesListAccess((ListAccess<Space>)this.getSpaceService().getPendingSpacesByFilter(this.getUserId(), spaceFilter));
        }
        this.setPendingSpacesNum(this.getPendingSpacesListAccess().getSize());
        this.uiSpaceSearch.setSpaceNum(this.getPendingSpacesNum());
        Space[] spaces = (Space[])this.getPendingSpacesListAccess().load(index, length);
        return new ArrayList<Space>(Arrays.asList(spaces));
    }

    public String getImageSource(Space space) throws Exception {
        return space.getAvatarUrl();
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    public static class RevokePendingActionListener
    extends EventListener<UIManagePendingSpaces> {
        public void execute(Event<UIManagePendingSpaces> event) throws Exception {
            UIManagePendingSpaces uiPendingSpaces = (UIManagePendingSpaces)((Object)event.getSource());
            SpaceService spaceService = uiPendingSpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiPendingSpaces.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            uiPendingSpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManagePendingSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            uiPendingSpaces.setHasUpdatedSpace(true);
            spaceService.removePendingUser(space, userId);
        }
    }

    public static class SearchActionListener
    extends EventListener<UIManagePendingSpaces> {
        public void execute(Event<UIManagePendingSpaces> event) throws Exception {
            UIManagePendingSpaces uiManagePendingSpaces = (UIManagePendingSpaces)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            String charSearch = ctx.getRequestParameter("objectId");
            if (charSearch == null) {
                uiManagePendingSpaces.setSelectedChar(null);
            } else {
                ResourceBundle resApp = ctx.getApplicationResourceBundle();
                String defaultSpaceNameAndDesc = resApp.getString(uiManagePendingSpaces.getId() + ".label.DefaultSpaceNameAndDesc");
                uiManagePendingSpaces.uiSpaceSearch.getUIStringInput(UIManagePendingSpaces.SPACE_SEARCH).setValue((Object)defaultSpaceNameAndDesc);
                uiManagePendingSpaces.setSelectedChar(charSearch);
            }
            uiManagePendingSpaces.loadSearch();
            uiManagePendingSpaces.setLoadAtEnd(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManagePendingSpaces);
        }
    }

    public static class LoadMoreSpaceActionListener
    extends EventListener<UIManagePendingSpaces> {
        public void execute(Event<UIManagePendingSpaces> event) throws Exception {
            UIManagePendingSpaces uiManagePendingSpaces = (UIManagePendingSpaces)((Object)event.getSource());
            uiManagePendingSpaces.loadNext();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManagePendingSpaces);
        }
    }
}

