/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.navigation;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;

public class NavigationServiceHandler
extends BaseWebSchemaHandler {
    private static Log logger = ExoLogger.getLogger(NavigationServiceHandler.class);
    Calendar calendar = new GregorianCalendar();

    public void onCreateNode(SessionProvider sessionProvider, Node portalFolder) throws Exception {
        if (portalFolder.hasNode("ApplicationData")) {
            Node applicationDataFolder = portalFolder.getNode("ApplicationData");
            Node logoApplicationFolder = applicationDataFolder.addNode("logo", "nt:unstructured");
            this.addMixin(logoApplicationFolder, "exo:owneable");
            this.addMixin(logoApplicationFolder, "exo:datetime");
            this.addMixin(logoApplicationFolder, "exo:hiddenable");
            logoApplicationFolder.setProperty("exo:dateCreated", this.calendar);
        }
        portalFolder.getSession().save();
    }

    public static String getHomePageLogoURI() {
        String pathImageNode;
        Node imageNode;
        Boolean isavailable;
        block6: {
            isavailable = false;
            imageNode = null;
            pathImageNode = null;
            try {
                NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
                SessionProvider sProvider = SessionProvider.createSystemProvider();
                Node publicApplicationNode = nodeCreator.getPublicApplicationNode(sProvider);
                Session session = publicApplicationNode.getSession();
                Node rootNode = session.getRootNode();
                String path = "Application Data/logos/";
                Node logoNode = rootNode.getNode(path);
                if (!logoNode.hasNodes()) break block6;
                NodeIterator iterator = logoNode.getNodes();
                while (iterator.hasNext()) {
                    String JcrMimeType;
                    Node node = iterator.nextNode();
                    imageNode = node;
                    if (!imageNode.hasNode("jcr:content") || !imageNode.getNode("jcr:content").hasProperty("jcr:mimeType") || !(JcrMimeType = imageNode.getNode("jcr:content").getProperty("jcr:mimeType").getString()).equals("image/gif") && !JcrMimeType.equals("image/ief") && !JcrMimeType.equals("image/jpeg") && !JcrMimeType.equals("image/pjpeg") && !JcrMimeType.equals("image/bmp") && !JcrMimeType.equals("image/x-portable-bitmap") && !JcrMimeType.equals("image/x-portable-graymap") && !JcrMimeType.equals("image/png") && !JcrMimeType.equals("image/x-png") && !JcrMimeType.equals("image/x-portable-anymap") && !JcrMimeType.equals("image/x-portable-pixmap") && !JcrMimeType.equals("image/x-cmu-raster") && !JcrMimeType.equals("image/x-rgb") && !JcrMimeType.equals("image/tiff") && !JcrMimeType.equals("image/x-xbitmap") && !JcrMimeType.equals("image/x-xpixmap") && !JcrMimeType.equals("image/x-xwindowdump")) continue;
                    isavailable = true;
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (isavailable.booleanValue()) {
            try {
                pathImageNode = imageNode.getPath() + "?" + System.currentTimeMillis();
            }
            catch (RepositoryException e) {
                logger.error((Object)"Get logo : Can not Find the path of node", (Throwable)e);
            }
            return pathImageNode;
        }
        return null;
    }

    protected String getHandlerNodeType() {
        return "exo:portalFolder";
    }

    protected String getParentNodeType() {
        return "nt:unstructured";
    }
}

