/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.portlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.platform.common.module.ModuleRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortletDisablerFilter
implements RenderFilter {
    private static final String PORTLET_DISABLED_DEFAULT_MESSAGE = "Portlet disabled.";
    private static final String DISABLED_HTML_FILE_PATH = "war:/../portlet-disabled.html";
    private static final Log LOG = ExoLogger.getExoLogger(PortletDisablerFilter.class);
    private PortletContext context;
    private String messageContent = null;
    private ModuleRegistry moduleRegistry = null;
    private Map<String, String> disabledPortletMessages = new HashMap<String, String>();

    public void init(FilterConfig filterConfig) throws PortletException {
        this.context = filterConfig.getPortletContext();
    }

    public void doFilter(RenderRequest request, RenderResponse response, FilterChain chain) throws IOException, PortletException {
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        String portletName = portletConfig.getPortletName();
        String portletID = this.context.getPortletContextName() + "/" + portletName;
        if (this.getModuleRegistry().isPortletActive(portletID)) {
            chain.doFilter(request, response);
        } else {
            LOG.info((Object)("The portlet '" + portletID + "' is currently disabled."));
            String html = this.getPortletSpecificMessage(request, portletName, portletID);
            response.getWriter().print(html);
        }
    }

    public void destroy() {
    }

    private String getPortletSpecificMessage(RenderRequest request, String portletName, String portletID) {
        String html = this.disabledPortletMessages.get(portletID);
        if (html == null || html.isEmpty()) {
            String portletDisplayName = this.getModuleRegistry().getDisplayName(portletName, request.getLocale());
            html = this.mergeDisabledContent(this.getModuleRegistry(), this.getDisablerMessage(), portletDisplayName, portletName, portletID);
            this.disabledPortletMessages.put(portletID, html);
        }
        return html;
    }

    private String getDisablerMessage() {
        if (this.messageContent == null || this.messageContent.isEmpty()) {
            ConfigurationManager confManager = (ConfigurationManager)PortalContainer.getComponent(ConfigurationManager.class);
            try {
                InputStream inputStream = confManager.getInputStream(DISABLED_HTML_FILE_PATH);
                this.messageContent = this.convertStreamToString(inputStream);
            }
            catch (Exception exception) {
                this.messageContent = PORTLET_DISABLED_DEFAULT_MESSAGE;
                LOG.error((Object)"Cannot read message for disabled portlet", (Throwable)exception);
            }
        }
        return this.messageContent;
    }

    private String mergeDisabledContent(ModuleRegistry moduleRegistry, String content, String portletDisplayName, String portletName, String portletID) {
        String result = content;
        result = result.replaceAll("ACTIVE_PROFILES", PortalContainer.getProfiles().toString());
        result = result.replaceAll("APP_NAME", portletDisplayName);
        result = result.replaceAll("APP_ID", portletName);
        result = result.replaceAll("PROFILE", moduleRegistry.getModulesForPortlet(portletID).toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    private ModuleRegistry getModuleRegistry() {
        if (this.moduleRegistry == null) {
            this.moduleRegistry = (ModuleRegistry)PortalContainer.getComponent(ModuleRegistry.class);
        }
        return this.moduleRegistry;
    }
}

