/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.related;

import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.rendering.cache.PageRenderingCacheService;
import org.exoplatform.wiki.rendering.macro.related.RelatedPagesMacroParameters;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.related.RelatedUtil;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component(value="related")
public class RelatedMacro
extends AbstractMacro<RelatedPagesMacroParameters> {
    private static final Log log_ = ExoLogger.getLogger(RelatedMacro.class);
    private static final String DESCRIPTION = "render related pages of current page";
    private static final Syntax XHTML_SYNTAX = new Syntax(SyntaxType.XHTML, "1.0");
    @Inject
    private Execution execution;

    public RelatedMacro() {
        super("Related pages", DESCRIPTION, RelatedPagesMacroParameters.class);
        this.setDefaultCategory("Navigation");
    }

    public List<Block> execute(RelatedPagesMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        WikiContext params = this.getWikiContext();
        if (params == null) {
            return Collections.emptyList();
        }
        RawBlock block = null;
        try {
            block = new RawBlock(this.createRelationList(params), XHTML_SYNTAX);
            PageRenderingCacheService renderingCacheService = (PageRenderingCacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PageRenderingCacheService.class);
            WikiContext wikiContext = this.getWikiContext();
            renderingCacheService.addPageLink(new WikiPageParams(wikiContext.getType(), wikiContext.getOwner(), wikiContext.getPageId()), new WikiPageParams(params.getType(), params.getOwner(), params.getPageId()));
        }
        catch (Exception e) {
            if (log_.isWarnEnabled()) {
                log_.warn((Object)"generate related macro failed", (Throwable)e);
            }
            return Collections.emptyList();
        }
        return Collections.singletonList(block);
    }

    String createRelationList(WikiContext context) throws Exception {
        String redirectURI = context.getRedirectURI();
        StringBuilder restUri = new StringBuilder();
        StringBuilder treeBuilder = new StringBuilder();
        String pathParam = URLEncoder.encode(RelatedUtil.getPath(context), "UTF-8");
        restUri.append(context.getRestURI()).append("/wiki/related/").append("?").append("path").append("=").append(pathParam);
        treeBuilder.append("<div class=\"UITreeExplorer RelatedMacro\">").append("   <input class='info' title=\"hidden\" type='hidden' restUrl='").append(restUri.toString()).append("' redirectUrl='").append(redirectURI).append("' />").append("</div>");
        return treeBuilder.toString();
    }

    public boolean supportsInlineMode() {
        return true;
    }

    private WikiContext getWikiContext() {
        ExecutionContext ec = this.execution.getContext();
        if (ec != null) {
            WikiContext wikiContext = (WikiContext)ec.getProperty("wikicontext");
            return wikiContext;
        }
        return null;
    }
}

