/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.shindig.config.ContainerConfigException;
import org.apache.shindig.expressions.Expressions;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.gadget.core.GateInJsonContainerConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import sun.misc.BASE64Encoder;

@Singleton
public class ExoContainerConfig
extends GateInJsonContainerConfig {
    private Log log = ExoLogger.getLogger(ExoContainerConfig.class);
    private static volatile String tokenKey_;
    private String signingKey_;

    @Inject
    public ExoContainerConfig(@Named(value="shindig.containers.default") String s, Expressions expressions) throws ContainerConfigException {
        super(s, expressions);
        RootContainer.getInstance();
        this.initializeTokenKeyFile();
        this.initializeSigningKeyFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeTokenKeyFile() {
        String keyPath = PropertyManager.getProperty((String)"gatein.gadgets.securitytokenkeyfile");
        File tokenKeyFile = null;
        if (keyPath == null) {
            this.log.warn((Object)"The gadgets token key is not configured. The default key.txt file in /bin will be used");
            tokenKeyFile = new File("key.txt");
        } else {
            tokenKeyFile = new File(keyPath);
        }
        keyPath = tokenKeyFile.getAbsolutePath();
        if (tokenKeyFile.exists()) {
            if (tokenKeyFile.isFile()) {
                this.setTokenKeyPath(keyPath);
                this.log.info((Object)("Found token key file " + keyPath + " for gadgets security"));
                return;
            }
            this.log.error((Object)("Found token path file " + keyPath + " but it's not a key file"));
            return;
        }
        this.log.debug((Object)("No token key file found at path " + keyPath + ". it's generating a new key and saving it"));
        File fic = tokenKeyFile.getAbsoluteFile();
        File parentFolder = fic.getParentFile();
        if (!parentFolder.exists() && !parentFolder.mkdirs()) {
            this.log.error((Object)("Coult not create parent folder/s for the token key file " + keyPath));
            return;
        }
        String key = ExoContainerConfig.generateKey();
        FileWriter out = null;
        try {
            out = new FileWriter(tokenKeyFile);
            out.write(key);
            ((Writer)out).write(10);
            this.setTokenKeyPath(keyPath);
            this.log.debug((Object)("Generated token key file " + keyPath + " for eXo Gadgets"));
        }
        catch (IOException e) {
            try {
                this.log.error((Object)("Could not create token key file " + keyPath), (Throwable)e);
            }
            catch (Throwable throwable) {
                Safe.close(out);
                throw throwable;
            }
            Safe.close((Closeable)out);
            return;
        }
        Safe.close((Closeable)out);
        return;
    }

    private void initializeSigningKeyFile() {
        File signingKeyFile;
        String signingKey = PropertyManager.getProperty((String)"gatein.gadgets.signingkeyfile");
        if (signingKey == null) {
            this.log.warn((Object)"The gadgets signing key is not configured. The default signing key in /bin directory will be used.");
            signingKeyFile = new File("oauthkey.pem");
        } else {
            signingKeyFile = new File(signingKey);
        }
        if (signingKeyFile.exists()) {
            if (signingKeyFile.isFile()) {
                this.signingKey_ = signingKeyFile.getAbsolutePath();
                this.log.info((Object)("Use signing key " + this.signingKey_ + " for gadget security"));
            } else {
                this.log.error((Object)("Found signing path file " + signingKeyFile.getAbsolutePath() + " but it's not a key file"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTokenKeyPath(String keyPath) {
        Class<ExoContainerConfig> clazz = ExoContainerConfig.class;
        synchronized (ExoContainerConfig.class) {
            if (tokenKey_ != null && !tokenKey_.equals(keyPath)) {
                throw new IllegalStateException("There is already a configured key path old=" + tokenKey_ + " new=" + keyPath);
            }
            tokenKey_ = keyPath;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Object getProperty(String container, String property) {
        if (property.equals("gadgets.securityTokenKeyFile") && tokenKey_ != null) {
            return tokenKey_;
        }
        if (property.equals("gadgets.signingKeyFile") && this.signingKey_ != null) {
            return this.signingKey_;
        }
        return super.getProperty(container, property);
    }

    static String getTokenKeyPath() {
        return tokenKey_;
    }

    private static String generateKey() {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(System.currentTimeMillis());
            byte[] bytes = new byte[32];
            random.nextBytes(bytes);
            BASE64Encoder encoder = new BASE64Encoder();
            return encoder.encode(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

