/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;

public class JSSourceFile
extends SourceFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SourceFile referenced;

    public static JSSourceFile fromFile(String fileName, Charset charSet) {
        return new JSSourceFile(SourceFile.fromFile(fileName, charSet));
    }

    public static JSSourceFile fromFile(String fileName) {
        return new JSSourceFile(SourceFile.fromFile(fileName, Charsets.UTF_8));
    }

    public static JSSourceFile fromFile(File file, Charset charSet) {
        return new JSSourceFile(SourceFile.fromFile(file, charSet));
    }

    public static JSSourceFile fromFile(File file) {
        return new JSSourceFile(SourceFile.fromFile(file, Charsets.UTF_8));
    }

    public static JSSourceFile fromCode(String fileName, String code) {
        return new JSSourceFile(SourceFile.fromCode(fileName, code));
    }

    public static JSSourceFile fromInputStream(String fileName, InputStream s) throws IOException {
        return new JSSourceFile(SourceFile.fromInputStream(fileName, s));
    }

    public static JSSourceFile fromGenerator(String fileName, SourceFile.Generator generator) {
        return new JSSourceFile(SourceFile.fromGenerator(fileName, generator));
    }

    private JSSourceFile(SourceFile referenced) {
        super(referenced.getName());
        this.referenced = referenced;
    }

    @Override
    public String getCode() throws IOException {
        return this.referenced.getCode();
    }

    @Override
    public void clearCachedSource() {
        this.referenced.clearCachedSource();
    }

    @Override
    @VisibleForTesting
    String getCodeNoCache() {
        return this.referenced.getCodeNoCache();
    }
}

