/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.connector.BaseSearchServiceConnector;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class PageSearchServiceConnector
extends BaseSearchServiceConnector {
    public PageSearchServiceConnector(InitParams initParams) throws Exception {
        super(initParams);
    }

    @Override
    protected QueryCriteria createQueryCriteria(String query, long offset, long limit, String sort, String order) {
        QueryCriteria criteria = new QueryCriteria();
        criteria.setContentTypes(new String[]{"gtn:language", "exo:pageMetadata"});
        criteria.setFulltextSearchProperty(new String[]{"exo:metaKeywords", "exo:metaDescription", "gtn:name"});
        criteria.setKeyword(query.toLowerCase());
        criteria.setSearchWebpage(true);
        criteria.setSearchDocument(false);
        criteria.setSearchWebContent(false);
        criteria.setMultiplePhaseSearch(true);
        criteria.setLiveMode(true);
        criteria.setOffset(offset);
        criteria.setLimit(limit);
        criteria.setSortBy(sort);
        criteria.setOrderBy(order);
        return criteria;
    }

    @Override
    protected AbstractPageList<ResultNode> searchNodes(QueryCriteria criteria) throws Exception {
        return this.siteSearch_.searchPageContents(WCMCoreUtils.getUserSessionProvider(), criteria, (int)criteria.getLimit(), false);
    }

    @Override
    protected ResultNode filterNode(ResultNode node) throws RepositoryException {
        return node;
    }

    @Override
    protected String getPath(DriveData driveData, ResultNode node, SearchContext context) throws Exception {
        return node.getUserNavigationURI();
    }

    @Override
    protected String getFileType(ResultNode node) throws Exception {
        return "FileDefault";
    }

    @Override
    protected String getTitleResult(ResultNode node) throws Exception {
        try {
            return ((Node)node.getSession().getItem(node.getProperty("mop:link/mop:page").getString())).getProperty("gtn:name").getString();
        }
        catch (Exception e) {
            return node.getTitle();
        }
    }
}

