/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.seo;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.seo.UISEOForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/webui/seo/UISEOPortletToolbar.gtmpl", events={@EventConfig(listeners={AddSEOActionListener.class})})
public class UISEOToolbarForm
extends UIForm {
    public static final String SEO_POPUP_WINDOW = "UISEOPopupWindow";
    private static ArrayList<String> paramsArray = null;
    private static String pageReference = null;
    private static PageMetadataModel metaModel = null;
    private String fullStatus = "Empty";
    private String lang = null;

    public void processRender(WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        this.lang = pcontext.getLocale().getLanguage();
        if (StringUtils.isNotEmpty((String)pcontext.getLocale().getCountry())) {
            this.lang = this.lang + "_" + pcontext.getLocale().getCountry();
        }
        String portalName = pcontext.getPortalOwner();
        metaModel = null;
        this.fullStatus = "Empty";
        if (!pcontext.useAjax()) {
            paramsArray = null;
            String contentParam = null;
            Enumeration params = pcontext.getRequest().getParameterNames();
            if (params.hasMoreElements()) {
                paramsArray = new ArrayList();
                while (params.hasMoreElements()) {
                    contentParam = params.nextElement().toString();
                    String contentValue = "";
                    try {
                        contentValue = org.exoplatform.services.jcr.util.Text.unescape((String)pcontext.getRequestParameter(contentParam));
                    }
                    catch (Exception ex) {
                        contentValue = pcontext.getRequestParameter(contentParam);
                    }
                    contentValue = Text.escapeIllegalJcrChars((String)contentValue);
                    paramsArray.add(contentValue);
                }
            }
        }
        SEOService seoService = (SEOService)WCMCoreUtils.getService(SEOService.class);
        pageReference = Util.getUIPortal().getSelectedUserNode().getPageRef().format();
        if (pageReference != null) {
            SiteKey siteKey = Util.getUIPortal().getSelectedUserNode().getNavigation().getKey();
            SiteKey portalKey = SiteKey.portal((String)portalName);
            if (siteKey != null && siteKey.equals((Object)portalKey)) {
                metaModel = seoService.getPageMetadata(pageReference, this.lang);
                if (paramsArray != null) {
                    PageMetadataModel tmpModel = seoService.getContentMetadata(paramsArray, this.lang);
                    if (tmpModel != null) {
                        metaModel = tmpModel;
                    } else {
                        for (int i = 0; i < paramsArray.size(); ++i) {
                            if (seoService.getContentNode(paramsArray.get(i).toString()) == null) continue;
                            metaModel = null;
                            break;
                        }
                    }
                }
            } else {
                this.fullStatus = "Disabled";
            }
        }
        if (metaModel != null) {
            this.fullStatus = metaModel.getFullStatus();
        }
        super.processRender(context);
    }

    public String getFullStatus() {
        return this.fullStatus;
    }

    public static class AddSEOActionListener
    extends EventListener<UISEOToolbarForm> {
        public void execute(Event<UISEOToolbarForm> event) throws Exception {
            String[] arrCoordinate;
            UISEOToolbarForm uiSEOToolbar = (UISEOToolbarForm)((Object)event.getSource());
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            UISEOForm uiSEOForm = (UISEOForm)uiSEOToolbar.createUIComponent(UISEOForm.class, null, null);
            String params = event.getRequestContext().getRequestParameter("objectId");
            SEOService seoService = (SEOService)WCMCoreUtils.getService(SEOService.class);
            if (paramsArray != null) {
                for (int i = 0; i < paramsArray.size(); ++i) {
                    Node contentNode = seoService.getContentNode(((String)paramsArray.get(i)).toString());
                    if (contentNode == null) continue;
                    uiSEOForm.setOnContent(true);
                    uiSEOForm.setContentPath(((String)paramsArray.get(i)).toString());
                    uiSEOForm.setContentURI(contentNode.getUUID());
                    break;
                }
                metaModel = seoService.getContentMetadata(paramsArray, uiSEOToolbar.lang);
            } else {
                uiSEOForm.setContentPath(pageReference);
                uiSEOForm.setOnContent(false);
                metaModel = seoService.getPageMetadata(pageReference, uiSEOToolbar.lang);
            }
            uiSEOForm.setParamsArray(paramsArray);
            if (metaModel == null) {
                List seoLocales = new ArrayList();
                seoLocales = seoService.getSEOLanguages(portalRequestContext.getPortalOwner(), uiSEOForm.getContentPath(), uiSEOForm.getOnContent());
                if (seoLocales.size() > 0) {
                    Locale locale = (Locale)seoLocales.get(0);
                    String lang = locale.getLanguage();
                    String country = locale.getCountry();
                    if (StringUtils.isNotEmpty((String)country)) {
                        lang = lang + "_" + country;
                    }
                    metaModel = seoService.getMetadata(uiSEOForm.getParamsArray(), pageReference, lang);
                    uiSEOForm.setSelectedLanguage(lang);
                }
            }
            uiSEOForm.initSEOForm(metaModel);
            int top = -1;
            int left = -1;
            if (params != null && params.length() > 0 && (arrCoordinate = params.split(",")) != null && arrCoordinate.length == 2) {
                top = Integer.parseInt(arrCoordinate[0]);
                left = Integer.parseInt(arrCoordinate[1]);
            }
            Utils.createPopupWindow((UIContainer)uiSEOToolbar, (UIComponent)uiSEOForm, (String)UISEOToolbarForm.SEO_POPUP_WINDOW, (boolean)true, (int)640);
        }
    }
}

