/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.security.SecureRandom;
import java.util.concurrent.CountDownLatch;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.web.security.security.AutoReseedRandom;
import org.picocontainer.Startable;

public class SecureRandomService
implements Startable {
    protected static final String RANDOM_ALGORITHM = "random.algorithm";
    protected static final String RANDOM_ALGORITHM_PROVIDER = "random.algorithm.provider";
    protected static final String RANDOM_RESEEDING_PERIOD_MILLISECONDS = "random.algorithm.reseeding.period.milliseconds";
    protected static final String RANDOM_SEED_LENGTH_BYTES = "random.algorithm.seed.length.bytes";
    private volatile AutoReseedRandom random;
    private final CountDownLatch initializationLatch = new CountDownLatch(1);
    private final String algorithm;
    private final String algorithmProvider;
    private final int seedLength;
    private final long reseedingPeriod;

    public SecureRandomService() {
        this.algorithm = "SHA1PRNG";
        this.algorithmProvider = AutoReseedRandom.DEFAULT_RANDOM_ALGORITHM_PROVIDER;
        this.seedLength = 32;
        this.reseedingPeriod = 86400000L;
    }

    public SecureRandomService(InitParams initParams) {
        this.algorithm = initParams != null && initParams.containsKey((Object)RANDOM_ALGORITHM) ? initParams.getValueParam(RANDOM_ALGORITHM).getValue() : "SHA1PRNG";
        this.algorithmProvider = initParams != null && initParams.containsKey((Object)RANDOM_ALGORITHM_PROVIDER) ? initParams.getValueParam(RANDOM_ALGORITHM_PROVIDER).getValue() : AutoReseedRandom.DEFAULT_RANDOM_ALGORITHM_PROVIDER;
        this.seedLength = initParams != null && initParams.containsKey((Object)RANDOM_SEED_LENGTH_BYTES) ? Integer.parseInt(initParams.getValueParam(RANDOM_SEED_LENGTH_BYTES).getValue()) : 32;
        this.reseedingPeriod = initParams != null && initParams.containsKey((Object)RANDOM_RESEEDING_PERIOD_MILLISECONDS) ? Long.parseLong(initParams.getValueParam(RANDOM_RESEEDING_PERIOD_MILLISECONDS).getValue()) : 86400000L;
    }

    public SecureRandom getSecureRandom() {
        try {
            this.initializationLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.random;
    }

    public void start() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                SecureRandomService.this.random = new AutoReseedRandom(SecureRandomService.this.algorithm, SecureRandomService.this.algorithmProvider, SecureRandomService.this.seedLength, SecureRandomService.this.reseedingPeriod);
                SecureRandomService.this.initializationLatch.countDown();
            }
        }, SecureRandomService.class.getSimpleName() + " initialization");
        t.setDaemon(true);
        t.start();
    }

    public void stop() {
    }
}

