/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.AbstractPopupAction;
import org.exoplatform.forum.common.webui.UIFormScrollSelectBox;
import org.exoplatform.forum.common.webui.UIForumFilter;
import org.exoplatform.forum.common.webui.UIPopupAction;
import org.exoplatform.forum.common.webui.UIPopupContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;

public class BaseUIForm
extends UIForm {
    protected Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    protected boolean isAddColonInLabel = false;

    public String i18n(String key) {
        ResourceBundle res = null;
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            res = context.getApplicationResourceBundle();
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            this.log.warn((Object)("Could not find key for in " + res + " for locale " + res.getLocale()));
            return key;
        }
    }

    public String getLabel(String labelID) {
        ResourceBundle res = null;
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            res = context.getApplicationResourceBundle();
            return super.getLabel(res, labelID);
        }
        catch (Exception e) {
            this.log.warn((Object)("Could not find label for " + labelID + "in " + res + " for locale " + res.getLocale()));
            return labelID;
        }
    }

    public String getLabel(ResourceBundle res, String id) {
        String label = super.getLabel(res, id);
        if (this.isAddColonInLabel && id.indexOf("action.") < 0) {
            return String.format("%s%s", label, CommonUtils.COLON);
        }
        return label;
    }

    public boolean isAddColonInLabel() {
        return this.isAddColonInLabel;
    }

    public void setAddColonInLabel(boolean isAddColonInLabel) {
        this.isAddColonInLabel = isAddColonInLabel;
    }

    public UIFormScrollSelectBox getUIFormScrollSelectBox(String name) {
        return (UIFormScrollSelectBox)this.getUIInput(name);
    }

    public UIForumFilter getUIForumFilter(String name) {
        return (UIForumFilter)this.getUIInput(name);
    }

    protected void info(String messageKey) {
        this.info(messageKey, null, true);
    }

    protected void info(String messageKey, String arg) {
        this.info(messageKey, new String[]{arg}, true);
    }

    protected void info(String messageKey, String[] args) {
        this.info(messageKey, args, true);
    }

    protected void info(String messageKey, boolean ignoreAJAXUpdateOnPortlets) {
        this.info(messageKey, null, ignoreAJAXUpdateOnPortlets);
    }

    protected void info(String messageKey, String[] args, boolean ignoreAJAXUpdateOnPortlets) {
        this.message(messageKey, args, 2, ignoreAJAXUpdateOnPortlets);
    }

    protected void warning(String messageKey) {
        this.warning(messageKey, null, true);
    }

    protected void warning(String messageKey, String arg) {
        this.warning(messageKey, new String[]{arg});
    }

    protected void warning(String messageKey, String[] args) {
        this.warning(messageKey, args, true);
    }

    protected void warning(String messageKey, boolean ignoreAJAXUpdateOnPortlets) {
        this.warning(messageKey, null, ignoreAJAXUpdateOnPortlets);
    }

    protected void warning(String messageKey, String[] args, boolean ignoreAJAXUpdateOnPortlets) {
        this.message(messageKey, args, 1, ignoreAJAXUpdateOnPortlets);
    }

    private void message(String messageKey, String[] args, int messageType, boolean ignoreAJAXUpdateOnPortlets) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        context.getUIApplication().addMessage(new ApplicationMessage(messageKey, (Object[])args, messageType));
        ((PortalRequestContext)context.getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(ignoreAJAXUpdateOnPortlets);
    }

    protected void throwWarning(String message, String ... args) throws MessageException {
        throw new MessageException(new ApplicationMessage(message, (Object[])args, 1));
    }

    protected void throwWarning(String message) throws MessageException {
        throw new MessageException(new ApplicationMessage(message, new Object[0], 1));
    }

    protected <T extends UIComponent> T openPopup(Class<T> componentType, String popupId, int width, int height) throws Exception {
        UIPortletApplication uiPortlet = (UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class);
        return this.openPopup((UIContainer)uiPortlet, componentType, popupId, width, height);
    }

    protected <T extends UIComponent> T openPopup(Class<T> componentType, int width, int height) throws Exception {
        UIPortletApplication uiPortlet = (UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class);
        return this.openPopup((UIContainer)uiPortlet, componentType, width, height);
    }

    protected <T extends UIComponent> T openPopup(Class<T> componentType, int width) throws Exception {
        return this.openPopup(componentType, width, 0);
    }

    protected <T extends UIComponent> T openPopup(Class<T> componentType, String popupId, int width) throws Exception {
        return this.openPopup(componentType, popupId, width, 0);
    }

    protected <T extends UIComponent> T openPopup(UIContainer parent, Class<T> componentType, String popupId, int width, int height) throws Exception {
        AbstractPopupAction popupAction = (AbstractPopupAction)parent.getChild(AbstractPopupAction.class);
        UIPopupContainer popupContainer = popupAction.prepareForNewForm();
        UIComponent form = popupContainer.addChild(componentType, null, null);
        form.setRendered(true);
        popupAction.activate((UIComponent)popupContainer, width, height);
        if (popupId != null) {
            popupContainer.setId(popupId);
        } else {
            popupContainer.setId(this.generateComponentId(componentType));
        }
        if (parent instanceof UIPopupContainer) {
            ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)parent);
        } else {
            ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
        return (T)form;
    }

    <T> String generateComponentId(Class<T> componentType) {
        String simpleName = componentType.getSimpleName();
        if (simpleName.startsWith("UI")) {
            simpleName = simpleName.substring(2);
        }
        return simpleName;
    }

    protected <T extends UIComponent> T openPopup(UIContainer parent, Class<T> componentType, int width, int height) throws Exception {
        return this.openPopup(parent, componentType, null, width, height);
    }

    protected void cancelChildPopupAction() throws Exception {
        UIPopupContainer popupContainer = (UIPopupContainer)this.getAncestorOfType(UIPopupContainer.class);
        UIPopupAction popupAction = popupContainer != null ? (this.getParent().getId().equals(popupContainer.getId()) ? (UIPopupAction)popupContainer.getAncestorOfType(UIPopupAction.class) : (UIPopupAction)popupContainer.getChild(UIPopupAction.class)) : (UIPopupAction)this.getAncestorOfType(UIPopupAction.class);
        popupAction.cancelPopupAction();
    }
}

