/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.security;

import org.icepdf.core.pobjects.security.EncryptionDictionary;

public class Permissions {
    private static final int PRINT_DOCUMENT_BIT_3 = -3900;
    private static final int MODIFY_DOCUMENT_BIT_4 = -3896;
    private static final int DATA_EXTRACTION_BIT_5 = -3888;
    private static final int MODIFY_TEXT_BIT_6 = -3872;
    private static final int MODIFY_FORMS_BIT_9 = -3648;
    private static final int ACCESSIBILITY_BIT_10 = -3392;
    private static final int ASSEMBLE_DOCUMENT_BIT_11 = -2880;
    private static final int PRINT_QUALITY_BIT_12 = -1856;
    public static final int PRINT_DOCUMENT = 0;
    public static final int PRINT_DOCUMENT_QUALITY = 1;
    public static final int MODIFY_DOCUMENT = 2;
    public static final int CONTENT_EXTRACTION = 3;
    public static final int AUTHORING_FORM_FIELDS = 4;
    public static final int FORM_FIELD_FILL_SIGNING = 5;
    public static final int CONTENT_ACCESSABILITY = 6;
    public static final int DOCUMENT_ASSEMBLY = 7;
    private boolean[] permissions = new boolean[10];
    private int permissionFlags = -3904;
    private int revision = 2;
    boolean isInit = false;

    public Permissions(EncryptionDictionary dictionary) {
        this.permissionFlags = dictionary.getPermissions();
        this.revision = dictionary.getRevisionNumber();
    }

    public void init() {
        for (int i = 0; i < this.permissions.length; ++i) {
            this.permissions[i] = false;
        }
        if (this.revision == 2) {
            if ((this.permissionFlags & 0xFFFFF0C4) == -3900) {
                this.permissions[0] = true;
            }
            if ((this.permissionFlags & 0xFFFFF0C8) == -3896) {
                this.permissions[2] = true;
            }
            if ((this.permissionFlags & 0xFFFFF0D0) == -3888) {
                this.permissions[3] = true;
            }
            if (this.permissions[3]) {
                this.permissions[4] = true;
            }
            if (this.permissions[3]) {
                this.permissions[5] = true;
            }
            if (this.permissions[3]) {
                this.permissions[6] = true;
            }
            if (this.permissions[2]) {
                this.permissions[7] = true;
            }
            if ((this.permissionFlags & 0xFFFFF8C0) == -1856) {
                this.permissions[1] = true;
            }
            this.isInit = true;
        } else if (this.revision == 3) {
            if ((this.permissionFlags & 0xFFFFF0C4) == -3900) {
                this.permissions[0] = true;
            }
            if ((this.permissionFlags & 0xFFFFF0C8) == -3896) {
                this.permissions[2] = true;
            }
            if ((this.permissionFlags & 0xFFFFF0D0) == -3888) {
                this.permissions[3] = true;
            }
            if ((this.permissionFlags & 0xFFFFF0E0) == -3872) {
                this.permissions[4] = true;
            }
            if ((this.permissionFlags & 0xFFFFF1C0) == -3648) {
                this.permissions[5] = true;
            }
            if ((this.permissionFlags & 0xFFFFF2C0) == -3392) {
                this.permissions[6] = true;
            }
            if ((this.permissionFlags & 0xFFFFF4C0) == -2880) {
                this.permissions[7] = true;
            }
            if ((this.permissionFlags & 0xFFFFF8C0) == -1856) {
                this.permissions[1] = true;
            }
            this.isInit = true;
        }
    }

    public boolean getPermissions(int permissionIndex) {
        if (!this.isInit) {
            this.init();
        }
        return permissionIndex >= 0 && permissionIndex <= this.permissions.length && this.permissions[permissionIndex];
    }
}

