/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.spi;

import java.util.Map;
import org.gatein.management.api.ComponentRegistration;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.core.api.operation.global.ExportResource;
import org.gatein.management.core.api.operation.global.GlobalOperationHandlers;
import org.gatein.management.spi.ExtensionContext;

public class ExtensionContextImpl
implements ExtensionContext {
    private final ManagedResource.Registration rootRegistration;
    private final Map<String, BindingProvider> bindingProviders;

    public ExtensionContextImpl(ManagedResource.Registration rootRegistration, Map<String, BindingProvider> bindingProviders) {
        this.rootRegistration = rootRegistration;
        this.bindingProviders = bindingProviders;
    }

    public ComponentRegistration registerManagedComponent(final String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return new ComponentRegistration(){

            public ManagedResource.Registration registerManagedResource(ManagedDescription description) {
                ManagedResource.Registration registration = ExtensionContextImpl.this.rootRegistration.registerSubResource(name, description);
                registration.registerOperationHandler("export-resource", (OperationHandler)GlobalOperationHandlers.EXPORT_RESOURCE, ExportResource.DESCRIPTION, true);
                return registration;
            }

            public void registerBindingProvider(BindingProvider bindingProvider) {
                ExtensionContextImpl.this.bindingProviders.put(name, bindingProvider);
            }
        };
    }
}

